/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.transport;

import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;

/**
 * Factory for creating server sockets that implement the {@link EPPServerCon}
 * interface.
 */
public abstract class EPPSrvFactory {
	/**
	 * Creates a server socket by name that implements the {@link EPPServerCon}
	 * interface.
	 *
	 * @param aServerSocketClass
	 *           Server socket by name that implements the {@link EPPServerCon}
	 *           interface.
	 *
	 * @return Server socket object that implements the {@link EPPServerCon}
	 *         interface.
	 *
	 * @throws EPPConException
	 *            Error creating server socket
	 */
	public EPPServerCon getEPPServer(String aServerSocketClass) throws EPPConException {
		EPPServerCon me = null;

		try {
			me = (EPPServerCon) Class.forName(aServerSocketClass).getDeclaredConstructor().newInstance();
		}
		catch (Exception myException) {
			throw new EPPConException(
			      "Exception : " + "Class Name " + aServerSocketClass + " " + myException.getMessage());
		}

		return me;
	}

	/**
	 * Creates a server socket implements the {@link EPPServerCon} interface
	 * based on the configuration.
	 *
	 * @return Server socket implements the {@link EPPServerCon} interface
	 *
	 * @throws EPPConException
	 *            Error creating server socket
	 */
	public EPPServerCon getEPPServer() throws EPPConException {
		EPPServerCon me = null;
		String myClassName = null;

		try {
			myClassName = EPPEnv.getServerSocketName();
		}
		catch (EPPEnvException myException) {
			throw new EPPConException("EnvException : " + myException.getMessage());
		}

		try {
			me = (EPPServerCon) Class.forName(myClassName).getDeclaredConstructor().newInstance();
		}
		catch (Exception myException) {
			throw new EPPConException("Exception : " + "Class Name " + myClassName + " " + myException.getMessage());
		}

		return me;
	}
}
