/***********************************************************
Copyright (C) 2017 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ***********************************************************/
package com.verisign.epp.codec.fee.v1_0;

import java.security.InvalidParameterException;

/**
 * Commands, which include the following possible values:<br>
 * <ul>
 * <li><code>CREATE</code> - Create command.</li>
 * <li><code>DELETE</code> - Delete command.</li>
 * <li><code>RENEW</code> - Renew command.</li>
 * <li><code>UPDATE</code> - Update command.</li>
 * <li><code>TRANSFER</code> - Transfer command.</li>
 * <li><code>RESTORE</code> - Restore command.</li>
 * <li><code>CUSTOM</code> - Custom command that is defined using a free-form
 * attribute like the &quot;customName&quot; attribute.</li>
 * </ul>
 */
public enum Command {
	CREATE("create"), DELETE("delete"), RENEW("renew"), UPDATE("update"), TRANSFER("transfer"), RESTORE(
	      "restore"), CUSTOM("custom");

	private final String commandStr;

	/**
	 * Define the string value for the enumerated value.
	 * 
	 * @param aCommandStr
	 *           Enumerated value string
	 */
	Command(String aCommandStr) {
		this.commandStr = aCommandStr;
	}

	/**
	 * Get the command enumerated value given the matching string.
	 * 
	 * @param aString
	 *           <code>Command</code> enumerated string to convert to an
	 *           enumerated <code>Command</code> instance.
	 * 
	 * @return Enumerated <code>Command</code> value matching the
	 *         <code>String</code>.
	 * 
	 * @throws InvalidParameterException
	 *            If <code>aString</code> does not match an enumerated
	 *            <code>Command</code> string value.
	 */
	public static Command getCommand(String aString) {
		if (aString.equals(CREATE.commandStr)) {
			return CREATE;
		}
		else if (aString.equals(DELETE.commandStr)) {
			return DELETE;
		}
		else if (aString.equals(RENEW.commandStr)) {
			return RENEW;
		}
		else if (aString.equals(UPDATE.commandStr)) {
			return UPDATE;
		}
		else if (aString.equals(TRANSFER.commandStr)) {
			return TRANSFER;
		}
		else if (aString.equals(RESTORE.commandStr)) {
			return RESTORE;
		}
		else if (aString.equals(CUSTOM.commandStr)) {
			return CUSTOM;
		}
		else {
			throw new InvalidParameterException("Command enum value of " + aString + " is not valid.");
		}
	}

	/**
	 * Convert the enumerated <code>Command</code> value to a
	 * <code>String</code>.
	 */
	public String toString() {
		return this.commandStr;
	}

}
