/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util.secureauthinfo;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import java.security.SecureRandom;
import java.util.Random;

public class EPPAuthInfoFactory {
    private static char[] printableAsciiSymbols;
    private static SecureRandom random;

    public static char[] createAuthInfoPassword(int aLength) {
        return EPPAuthInfoFactory.createAuthInfoPassword(aLength, random, printableAsciiSymbols);
    }

    public static String createAuthInfoPasswordStr(int aLength) {
        return new String(EPPAuthInfoFactory.createAuthInfoPassword(aLength));
    }

    public static char[] createAuthInfoPassword(int aLength, Random aRandom, char[] aSymbols) {
        if (aLength < 1) {
            throw new IllegalArgumentException("Length of auth info password must be >= 1");
        }
        if (aSymbols.length < 2) {
            throw new IllegalArgumentException("Symbols of auth info password must be >= 2");
        }
        char[] theAuthInfoArr = new char[aLength];
        for (int theIndex = 0; theIndex < aLength; ++theIndex) {
            theAuthInfoArr[theIndex] = aSymbols[aRandom.nextInt(printableAsciiSymbols.length)];
        }
        return theAuthInfoArr;
    }

    public static String createAuthInfoPasswordStr(int aLength, Random aRandom, char[] aSymbols) {
        return new String(EPPAuthInfoFactory.createAuthInfoPassword(aLength, aRandom, aSymbols));
    }

    public static EPPAuthInfo createAuthInfo(int aLength) {
        return new EPPAuthInfo(EPPAuthInfoFactory.createAuthInfoPasswordStr(aLength));
    }

    static {
        random = new SecureRandom();
        printableAsciiSymbols = new char[94];
        int theBaseSymbol = 33;
        for (int theIndex = 0; theIndex < 94; ++theIndex) {
            EPPAuthInfoFactory.printableAsciiSymbols[theIndex] = (char)(theBaseSymbol + theIndex);
        }
    }
}

