/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPEntityResolver;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPXMLErrorHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EPPXMLParser
extends DocumentBuilder {
    public static final String POOL = "EPP_XML_PARSER_POOL";
    private DocumentBuilder _parser = null;
    private static DocumentBuilderFactory _factory = DocumentBuilderFactory.newInstance();
    private static Logger cat;

    public EPPXMLParser() {
        try {
            this._parser = _factory.newDocumentBuilder();
            this._parser.setErrorHandler(new EPPXMLErrorHandler());
            this._parser.setEntityResolver(new EPPEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            cat.error("EPPXMLParser(): Error initializing parser: " + ex);
            ex.printStackTrace();
        }
    }

    public EPPXMLParser(boolean validateSchema) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validateSchema);
            factory.setNamespaceAware(true);
            this._parser = factory.newDocumentBuilder();
            this._parser.setErrorHandler(new EPPXMLErrorHandler());
            this._parser.setEntityResolver(new EPPEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            cat.error("EPPXMLParser(): Error initializing parser: " + ex);
            ex.printStackTrace();
        }
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this._parser.getDOMImplementation();
    }

    @Override
    public boolean isNamespaceAware() {
        return this._parser.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this._parser.isValidating();
    }

    @Override
    public Document parse(File aFile) throws SAXException, IOException {
        return this._parser.parse(aFile);
    }

    @Override
    public Document parse(InputStream aStream) throws SAXException, IOException {
        return this._parser.parse(aStream);
    }

    @Override
    public Document parse(InputSource aSource) throws SAXException, IOException {
        return this._parser.parse(aSource);
    }

    @Override
    public Document parse(InputStream aStream, String aSystemId) throws SAXException, IOException {
        return this._parser.parse(aStream, aSystemId);
    }

    @Override
    public Document parse(String aURI) throws SAXException, IOException {
        return this._parser.parse(aURI);
    }

    @Override
    public void setEntityResolver(EntityResolver aResolver) {
        this._parser.setEntityResolver(aResolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler aHandler) {
        this._parser.setErrorHandler(aHandler);
    }

    @Override
    public Document newDocument() {
        return this._parser.newDocument();
    }

    static {
        _factory.setNamespaceAware(true);
        _factory.setValidating(EPPEnv.getValidating());
        cat = LoggerFactory.getLogger(EPPXMLParser.class);
    }
}

