/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EPPParserException;
import com.verisign.epp.util.EPPSchemaCacher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EPPSchemaCachingEntityResolver
implements XMLEntityResolver,
EntityResolver {
    private static int count;
    private static Logger cat;
    private EPPSchemaCacher schemaCache;

    public EPPSchemaCachingEntityResolver(EPPSchemaCacher aSchemaCache) {
        cat.debug("EPPSchemaCachingEntityResolver(EPPSchemaCacher) enter");
        this.schemaCache = aSchemaCache;
        cat.debug("EPPSchemaCachingEntityResolver(EPPSchemaCacher) exit");
    }

    @Override
    public InputSource resolveEntity(String aPublicId, String aSystemId) throws SAXException, IOException {
        cat.debug("resolveEntity(String, String): enter");
        cat.info("resolveEntity(String, String): Entity not found in grammar pool - public Id: " + aPublicId + " systemId: " + aSystemId);
        File tmpFile = new File(aSystemId);
        String literalId = tmpFile.getName();
        InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        if (schemaStream == null) {
            cat.info("resolveEntity(String, String): Unable to find XML schema in classpath prior to loading in cache");
            throw new SAXException("Couldn't locate resource: " + literalId);
        }
        try {
            this.schemaCache.addSchemaToCache(new XMLInputSource(literalId, literalId, aSystemId, schemaStream, null));
        }
        catch (EPPParserException e) {
            cat.info("resolveEntity(String, String): EPPParserException caught while trying to add schema to cache");
            throw new XNIException((Exception)e);
        }
        InputStream retStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        if (retStream == null) {
            cat.info("resolveEntity(String, String): Unable to find XML schema in classpath after loading in cache");
            throw new SAXException("Couldn't locate resource: " + literalId);
        }
        InputSource retSource = new InputSource(retStream);
        cat.debug("resolveEntity(String, String): exit");
        return retSource;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier aResourceIdentifier) throws XNIException, IOException {
        cat.debug("resolvEntity(XMLResourceIdentifier): enter");
        String publicId = aResourceIdentifier.getPublicId();
        String systemId = aResourceIdentifier.getBaseSystemId();
        String literalId = aResourceIdentifier.getLiteralSystemId();
        cat.info("resolvEntity(XMLResourceIdentifier): Entity not found in grammar pool - public Id: " + publicId + " systemId: " + systemId + " literalId: " + literalId);
        InputStream schemaStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        if (schemaStream == null) {
            cat.info("resolvEntity(XMLResourceIdentifier): EPPParserException caught while trying to add schema to cache");
            throw new XNIException("Couldn't locate resource: " + literalId);
        }
        try {
            this.schemaCache.addSchemaToCache(new XMLInputSource(literalId, literalId, systemId, schemaStream, null));
        }
        catch (EPPParserException e) {
            cat.info("EPPParserException caught while trying to add schema to cache");
            throw new XNIException((Exception)e);
        }
        InputStream retStream = this.getClass().getClassLoader().getResourceAsStream("schemas/" + literalId);
        if (retStream == null) {
            cat.info("resolvEntity(XMLResourceIdentifier): Unable to find XML schema in classpath after loading in cache");
            throw new XNIException("Couldn't locate resource: " + literalId);
        }
        XMLInputSource retSource = new XMLInputSource(literalId, literalId, systemId, retStream, null);
        cat.debug("resolveEntity(aPublicId, aSystemId) exit");
        return retSource;
    }

    static {
        cat = LoggerFactory.getLogger(EPPSchemaCachingEntityResolver.class);
    }
}

