/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSSLClientSocket
implements EPPClientCon {
    private static Logger cat = LoggerFactory.getLogger(EPPSSLClientSocket.class);
    private SSLSocket socket = null;
    private OutputStream outputStream = null;
    private InputStream inputStream = null;
    private String hostName = null;
    private int portNumber = 0;
    private String clientHostName = null;
    private boolean isConnected = true;
    private int conTimeOut = 5000;
    private int readTimeOut = 5000;
    private EPPSSLContext sslContext = null;

    public EPPSSLClientSocket() throws EPPConException {
        try {
            this.hostName = EPPEnv.getServerName();
            this.portNumber = EPPEnv.getServerPort();
            this.conTimeOut = EPPEnv.getConTimeOut();
            this.readTimeOut = EPPEnv.getReadTimeOut();
            this.clientHostName = EPPEnv.getClientHost();
        }
        catch (EPPEnvException myException) {
            cat.error("Connection Failed Due to : " + myException.getMessage(), (Throwable)myException);
            throw new EPPConException("Connection Failed Due to : " + myException.getMessage());
        }
    }

    @Override
    public void initialize() throws EPPConException {
        cat.debug("Starting EPPSSLClientSocket.initialize()");
        if (this.sslContext == null) {
            EPPSSLImpl.initialize();
            this.sslContext = EPPSSLImpl.getEPPSSLContext();
        }
        SSLSocketFactory mySSLSocketFactory = this.sslContext.getSSLSocketFactory();
        try {
            if (this.clientHostName == null) {
                cat.debug("EPPSSLClientSocket.initialize(): Connecting to server host = " + this.hostName + ", server port = " + this.portNumber + ", conTimeOut = " + this.conTimeOut);
                this.socket = (SSLSocket)mySSLSocketFactory.createSocket();
                this.socket.connect(new InetSocketAddress(this.hostName, this.portNumber), this.conTimeOut);
            } else {
                cat.debug("EPPSSLClientSocket.initialize(): Connecting to server host = " + this.hostName + ", server port = " + this.portNumber + ", conTimeOut = " + this.conTimeOut + " from client host = " + this.clientHostName);
                InetAddress theClientAddress = InetAddress.getByName(this.clientHostName);
                this.socket = (SSLSocket)mySSLSocketFactory.createSocket();
                this.socket.bind(new InetSocketAddress(theClientAddress, 0));
                this.socket.connect(new InetSocketAddress(this.hostName, this.portNumber), this.conTimeOut);
            }
            if (cat.isDebugEnabled()) {
                cat.debug("EPPSSLClientSocket.initialize(): Supported Protocols = [" + this.getSSLPropertyListString(this.socket.getSupportedProtocols()) + "], Supported Cipher Suites = [" + this.getSSLPropertyListString(this.socket.getSupportedCipherSuites()) + "]");
            }
            if (this.sslContext.hasSSLEnabledProtocols()) {
                cat.debug("EPPSSLClientSocket.initialize(): Enabled Protocols = [" + this.getSSLPropertyListString(this.sslContext.getSSLEnabledProtocols()) + "]");
                this.socket.setEnabledProtocols(this.sslContext.getSSLEnabledProtocols());
            } else {
                cat.debug("EPPSSLClientSocket.initialize(): Enabled Protocols NOT specified, using providers default");
            }
            if (this.sslContext.hasSSLEnabledCipherSuites()) {
                cat.debug("EPPSSLClientSocket.initialize(): Enabled Cipher Suites = [" + this.getSSLPropertyListString(this.sslContext.getSSLEnabledCipherSuites()) + "]");
                this.socket.setEnabledCipherSuites(this.sslContext.getSSLEnabledCipherSuites());
            } else {
                cat.debug("EPPSSLClientSocket.initialize(): Enabled Cipher Suites NOT specified, using providers default");
            }
            cat.debug("EPPSSLClientSocket.initialize(): Using readTimeOut = " + this.readTimeOut);
            this.socket.setSoTimeout(this.readTimeOut);
            this.socket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent aEvent) {
                    try {
                        cat.debug("Client SSL Handshake: Cipher = " + aEvent.getCipherSuite() + ": Protocol = " + aEvent.getSession().getProtocol() + ": Peer = " + aEvent.getSession().getPeerPrincipal().getName() + ": Issuer = " + ((X509Certificate)aEvent.getPeerCertificates()[0]).getIssuerDN().getName());
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException ex) {
            cat.error("Could not create an SSLSocket: ", (Throwable)ex);
            throw new EPPConException("Could not create an SSLSocket: " + ex.getMessage());
        }
        cat.debug("EPPSSLClientSocket.initialize(): SSL startHandshake");
        try {
            this.socket.startHandshake();
        }
        catch (IOException myException) {
            cat.error("Failed When Handshake : " + myException.getMessage(), (Throwable)myException);
            throw new EPPConException("Failed When HandShake : " + myException.getMessage());
        }
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException ex) {
            cat.error("Failed getting streams from SSLSocket: ", (Throwable)ex);
            throw new EPPConException("Failed getting streams from SSLSocket: " + ex.getMessage());
        }
        this.isConnected = true;
        cat.debug("Ending EPPSSLClientSocket.initialize()");
    }

    @Override
    public void initialize(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPConException {
        this.hostName = aHostName;
        this.portNumber = aPortNumber;
        this.sslContext = aSSLContext;
        this.initialize();
    }

    @Override
    public void initialize(String aHostName, int aPortNumber, String aClientHostName, EPPSSLContext aSSLContext) throws EPPConException {
        this.hostName = aHostName;
        this.portNumber = aPortNumber;
        this.clientHostName = aClientHostName;
        this.sslContext = aSSLContext;
        this.initialize();
    }

    @Override
    public InputStream getInputStream() throws EPPConException {
        if (this.inputStream == null) {
            cat.error("getInputStream(): No InputStream set");
            throw new EPPConException("No InputStream set");
        }
        return this.inputStream;
    }

    protected void setInputStream(InputStream aInputStream) {
        this.inputStream = aInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws EPPConException {
        if (this.outputStream == null) {
            cat.error("getInputStream(): No OutputStream set");
            throw new EPPConException("No OutputStream set");
        }
        return this.outputStream;
    }

    protected void setOutputStream(OutputStream aOutputStream) {
        this.outputStream = aOutputStream;
    }

    public SSLSocket getSocket() {
        return this.socket;
    }

    protected void setSocket(SSLSocket aSocket) {
        this.socket = aSocket;
    }

    public EPPSSLContext getSslContext() {
        return this.sslContext;
    }

    protected void setSslContext(EPPSSLContext aSslContext) {
        this.sslContext = aSslContext;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    protected void setClientHostName(String aClientHostName) {
        this.clientHostName = aClientHostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    protected void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    protected void setPortNumber(int aPortNumber) {
        this.portNumber = aPortNumber;
    }

    public int getConTimeout() {
        return this.conTimeOut;
    }

    protected void setConTimeout(int aConTimeout) {
        this.conTimeOut = aConTimeout;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected void setConnected(boolean aIsConnected) {
        this.isConnected = aIsConnected;
    }

    @Override
    public void close() throws EPPConException {
        cat.debug("EPPSSLClientSocket.close(): Starting the Method");
        if (!this.isConnected) {
            return;
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException ex) {
            cat.error("close(): Failure in closing streams", (Throwable)ex);
            throw new EPPConException("Failure closing streams : " + ex.getMessage());
        }
        catch (SecurityException ex) {
            cat.error("close() : Failure in closing streams", (Throwable)ex);
        }
        finally {
            this.isConnected = false;
        }
        cat.debug("EPPSSLClientSocket.close(): Ending the Method");
    }

    protected String getSSLPropertyListString(String[] aList) {
        if (aList == null) {
            return null;
        }
        String theStr = "";
        for (int i = 0; i < aList.length; ++i) {
            if (i > 0) {
                theStr = theStr + " ";
            }
            theStr = theStr + aList[i];
        }
        return theStr;
    }
}

