/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.orgext.EPPOrgExtCreate;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.codec.orgext.EPPOrgExtInfData;
import com.verisign.epp.codec.orgext.EPPOrgExtUpdate;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgExtDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(OrgExtDomainHandler.class);

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        SessionData theSessionData = (SessionData)aData;
        if (theSessionData.getLoginCmd().hasExtensionService("urn:ietf:params:xml:ns:epp:orgext-1.0") && theCommand.getName().equalsIgnoreCase("org.example")) {
            EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
            EPPOrgExtInfData theExt = new EPPOrgExtInfData();
            theExt.addOrgId(new EPPOrgExtId("reseller", "myreseller"));
            theExt.addOrgId(new EPPOrgExtId("privacyproxy", "myproxy"));
            theResponse.addExtension(theExt);
        }
        cat.info("doDomainInfo: EPPOrgExt added to response");
        System.out.println("doDomainInfo: EPPOrgExt added to response");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPOrgExtCreate.class)) {
            EPPOrgExtCreate theExt = (EPPOrgExtCreate)theCommand.getExtension(EPPOrgExtCreate.class);
            if (theExt.hasOrgIds()) {
                for (EPPOrgExtId theOrgId : theExt.getOrgIds()) {
                    System.out.println("doDomainCreate: org role = " + theOrgId.getRole());
                    cat.info("doDomainCreate: org role = " + theOrgId.getRole());
                    System.out.println("doDomainCreate: org identifer = " + theOrgId.getOrgId());
                    cat.info("doDomainCreate: org identifer = " + theOrgId.getOrgId());
                }
            }
        } else {
            cat.info("doDomainCreate: Org Extension = null");
            System.out.println("doDomainCreate: Org Extension = null");
        }
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPOrgExtUpdate.class)) {
            EPPOrgExtUpdate theExt = (EPPOrgExtUpdate)theCommand.getExtension(EPPOrgExtUpdate.class);
            if (theExt.hasAddOrgs()) {
                cat.info("doDomainUpdate: Add organizations = " + theExt.getAddOrgs());
                System.out.println("doDomainUpdate: Add organizations = " + theExt.getAddOrgs());
            }
            if (theExt.hasRemOrgs()) {
                cat.info("doDomainUpdate: Remove organizations = " + theExt.getRemOrgs());
                System.out.println("doDomainUpdate: Remove organizations = " + theExt.getRemOrgs());
            }
            if (theExt.hasChgOrgs()) {
                cat.info("doDomainUpdate: Change organizations = " + theExt.getChgOrgs());
                System.out.println("doDomainUpdate: Change organizations = " + theExt.getChgOrgs());
            }
        } else {
            cat.info("doDomainUpdate: Org Extension = null");
            System.out.println("doDomainUpdate: Org Extension = null");
        }
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        return theEventResponse;
    }
}

