/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.allocationtoken.EPPAllocationToken;
import com.verisign.epp.codec.changepoll.EPPChangeCaseId;
import com.verisign.epp.codec.changepoll.EPPChangeData;
import com.verisign.epp.codec.changepoll.EPPChangeOperation;
import com.verisign.epp.codec.coaext.EPPCoaExtAttr;
import com.verisign.epp.codec.coaext.EPPCoaExtCreate;
import com.verisign.epp.codec.coaext.EPPCoaExtInfData;
import com.verisign.epp.codec.coaext.EPPCoaExtKey;
import com.verisign.epp.codec.coaext.EPPCoaExtUpdate;
import com.verisign.epp.codec.coaext.EPPCoaExtValue;
import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCheck;
import com.verisign.epp.codec.fee.v1_0.EPPFeeCreate;
import com.verisign.epp.codec.fee.v1_0.EPPFeeRenew;
import com.verisign.epp.codec.fee.v1_0.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v1_0.EPPFeeUpdate;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.idnext.EPPIdnLangTag;
import com.verisign.epp.codec.idnmap.EPPIdnMap;
import com.verisign.epp.codec.launch.EPPLaunchCheck;
import com.verisign.epp.codec.launch.EPPLaunchCreate;
import com.verisign.epp.codec.launch.EPPLaunchDelete;
import com.verisign.epp.codec.launch.EPPLaunchInfo;
import com.verisign.epp.codec.launch.EPPLaunchUpdate;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollResponse;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollThreshold;
import com.verisign.epp.codec.namestoreext.EPPNamestoreExtNSExtErrData;
import com.verisign.epp.codec.namestoreext.EPPNamestoreExtNamestoreExt;
import com.verisign.epp.codec.orgext.EPPOrgExtCreate;
import com.verisign.epp.codec.orgext.EPPOrgExtUpdate;
import com.verisign.epp.codec.persreg.EPPPersRegCreateData;
import com.verisign.epp.codec.persreg.EPPPersRegCreateErrData;
import com.verisign.epp.codec.persreg.EPPPersRegRenewData;
import com.verisign.epp.codec.persreg.EPPPersRegTransferData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtReport;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpData;
import com.verisign.epp.codec.rgpext.EPPRgpExtUpdate;
import com.verisign.epp.codec.rgppoll.EPPRgpPollResponse;
import com.verisign.epp.codec.rgppoll.EPPRgpPollStatus;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtUpdate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.syncext.EPPSyncExtUpdate;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfo;
import com.verisign.epp.codec.whois.EPPWhoisInf;
import com.verisign.epp.codec.whois.EPPWhoisInfData;
import com.verisign.epp.framework.EPPDomainHandler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.AllocationTokenDomainHandler;
import com.verisign.epp.serverstub.ChangePollDomainHandler;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.FeeDomainHandler;
import com.verisign.epp.serverstub.IdnMapDomainHandler;
import com.verisign.epp.serverstub.LaunchDomainHandler;
import com.verisign.epp.serverstub.OrgExtDomainHandler;
import com.verisign.epp.serverstub.PersRegDomainHandler;
import com.verisign.epp.serverstub.RelatedDomainHandler;
import com.verisign.epp.serverstub.SecDNSV10SubDomainHandler;
import com.verisign.epp.serverstub.SecDNSV11SubDomainHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.serverstub.VerificationCodeDomainHandler;
import com.verisign.epp.serverstub.secureauthinfo.v1_0.SecureAuthInfoDomainHandler;
import com.verisign.epp.serverstub.unhandlednamespaces.v1_0.UnhandledNamespacesDomainHandler;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSDomainHandler
extends EPPDomainHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "NS1EXAMPLE1-VRSN";
    private static long ONE_YEAR_TIME = 31536000000L;
    private static Logger cat = LoggerFactory.getLogger(NSDomainHandler.class);
    DomainHandler domainHandler = new DomainHandler();
    SecDNSV10SubDomainHandler v10SubHandler = new SecDNSV10SubDomainHandler();
    SecDNSV11SubDomainHandler v11SubHandler = new SecDNSV11SubDomainHandler();
    PersRegDomainHandler pergRegDomainHandler = new PersRegDomainHandler();
    LaunchDomainHandler launchDomainHandler = new LaunchDomainHandler();
    RelatedDomainHandler relatedDomainHandler = new RelatedDomainHandler();
    AllocationTokenDomainHandler allocationTokenDomainHandler = new AllocationTokenDomainHandler();
    OrgExtDomainHandler orgDomainHandler = new OrgExtDomainHandler();
    FeeDomainHandler feeDomainHandler = new FeeDomainHandler();
    ChangePollDomainHandler changePollDomainHandler = new ChangePollDomainHandler();
    IdnMapDomainHandler idnMapDomainHandler = new IdnMapDomainHandler();
    VerificationCodeDomainHandler verificationCodeDomainHandler = new VerificationCodeDomainHandler();
    SecureAuthInfoDomainHandler secureAuthInfoDomainHandler = new SecureAuthInfoDomainHandler();
    UnhandledNamespacesDomainHandler unhandledNamespacesDomainHandler = new UnhandledNamespacesDomainHandler();

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        EPPNamestoreExtNamestoreExt theExt;
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class) && (theExt = (EPPNamestoreExtNamestoreExt)theMessage.getExtension(EPPNamestoreExtNamestoreExt.class)).getSubProductID().equals("BAD")) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResult result = new EPPResult(2306);
            result.addExtValueReason("Invalid sub-product id " + theExt.getSubProductID());
            EPPResponse theResponse = new EPPResponse(transId, result);
            theResponse.addExtension(new EPPNamestoreExtNSExtErrData(1));
            throw new EPPHandleEventException("Invalid sub-product id " + theExt.getSubProductID(), theResponse);
        }
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theMessage = (EPPDomainCheckCmd)aEvent.getMessage();
        cat.debug("doDomainCheck: command = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPLaunchCheck.class)) {
            EPPEventResponse launchResp = this.launchDomainHandler.doDomainCheck(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)launchResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return launchResp;
        }
        if (theMessage.hasExtension(EPPAllocationToken.class)) {
            EPPEventResponse allocationTokenResp = this.allocationTokenDomainHandler.doDomainCheck(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)allocationTokenResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return allocationTokenResp;
        }
        if (theMessage.hasExtension(EPPFeeCheck.class)) {
            EPPEventResponse feeResp = this.feeDomainHandler.doDomainCheck(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)feeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return feeResp;
        }
        Vector vNames = theMessage.getNames();
        Enumeration eNames = vNames.elements();
        Vector<EPPDomainCheckResult> vResults = new Vector<EPPDomainCheckResult>();
        boolean available = true;
        while (eNames.hasMoreElements()) {
            String domainName = (String)eNames.nextElement();
            vResults.addElement(new EPPDomainCheckResult(domainName, available));
            available = !available;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainCheckResp theResponse = new EPPDomainCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theMessage = (EPPDomainRenewCmd)aEvent.getMessage();
        cat.debug("doDomainRenew: command = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPRelatedDomainExtRenew.class)) {
            EPPEventResponse relatedResp = this.relatedDomainHandler.doDomainRenew(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)relatedResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return relatedResp;
        }
        if (theMessage.hasExtension(EPPFeeRenew.class)) {
            EPPEventResponse feeResp = this.feeDomainHandler.doDomainRenew(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)feeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return feeResp;
        }
        if (theMessage.hasExtension(EPPEncodedSignedCode.class)) {
            EPPEventResponse verificationCodeResp = this.verificationCodeDomainHandler.doDomainRenew(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)verificationCodeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return verificationCodeResp;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        if (theMessage.getName().startsWith("TESTBUNDLE") && theMessage.getName().endsWith(".NAME")) {
            theResponse.addExtension(new EPPPersRegRenewData(true));
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theMessage = (EPPDomainDeleteCmd)aEvent.getMessage();
        cat.debug("doDomainDelete: command = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPLaunchDelete.class)) {
            EPPEventResponse launchResp = this.launchDomainHandler.doDomainDelete(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)launchResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return launchResp;
        }
        if (theMessage.hasExtension(EPPRelatedDomainExtDelete.class)) {
            EPPEventResponse relatedResp = this.relatedDomainHandler.doDomainDelete(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)relatedResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return relatedResp;
        }
        if (theMessage.getName().equalsIgnoreCase("delete-credit.com")) {
            EPPEventResponse feeResp = this.feeDomainHandler.doDomainDelete(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)feeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return feeResp;
        }
        if (theMessage.hasExtension(EPPEncodedSignedCode.class)) {
            EPPEventResponse verificationCodeResp = this.verificationCodeDomainHandler.doDomainDelete(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)verificationCodeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return verificationCodeResp;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPResult theResult;
        EPPResponse theResponse;
        EPPCoaExtCreate create;
        EPPDomainCreateCmd theMessage = (EPPDomainCreateCmd)aEvent.getMessage();
        cat.debug("doDomainCreate: command = [" + theMessage + "]");
        if (theMessage.getName().equals("pending.com") || theMessage.getName().equals("pending-approve.com") || theMessage.getName().equals("pending-denied.com")) {
            EPPEventResponse createResp = this.domainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)createResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return createResp;
        }
        if (theMessage.hasExtension(EPPLaunchCreate.class)) {
            EPPEventResponse launchResp = this.launchDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)launchResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return launchResp;
        }
        if (theMessage.hasExtension(EPPRelatedDomainExtCreate.class)) {
            EPPEventResponse relatedResp = this.relatedDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)relatedResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return relatedResp;
        }
        if (theMessage.hasExtension(EPPAllocationToken.class)) {
            EPPEventResponse allocationTokenResp = this.allocationTokenDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)allocationTokenResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return allocationTokenResp;
        }
        if (theMessage.hasExtension(EPPOrgExtCreate.class)) {
            EPPEventResponse orgResp = this.orgDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)orgResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return orgResp;
        }
        if (theMessage.hasExtension(EPPFeeCreate.class)) {
            EPPEventResponse feeResp = this.feeDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)feeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return feeResp;
        }
        if (theMessage.getName().equalsIgnoreCase("change-poll.tld")) {
            EPPEventResponse changePollResp = this.changePollDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)changePollResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return changePollResp;
        }
        if (theMessage.hasExtension(EPPIdnMap.class) || theMessage.hasExtension(EPPIdnMap.class)) {
            EPPEventResponse idnMapResp = this.idnMapDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)idnMapResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return idnMapResp;
        }
        if (theMessage.hasExtension(EPPEncodedSignedCode.class)) {
            EPPEventResponse verificationCodeResp = this.verificationCodeDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)verificationCodeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            if (theMessage.getName().startsWith("cvct-delayed-real-name")) {
                EPPTransId changeTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
                Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
                statuses.addElement(new EPPDomainStatus("serverHold"));
                EPPDomainInfoResp thePollMsg = new EPPDomainInfoResp(changeTransId, "EXAMPLE1-REP", theMessage.getName(), "ClientX", statuses, "ClientY", new GregorianCalendar(2012, 4, 3).getTime(), null);
                thePollMsg.setLastUpdatedBy("verifyBatch");
                thePollMsg.setLastUpdatedDate(new Date(System.currentTimeMillis()));
                thePollMsg.setExpirationDate(new GregorianCalendar(2018, 4, 3).getTime());
                EPPChangeData changeData = new EPPChangeData(new EPPChangeOperation("update"), new Date(System.currentTimeMillis()), "12345-XYZ", "verifyBatch", "after", null, "Locale Data Policy", null);
                thePollMsg.addExtension(changeData);
                try {
                    EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
                }
                catch (EPPPollQueueException ex) {
                    cat.error("doDomainCreate: Error putting message [" + thePollMsg + "]");
                    EPPResult theResult2 = new EPPResult(2400);
                    EPPResponse theResponse2 = new EPPResponse(changeTransId, theResult2);
                    return new EPPEventResponse(theResponse2);
                }
                thePollMsg.setResult(1001);
            }
            return verificationCodeResp;
        }
        if (theMessage.getName().endsWith(".name")) {
            EPPEventResponse persRegResp = this.pergRegDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)persRegResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return persRegResp;
        }
        if (theMessage.getName().startsWith("EPPSecureAuthInfoTst")) {
            EPPEventResponse secureAuthInfoResp = this.secureAuthInfoDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)secureAuthInfoResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return secureAuthInfoResp;
        }
        if (theMessage.getName().equals("un-poll-messages.com")) {
            EPPEventResponse unhandledNamespacesInfoResp = this.unhandledNamespacesDomainHandler.doDomainCreate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)unhandledNamespacesInfoResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return unhandledNamespacesInfoResp;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.hasExtension(EPPIdnLangTag.class)) {
            EPPIdnLangTag theExt = (EPPIdnLangTag)theMessage.getExtension(EPPIdnLangTag.class);
            cat.debug("doDomainCreate: Request for IDN domain with langauge tag = " + theExt.getLang());
        }
        if (theMessage.hasExtension(EPPCoaExtCreate.class) && (create = (EPPCoaExtCreate)theMessage.getExtension(EPPCoaExtCreate.class)) != null) {
            List attrList = create.getAttrs();
            for (EPPCoaExtAttr attr : attrList) {
                String key = attr.getKey().getKey();
                String value = attr.getValue().getValue();
                cat.info("Client Object Attribute to create: key='" + key + "', value='" + value + "'");
            }
        }
        if (theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate.class) && theMessage.hasExtension(EPPSecDNSExtCreate.class)) {
            cat.error("NSDomainHandler.doDomainCreate: both v10 and v11 of EPPSecDNSExtCreate passed.");
            EPPResult theResult3 = new EPPResult(2306);
            theResult3.addExtValueReason("Both v10 and v11 of secDNS extension passed");
            theResponse = new EPPResponse(null, theResult3);
        } else if (theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtCreate.class)) {
            theResponse = this.v10SubHandler.doDomainCreate(theMessage, aData);
        } else if (theMessage.hasExtension(EPPSecDNSExtCreate.class)) {
            theResponse = this.v11SubHandler.doDomainCreate(theMessage, aData);
        } else {
            cat.info("NSDomainHandler.doDomainCreate: no EPPSecDNSExtCreate extension");
            theResponse = new EPPDomainCreateResp(transId, theMessage.getName(), new Date());
        }
        theResponse.setTransId(transId);
        if (!theResponse.isSuccess()) {
            cat.error("doDomainCreate: Error response in handling dnssec extension");
            return new EPPEventResponse(theResponse);
        }
        ((EPPDomainCreateResp)theResponse).setExpirationDate(new Date());
        if (theMessage.getName().equals("NSPollTst.com")) {
            Object thePollMsg = null;
            try {
                Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
                statuses.addElement(new EPPDomainStatus("serverUpdateProhibited"));
                statuses.addElement(new EPPDomainStatus("serverDeleteProhibited"));
                statuses.addElement(new EPPDomainStatus("serverTransferProhibited"));
                EPPDomainInfoResp theDomainInfoResp = new EPPDomainInfoResp(null, "EXAMPLE1-REP", "change-poll.tld", "ClientX", statuses, "ClientY", new GregorianCalendar(2012, 4, 3).getTime(), null);
                theDomainInfoResp.setRegistrant("jd1234");
                if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                    Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
                    contacts.addElement(new EPPDomainContact("sh8013", "admin"));
                    contacts.addElement(new EPPDomainContact("sh8013", "tech"));
                    theDomainInfoResp.setContacts(contacts);
                }
                theDomainInfoResp.setLastUpdatedBy("ClientZ");
                theDomainInfoResp.setLastUpdatedDate(new GregorianCalendar(2013, 10, 22).getTime());
                theDomainInfoResp.setExpirationDate(new GregorianCalendar(2014, 4, 3).getTime());
                EPPChangeData changeData = new EPPChangeData(new EPPChangeOperation("update"), new GregorianCalendar(2013, 10, 22).getTime(), "12345-XYZ", "URS Admin", "after", new EPPChangeCaseId("urs123", "urs"), "URS Lock", null);
                theDomainInfoResp.addExtension(changeData);
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theDomainInfoResp, null);
                EPPLowBalancePollResponse theLowBalanceMsg = new EPPLowBalancePollResponse();
                theLowBalanceMsg.setRegistrarName("Test Registar");
                theLowBalanceMsg.setCreditLimit("1000");
                theLowBalanceMsg.setCreditThreshold(new EPPLowBalancePollThreshold("PERCENT", "10"));
                theLowBalanceMsg.setAvailableCredit("80");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theLowBalanceMsg, null);
                EPPRgpPollResponse theRGPMsg = new EPPRgpPollResponse();
                theRGPMsg.setName(theMessage.getName());
                theRGPMsg.setReportDueDate(new Date(System.currentTimeMillis() + 3600L));
                theRGPMsg.setTransId(transId);
                theRGPMsg.setReqDate(new Date(System.currentTimeMillis()));
                theRGPMsg.setStatus(new EPPRgpPollStatus("pendingRestore"));
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theRGPMsg, null);
                EPPDomainPendActionMsg thePendActionMsg = new EPPDomainPendActionMsg(transId, theMessage.getName(), true, new EPPTransId(theMessage.getTransId(), svrTransId), new Date());
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", thePendActionMsg, null);
                thePendActionMsg = new EPPDomainPendActionMsg(transId, theMessage.getName(), false, new EPPTransId(theMessage.getTransId(), svrTransId), new Date());
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", thePendActionMsg, null);
                EPPDomainTransferResp theTransMsg = new EPPDomainTransferResp();
                theTransMsg.setActionClient("ActionClient");
                theTransMsg.setActionDate(new Date());
                theTransMsg.setExpirationDate(new Date());
                theTransMsg.setName(theMessage.getName());
                theTransMsg.setRequestClient("RequestClient");
                theTransMsg.setRequestDate(new Date());
                theTransMsg.setTransferStatus("pending");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("clientApproved");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("clientCancelled");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("clientRejected");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("serverApproved");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("pending");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("clientApproved");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("clientCancelled");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("clientRejected");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
                theTransMsg.setTransferStatus("serverApproved");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theTransMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainCreate: Error putting message [" + thePollMsg + "]");
                theResult = new EPPResult(2400);
                theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
        } else if (theMessage.getName().equals("lowbalancepoll.com")) {
            EPPLowBalancePollResponse theLowBalanceMsg = new EPPLowBalancePollResponse();
            try {
                theLowBalanceMsg.setRegistrarName("Test Registar");
                theLowBalanceMsg.setCreditLimit("1000");
                theLowBalanceMsg.setCreditThreshold(new EPPLowBalancePollThreshold("PERCENT", "10"));
                theLowBalanceMsg.setAvailableCredit("80");
                EPPPollQueueMgr.getInstance().put(null, "NSPollHandler", theLowBalanceMsg, null);
            }
            catch (EPPPollQueueException e) {
                cat.error("doDomainCreate: Error low balance putting message [" + theLowBalanceMsg + "]");
                theResult = new EPPResult(2400);
                theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
        } else {
            theResponse.setResult(1000);
        }
        if (theMessage.getName().startsWith("ERRORTESTBUNDLE") && theMessage.getName().endsWith(".NAME")) {
            theResponse.setResult(2305);
            theResponse.addExtension(new EPPPersRegCreateErrData(2));
        } else if (theMessage.getName().startsWith("TESTBUNDLE ") && theMessage.getName().endsWith(".NAME")) {
            theResponse.addExtension(new EPPPersRegCreateData(true));
        }
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theMessage = (EPPDomainTransferCmd)aEvent.getMessage();
        cat.debug("doDomainTransfer: command = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPRelatedDomainExtTransfer.class)) {
            EPPEventResponse relatedResp = this.relatedDomainHandler.doDomainTransfer(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)relatedResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return relatedResp;
        }
        if (theMessage.hasExtension(EPPAllocationToken.class)) {
            EPPEventResponse allocationTokenResp = this.allocationTokenDomainHandler.doDomainTransfer(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)allocationTokenResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return allocationTokenResp;
        }
        if (theMessage.hasExtension(EPPFeeTransfer.class) || theMessage.getName().equalsIgnoreCase("fee-transfer-query.com")) {
            EPPEventResponse feeResp = this.feeDomainHandler.doDomainTransfer(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)feeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return feeResp;
        }
        if (theMessage.hasExtension(EPPEncodedSignedCode.class)) {
            EPPEventResponse verificationCodeResp = this.verificationCodeDomainHandler.doDomainTransfer(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)verificationCodeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return verificationCodeResp;
        }
        if (theMessage.getName().endsWith(".name")) {
            EPPEventResponse persRegResp = this.pergRegDomainHandler.doDomainTransfer(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)persRegResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return persRegResp;
        }
        if (theMessage.getName().startsWith("EPPSecureAuthInfoTst")) {
            EPPEventResponse secureAuthInfoResp = this.secureAuthInfoDomainHandler.doDomainTransfer(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)secureAuthInfoResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return secureAuthInfoResp;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.getOp().equals("request")) {
            EPPDomainTransferResp thePollMsg = new EPPDomainTransferResp();
            thePollMsg.setName("example");
            thePollMsg.setTransferStatus("pending");
            thePollMsg.setRequestClient("ClientX");
            thePollMsg.setRequestDate(new Date());
            thePollMsg.setActionClient("ClientY");
            thePollMsg.setActionDate(new Date());
            thePollMsg.setExpirationDate(new Date());
            thePollMsg.setResult(1000);
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainTransfer: Error putting message [" + thePollMsg + "]");
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(transId, theMessage.getName());
        theResponse.setTransferStatus("pending");
        theResponse.setRequestClient("ClientX");
        theResponse.setRequestDate(new Date());
        theResponse.setActionClient("ClientY");
        theResponse.setActionDate(new Date());
        theResponse.setExpirationDate(new Date());
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        if (theMessage.getOp().equals("request") && theMessage.getName().startsWith("TESTBUNDLE") && theMessage.getName().endsWith(".NAME")) {
            theResponse.addExtension(new EPPPersRegTransferData(true));
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPResponse theResponse;
        EPPCodecComponent theExt;
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        cat.debug("doDomainUpdate: command = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPLaunchUpdate.class)) {
            EPPEventResponse launchResp = this.launchDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)launchResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return launchResp;
        }
        if (theMessage.hasExtension(EPPRelatedDomainExtUpdate.class)) {
            EPPEventResponse relatedResp = this.relatedDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)relatedResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return relatedResp;
        }
        if (theMessage.hasExtension(EPPAllocationToken.class)) {
            EPPEventResponse allocationTokenResp = this.allocationTokenDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)allocationTokenResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return allocationTokenResp;
        }
        if (theMessage.hasExtension(EPPOrgExtUpdate.class)) {
            EPPEventResponse orgResp = this.orgDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)orgResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return orgResp;
        }
        if (theMessage.hasExtension(EPPFeeUpdate.class)) {
            EPPEventResponse feeResp = this.feeDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)feeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return feeResp;
        }
        if (theMessage.getName().startsWith("EPPSecureAuthInfoTst")) {
            EPPEventResponse secureAuthInfoResp = this.secureAuthInfoDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)secureAuthInfoResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return secureAuthInfoResp;
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        if (theMessage.hasExtension(EPPCoaExtUpdate.class)) {
            EPPCoaExtUpdate update = (EPPCoaExtUpdate)theMessage.getExtension(EPPCoaExtUpdate.class);
            List attrsToAdd = update.getPutAttrs();
            List attrsToRem = update.getRemAttrs();
            if (attrsToRem != null) {
                for (EPPCoaExtKey key : attrsToRem) {
                    cat.info("Client Object Attribute to remove: key='" + key.getKey() + "'");
                }
            }
            if (attrsToAdd != null) {
                for (EPPCoaExtAttr attr : attrsToAdd) {
                    String key = attr.getKey().getKey();
                    String value = attr.getValue().getValue();
                    cat.info("Client Object Attribute to add: key='" + key + "', value='" + value + "'");
                }
            }
        }
        if (theMessage.hasExtension(EPPEncodedSignedCode.class)) {
            EPPEventResponse verificationCodeResp = this.verificationCodeDomainHandler.doDomainUpdate(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)verificationCodeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return verificationCodeResp;
        }
        if (theMessage.hasExtension(EPPRgpExtUpdate.class)) {
            cat.debug("doDomainUpdate: Is RGP command");
            theExt = (EPPRgpExtUpdate)theMessage.getExtension(EPPRgpExtUpdate.class);
            if (((EPPRgpExtUpdate)theExt).getRestore().getOp().equals("request")) {
                return this.doDomainRestoreRequest(aEvent, theMessage.getName(), transId, aData);
            }
            return this.doDomainRestoreReport(aEvent, theMessage.getName(), transId, ((EPPRgpExtUpdate)theExt).getRestore().getReport(), aData);
        }
        if (theMessage.hasExtension(EPPSyncExtUpdate.class)) {
            cat.debug("doDomainUpdate: Is update command");
            theExt = (EPPSyncExtUpdate)theMessage.getExtension(EPPSyncExtUpdate.class);
            return this.doDomainSync(aEvent, theMessage.getName(), transId, (EPPSyncExtUpdate)theExt, aData);
        }
        cat.debug("NSDomainHandler: message = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPSecDNSExtUpdate.class) && theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate.class)) {
            cat.error("NSDomainHandler.doDomainUpdate: both v10 and v11 of EPPSecDNSExtUpdate passed.");
            EPPResult theResult = new EPPResult(2306);
            theResult.addExtValueReason("Both v10 and v11 of secDNS extension passed");
            theResponse = new EPPResponse(null, theResult);
        } else if (theMessage.hasExtension(EPPSecDNSExtUpdate.class)) {
            theResponse = this.v10SubHandler.doDomainUpdate(theMessage, aData);
        } else if (theMessage.hasExtension(com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate.class)) {
            theResponse = this.v11SubHandler.doDomainUpdate(theMessage, aData);
        } else {
            cat.info("NSDomainHandler.doDomainCreate: no EPPSecDNSExtUpdate extension");
            theResponse = new EPPResponse(transId);
            theResponse.setResult(1000);
        }
        theResponse.setTransId(transId);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainRestoreRequest(EPPEvent aEvent, String aDomainName, EPPTransId aTransId, Object aData) {
        cat.info("domain restore request: domain name = " + aDomainName);
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPResponse theResponse = null;
        EPPRgpPollResponse thePollMsg = new EPPRgpPollResponse();
        thePollMsg.setName(aDomainName);
        thePollMsg.setReportDueDate(new Date(System.currentTimeMillis() + 3600L));
        thePollMsg.setReqDate(new Date(System.currentTimeMillis()));
        thePollMsg.setStatus(new EPPRgpPollStatus("pendingRestore"));
        try {
            EPPPollQueueMgr.getInstance().put(null, "http://www.verisign.com/epp/rgp-poll-1.0", thePollMsg, null);
        }
        catch (EPPPollQueueException ex) {
            cat.error("doDomainUpdate: Error putting message [" + thePollMsg + "]");
            EPPResult theResult = new EPPResult(2400);
            theResponse = new EPPResponse(aTransId, theResult);
            return new EPPEventResponse(theResponse);
        }
        theResponse = new EPPResponse(aTransId);
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        theResponse.addExtension(new EPPRgpExtUpData(new EPPRgpExtStatus("pendingRestore")));
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainRestoreReport(EPPEvent aEvent, String aDomainName, EPPTransId aTransId, EPPRgpExtReport aReport, Object aData) {
        cat.info("domain restore report: domain name = " + aDomainName + ", report = " + aReport);
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPResponse theResponse = new EPPResponse(aTransId);
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        return new EPPEventResponse(theResponse);
    }

    protected EPPEventResponse doDomainSync(EPPEvent aEvent, String aDomainName, EPPTransId aTransId, EPPSyncExtUpdate aSyncExt, Object aData) {
        cat.info("domain sync: domain name = " + aDomainName + ", month = " + aSyncExt.getMonth() + ", day = " + aSyncExt.getDay());
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPResponse theResponse = new EPPResponse(aTransId);
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPRgpExtInfData rgpExt;
        EPPWhoisInf theWhoisExt;
        EPPDomainInfoCmd theMessage = (EPPDomainInfoCmd)aEvent.getMessage();
        cat.debug("doDomainInfo: command = [" + theMessage + "]");
        if (theMessage.hasExtension(EPPLaunchInfo.class)) {
            EPPEventResponse launchResp = this.launchDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)launchResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return launchResp;
        }
        if (theMessage.hasExtension(EPPRelatedDomainExtInfo.class)) {
            EPPEventResponse relatedDomainResp = this.relatedDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)relatedDomainResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return relatedDomainResp;
        }
        if (theMessage.hasExtension(EPPAllocationToken.class)) {
            EPPEventResponse allocationTokenResp = this.allocationTokenDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)allocationTokenResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return allocationTokenResp;
        }
        if (theMessage.getName().equalsIgnoreCase("xn--espaol-zwa.example.com")) {
            EPPEventResponse idnMapResp = this.idnMapDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)idnMapResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return idnMapResp;
        }
        if (theMessage.hasExtension(EPPVerificationCodeInfo.class)) {
            EPPEventResponse verificationCodeResp = this.verificationCodeDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)verificationCodeResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return verificationCodeResp;
        }
        if (theMessage.getName().endsWith(".name")) {
            EPPEventResponse persRegResp = this.pergRegDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)persRegResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return persRegResp;
        }
        if (theMessage.getName().startsWith("EPPSecureAuthInfoTst")) {
            EPPEventResponse secureAuthInfoResp = this.secureAuthInfoDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)secureAuthInfoResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return secureAuthInfoResp;
        }
        if (theMessage.getName().equals("un-no-dnssec.com") || theMessage.getName().equals("un-no-rgp.com")) {
            EPPEventResponse unhandledNamespacesInfoResp = this.unhandledNamespacesDomainHandler.doDomainInfo(aEvent, aData);
            if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
                ((EPPResponse)unhandledNamespacesInfoResp.getResponse()).addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
            }
            return unhandledNamespacesInfoResp;
        }
        Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
        statuses.addElement(new EPPDomainStatus("ok"));
        statuses.addElement(new EPPDomainStatus("clientHold"));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainInfoResp theResponse = new EPPDomainInfoResp(transId, roid, "example.com", "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
        Vector<String> theNses = new Vector<String>();
        theNses.addElement("ns1.example.com");
        theNses.addElement("ns2.example.com");
        theResponse.setNses(theNses);
        Vector<String> theHosts = new Vector<String>();
        theHosts.addElement("ns1.example.com");
        theHosts.addElement("ns2.example.com");
        theResponse.setHosts(theHosts);
        Vector<EPPDomainContact> theContacts = new Vector<EPPDomainContact>();
        theContacts.addElement(new EPPDomainContact("sh8013", "admin"));
        theContacts.addElement(new EPPDomainContact("sh8013", "billing"));
        theContacts.addElement(new EPPDomainContact("sh8013", "tech"));
        theResponse.setContacts(theContacts);
        GregorianCalendar theCal = new GregorianCalendar();
        theCal.setTime(new Date());
        theCal.add(1, 1);
        theResponse.setExpirationDate(theCal.getTime());
        theResponse.setRegistrant("jd1234");
        theResponse.setResult(1000);
        if (theMessage.hasExtension(EPPNamestoreExtNamestoreExt.class)) {
            theResponse.addExtension(theMessage.getExtension(EPPNamestoreExtNamestoreExt.class));
        }
        if (theMessage.getName().equals("pendingrestore.com")) {
            theResponse.addExtension(new EPPRgpExtInfData(new EPPRgpExtStatus("pendingRestore")));
        }
        if ((theWhoisExt = (EPPWhoisInf)theMessage.getExtension(EPPWhoisInf.class)) != null && theWhoisExt.getFlag().booleanValue() && theResponse.isSuccess()) {
            theResponse.addExtension(new EPPWhoisInfData("Example Registrar Inc.", "whois.example.com", "http://www.example.com", "iris.example.com"));
        }
        if (theMessage.getName().equalsIgnoreCase("secdns.com")) {
            EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
            keyData.setFlags(257);
            keyData.setProtocol(3);
            keyData.setAlg(5);
            keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
            EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
            dsData.setKeyTag(34095);
            dsData.setAlg(5);
            dsData.setDigestType(1);
            dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
            dsData.setKeyData(keyData);
            EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B", keyData2);
            EPPSecDNSExtInfData infData = new EPPSecDNSExtInfData();
            Vector<EPPSecDNSExtDsData> dsDataVec = new Vector<EPPSecDNSExtDsData>();
            dsDataVec.add(dsData);
            infData.setDsData(dsDataVec);
            infData.appendDsData(dsData2);
            theResponse.addExtension(infData);
        }
        if (theMessage.getName().equalsIgnoreCase("coa-full-info-owned.com")) {
            EPPCoaExtKey key = new EPPCoaExtKey("KEY1");
            EPPCoaExtValue value = new EPPCoaExtValue("value1");
            EPPCoaExtAttr attr = new EPPCoaExtAttr();
            attr.setKey(key);
            attr.setValue(value);
            EPPCoaExtInfData coaInfData = new EPPCoaExtInfData();
            coaInfData.appendAttr(attr);
            theResponse.addExtension(coaInfData);
        }
        if (theMessage.getName().equalsIgnoreCase("graceperiod.com")) {
            rgpExt = new EPPRgpExtInfData();
            EPPRgpExtStatus autoRenewPeriodStatus = new EPPRgpExtStatus("autoRenewPeriod");
            autoRenewPeriodStatus.setMessage("endDate=" + EPPUtil.encodeTimeInstant(new Date()));
            rgpExt.addStatus(autoRenewPeriodStatus);
            EPPRgpExtStatus renewPeriodStatus = new EPPRgpExtStatus("renewPeriod");
            renewPeriodStatus.setMessage("endDate=" + EPPUtil.encodeTimeInstant(new Date()));
            rgpExt.addStatus(renewPeriodStatus);
            theResponse.addExtension(rgpExt);
        }
        if (theMessage.getName().equalsIgnoreCase("pendingperiod.com")) {
            statuses = new Vector();
            statuses.addElement(new EPPDomainStatus("pendingDelete"));
            theResponse.setStatuses(statuses);
            rgpExt = new EPPRgpExtInfData();
            rgpExt.addStatus(new EPPRgpExtStatus("redemptionPeriod"));
            theResponse.addExtension(rgpExt);
        }
        SessionData theSessionData = (SessionData)aData;
        boolean hasV10ExtService = false;
        boolean hasV11ExtService = false;
        Enumeration extSvcEnum = theSessionData.getLoginCmd().getExtensionServices().elements();
        while (extSvcEnum.hasMoreElements()) {
            EPPService theExtService = (EPPService)extSvcEnum.nextElement();
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:secDNS-1.0")) {
                hasV10ExtService = true;
                continue;
            }
            if (!theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:secDNS-1.1")) continue;
            hasV11ExtService = true;
        }
        if (hasV11ExtService) {
            theResponse = this.v11SubHandler.doDomainInfo(theMessage, theResponse, aData);
        } else if (hasV10ExtService) {
            theResponse = this.v10SubHandler.doDomainInfo(theMessage, theResponse, aData);
        } else {
            cat.info("NSDomainHandler.doDomainInfo: no secDNS extension URI specified in login");
        }
        return new EPPEventResponse(theResponse);
    }
}

