/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.idnmap.EPPIdnMap;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.serverstub.DomainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdnMapDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(IdnMapDomainHandler.class);

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
        theResponse.addExtension(new EPPIdnMap("es", "spa\u00f1ol.example.com"));
        cat.info("doDomainInfo: EPPIdnMap added to response");
        System.out.println("doDomainInfo: EPPIdnMap added to response");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPIdnMap.class)) {
            EPPIdnMap theExt = (EPPIdnMap)theCommand.getExtension(EPPIdnMap.class);
            cat.info("doDomainCreate: IDN table = " + theExt.getTable());
            System.out.println("doDomainCreate: IDN table = " + theExt.getTable());
            if (theExt.hasUname()) {
                cat.info("domain:info: Response IDN uname = " + theExt.getUname());
                System.out.println("domain:info: Response IDN uname = " + theExt.getUname());
            } else {
                cat.info("domain:info: Response IDN uname is undefined");
            }
        } else {
            cat.info("doDomainCreate: IDN Map = null");
            System.out.println("doDomainCreate: IDN Map = null");
        }
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        return theEventResponse;
    }
}

