/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.changepoll.EPPChangeCaseId;
import com.verisign.epp.codec.changepoll.EPPChangeData;
import com.verisign.epp.codec.changepoll.EPPChangeOperation;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePollDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(ChangePollDomainHandler.class);

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        if (theCommand.getName().equalsIgnoreCase("change-poll.tld")) {
            EPPTransId changeTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
            Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
            statuses.addElement(new EPPDomainStatus("serverUpdateProhibited"));
            statuses.addElement(new EPPDomainStatus("serverDeleteProhibited"));
            statuses.addElement(new EPPDomainStatus("serverTransferProhibited"));
            EPPDomainInfoResp thePollMsg = new EPPDomainInfoResp(changeTransId, "EXAMPLE1-REP", "change-poll.tld", "ClientX", statuses, "ClientY", new GregorianCalendar(2012, 4, 3).getTime(), null);
            thePollMsg.setRegistrant("jd1234");
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
                contacts.addElement(new EPPDomainContact("sh8013", "admin"));
                contacts.addElement(new EPPDomainContact("sh8013", "tech"));
                thePollMsg.setContacts(contacts);
            }
            thePollMsg.setLastUpdatedBy("ClientZ");
            thePollMsg.setLastUpdatedDate(new GregorianCalendar(2013, 10, 22).getTime());
            thePollMsg.setExpirationDate(new GregorianCalendar(2014, 4, 3).getTime());
            EPPChangeData changeData = new EPPChangeData(new EPPChangeOperation("update"), new GregorianCalendar(2013, 10, 22).getTime(), "12345-XYZ", "URS Admin", "after", new EPPChangeCaseId("urs123", "urs"), "URS Lock", null);
            thePollMsg.addExtension(changeData);
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainCreate: Error putting message [" + thePollMsg + "]");
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(changeTransId, theResult);
                return new EPPEventResponse(theResponse);
            }
            thePollMsg.setResult(1001);
        }
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        return theEventResponse;
    }
}

