/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.v1_0;

import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.loginsec.v1_0.EPPLoginSecData;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPLoginSecTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(EPPLoginSecTst.class);
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPLoginSecTst(String name) {
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testStandardLogin() {
        this.printStart("testStandardLogin");
        try {
            this.session = new EPPSession();
            this.session.setClientID("StandardLogin");
            this.session.setPassword("foo-BAR2");
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setVersion("1.0");
            this.session.setLang("en");
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession();
        this.printEnd("testStandardLogin");
    }

    public void testLoginCmdLongPwd() {
        EPPCodecTst.printStart("testLoginCmdLongPwd");
        try {
            this.session = new EPPSession();
            this.session.setClientID("LongPwd");
            this.session.setPassword("this is a long password");
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setVersion("1.0");
            this.session.setLang("en");
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession();
        EPPCodecTst.printEnd("testLoginCmdLongPwd");
    }

    public void testLoginCmdLongNewPwd() {
        EPPCodecTst.printStart("testLoginCmdLongNewPwd");
        try {
            this.session = new EPPSession();
            this.session.setClientID("LongNewPwd");
            this.session.setPassword("foo-BAR2");
            this.session.setNewPassword("new password that is long");
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setVersion("1.0");
            this.session.setLang("en");
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession();
        EPPCodecTst.printEnd("testLoginCmdLongNewPwd");
    }

    public void testLoginCmdLongPwdNewPwd() {
        EPPCodecTst.printStart("testLoginCmdLongPwdNewPwd");
        try {
            this.session = new EPPSession();
            this.session.setClientID("LongPwdNewPwd");
            this.session.setPassword("this is a long password");
            this.session.setNewPassword("new password that is long");
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setVersion("1.0");
            this.session.setLang("en");
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession();
        EPPCodecTst.printEnd("testLoginCmdLongPwdNewPwd");
    }

    public void testExpiringPasswordResponse() {
        EPPCodecTst.printStart("testExpiringPasswordResponse");
        try {
            this.session = new EPPSession();
            this.session.setClientID("test-expiring-pw");
            this.session.setPassword("this is a long password");
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setVersion("1.0");
            this.session.setLang("en");
            this.session.initSession();
            EPPResponse theResponse = this.session.getResponse();
            if (theResponse.hasExtension(EPPLoginSecData.class)) {
                this.printMsg("testExpiringPasswordResponse v2 login security response extension = " + theResponse.getExtension(EPPLoginSecData.class));
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession();
        EPPCodecTst.printEnd("testExpiringPasswordResponse");
    }

    public void testExpiredPasswordResponse() {
        block2: {
            EPPCodecTst.printStart("testExpiredPasswordResponse");
            try {
                this.session = new EPPSession();
                this.session.setClientID("test-expired-pw");
                this.session.setPassword("this is a long password");
                this.session.setTransId("ABC-12345-XYZ");
                this.session.setVersion("1.0");
                this.session.setLang("en");
                this.session.initSession();
                Assert.fail((String)"Login with test-expired-pw should fail");
            }
            catch (EPPCommandException e) {
                EPPResponse theResponse = this.session.getResponse();
                if (!theResponse.hasExtension(EPPLoginSecData.class)) break block2;
                this.printMsg("testExpiredPasswordResponse v2 login security response extension = " + theResponse.getExtension(EPPLoginSecData.class));
            }
        }
        EPPCodecTst.printEnd("testExpiredPasswordResponse");
    }

    public void testWarningAllResponse() {
        EPPCodecTst.printStart("testWarningAllResponse");
        try {
            this.session = new EPPSession();
            this.session.setClientID("test-all-events");
            this.session.setPassword("this is a long password");
            this.session.setTransId("ABC-12345-XYZ");
            this.session.setVersion("1.0");
            this.session.setLang("en");
            this.session.initSession();
            EPPResponse theResponse = this.session.getResponse();
            if (theResponse.hasExtension(EPPLoginSecData.class)) {
                this.printMsg("testWarningAllResponse v2 login security response extension = " + theResponse.getExtension(EPPLoginSecData.class));
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.endSession();
        EPPCodecTst.printEnd("testWarningAllResponse");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPLoginSecTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPLoginSecTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLoginSecTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.out.println(aMsg);
            cat.info(aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
        } else {
            System.err.println(aMsg);
            cat.error(aMsg);
        }
    }
}

