/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.nameWatch.EPPNameWatchAddRemove;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchDeleteCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchPeriod;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRptTo;
import com.verisign.epp.codec.nameWatch.EPPNameWatchStatus;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Date;
import java.util.Vector;

public class EPPNameWatch {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SERVER_HOLD = "serverHold";
    public static final String STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STATUS_CLIENT_HOLD = "clientHold";
    public static final String STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String STATUS_PENDING_DELETE = "pendingDelete";
    public static final String STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    public static final String FREQ_DAILY = "daily";
    public static final String FREQ_WEEKLY = "weekly";
    public static final String FREQ_MONTHLY = "monthly";
    public static final String PERIOD_MONTH = "m";
    public static final String PERIOD_YEAR = "y";
    private String name = null;
    private String rptTo = null;
    private String freq = null;
    private String roid = null;
    private String registrant = null;
    private EPPSession mySession = null;
    private String transId = null;
    private Date expirationDate;
    private String transferOpCode;
    private int periodLength = 1;
    private String myPeriodUnit = null;
    private String authString;
    private String authRoid;
    private Vector extensions = null;
    private Vector addStatuses = null;
    private Vector removeStatuses = null;

    public EPPNameWatch(EPPSession newSession) {
        this.mySession = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    @Deprecated
    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setRoid(String newRoid) {
        this.roid = newRoid;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setExpirationDate(Date newExpirationDate) {
        this.expirationDate = newExpirationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setTransferOpCode(String newTransferOpCode) {
        this.transferOpCode = newTransferOpCode;
    }

    public void setTransId(String newTransId) {
        this.transId = newTransId;
    }

    public void setAuthString(String newAuthString) {
        this.authString = newAuthString;
    }

    public String getAuthString() {
        return this.authString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String aAuthRoid) {
        this.authRoid = aAuthRoid;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    public String getRptTo() {
        return this.rptTo;
    }

    public void setRptTo(String aRptTo) {
        this.rptTo = aRptTo;
    }

    public String getFreq() {
        return this.freq;
    }

    public void setFreq(String aFreq) {
        this.freq = aFreq;
    }

    public EPPNameWatchCreateResp sendCreate() throws EPPCommandException {
        EPPNameWatchCreateCmd myCommand = new EPPNameWatchCreateCmd(this.transId, this.name, this.registrant, new EPPNameWatchRptTo(this.freq, this.rptTo), new EPPAuthInfo(this.authString));
        if (this.periodLength >= 0) {
            if (this.myPeriodUnit == null) {
                myCommand.setPeriod(new EPPNameWatchPeriod(this.periodLength));
            } else {
                myCommand.setPeriod(new EPPNameWatchPeriod(this.myPeriodUnit, this.periodLength));
            }
        }
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchCreateResp)this.mySession.processDocument(myCommand, EPPNameWatchCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        EPPNameWatchRptTo rptTo;
        EPPNameWatchAddRemove addItems = null;
        addItems = this.addStatuses != null ? new EPPNameWatchAddRemove(this.addStatuses) : new EPPNameWatchAddRemove();
        EPPNameWatchAddRemove removeItems = null;
        removeItems = this.removeStatuses != null ? new EPPNameWatchAddRemove(this.removeStatuses) : new EPPNameWatchAddRemove();
        EPPAuthInfo authInfo = null;
        if (this.authString != null) {
            authInfo = new EPPAuthInfo(this.authString);
        }
        if ((rptTo = null) != null && this.freq != null) {
            rptTo = new EPPNameWatchRptTo(this.freq, this.rptTo);
        }
        EPPNameWatchAddRemove changeItems = new EPPNameWatchAddRemove(this.registrant, rptTo, authInfo);
        EPPNameWatchUpdateCmd myCommand = new EPPNameWatchUpdateCmd(this.transId, this.roid, addItems, removeItems, changeItems);
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return this.mySession.processDocument(myCommand, EPPResponse.class);
    }

    public EPPNameWatchTransferResp sendTransfer() throws EPPCommandException {
        EPPNameWatchTransferCmd myCommand = new EPPNameWatchTransferCmd(this.transId, this.transferOpCode, this.roid);
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            myCommand.setAuthInfo(theAuthInfo);
        }
        if (this.transferOpCode.equals(TRANSFER_REQUEST)) {
            if (this.authString == null) {
                throw new EPPCommandException("Auth Info must be set on a Transfer Request");
            }
            EPPNameWatchPeriod thePeriod = null;
            thePeriod = this.periodLength < 0 ? null : (this.myPeriodUnit == null ? new EPPNameWatchPeriod(this.periodLength) : new EPPNameWatchPeriod(this.myPeriodUnit, this.periodLength));
            myCommand.setPeriod(thePeriod);
        }
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchTransferResp)this.mySession.processDocument(myCommand, EPPNameWatchTransferResp.class);
    }

    public EPPNameWatchRenewResp sendRenew() throws EPPCommandException {
        EPPNameWatchPeriod myPeriod = null;
        myPeriod = this.myPeriodUnit != null ? new EPPNameWatchPeriod(this.myPeriodUnit, this.periodLength) : new EPPNameWatchPeriod(this.periodLength);
        EPPNameWatchRenewCmd myCommand = new EPPNameWatchRenewCmd(this.transId, this.roid, this.expirationDate, myPeriod);
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchRenewResp)this.mySession.processDocument(myCommand, EPPNameWatchRenewResp.class);
    }

    public EPPNameWatchInfoResp sendInfo() throws EPPCommandException {
        EPPNameWatchInfoCmd myCommand = new EPPNameWatchInfoCmd(this.transId, this.roid);
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            myCommand.setAuthInfo(theAuthInfo);
        }
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return (EPPNameWatchInfoResp)this.mySession.processDocument(myCommand, EPPNameWatchInfoResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        EPPNameWatchDeleteCmd myCommand = new EPPNameWatchDeleteCmd(this.transId, this.roid);
        myCommand.setExtensions(this.extensions);
        this.resetNameWatch();
        return this.mySession.processDocument(myCommand, EPPResponse.class);
    }

    private void resetNameWatch() {
        this.roid = null;
        this.transId = null;
        this.expirationDate = null;
        this.transferOpCode = null;
        this.periodLength = 1;
        this.authString = null;
        this.authRoid = null;
        this.extensions = null;
        this.addStatuses = null;
        this.removeStatuses = null;
        this.rptTo = null;
        this.freq = null;
        this.registrant = null;
    }

    public EPPResponse getResponse() {
        return this.mySession.getResponse();
    }

    public int getPeriodLength() {
        return this.periodLength;
    }

    public void setPeriodLength(int newPeriodLength) {
        this.periodLength = newPeriodLength;
    }

    public String getPeriodUnit() {
        return this.myPeriodUnit;
    }

    public void setPeriodUnit(String newPeriodUnit) {
        this.myPeriodUnit = newPeriodUnit;
    }

    public void addStatus(EPPNameWatchStatus aStatus) {
        if (this.addStatuses == null) {
            this.addStatuses = new Vector();
        }
        this.addStatuses.addElement(aStatus);
    }

    public void removeStatus(EPPNameWatchStatus aStatus) {
        if (this.removeStatuses == null) {
            this.removeStatuses = new Vector();
        }
        this.removeStatuses.addElement(aStatus);
    }
}

