/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.contact.EPPContactCheckCmd;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactDeleteCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Vector;

public class EPPContact {
    public static final String STAT_OK = "ok";
    public static final String STAT_PENDING_DELETE = "pendingDelete";
    public static final String STAT_PENDING_TRANSFER = "pendingTransfer";
    public static final String STAT_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String STAT_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STAT_STATUS_LINKED = "linked";
    public static final String STAT_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STAT_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STAT_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STAT_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    private EPPSession session = null;
    private String transId = null;
    private Vector contactIds = new Vector();
    private String transferOpCode = null;
    private String authString = null;
    private Vector postalContacts = new Vector();
    private String voicePhone = null;
    private String voiceExt = null;
    private String faxNumber = null;
    private String faxExt = null;
    private String email = null;
    private Vector addStatuses = null;
    private Vector removeStatuses = null;
    private Vector extensions = null;
    private EPPContactDisclose disclose = null;

    public EPPContact(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransferOpCode(String aTransferOpCode) {
        this.transferOpCode = aTransferOpCode;
    }

    public Vector getPostalInfo() {
        return this.postalContacts;
    }

    public EPPContactPostalDefinition getFirstPostalInfo() {
        if (this.postalContacts != null && !this.postalContacts.isEmpty()) {
            return (EPPContactPostalDefinition)this.postalContacts.get(0);
        }
        return null;
    }

    public void setPostalInfo(Vector newPostalContacts) {
        this.postalContacts = newPostalContacts;
    }

    public void addPostalInfo(EPPContactPostalDefinition newPostalContact) {
        this.postalContacts.add(newPostalContact);
    }

    public EPPContactDisclose getDisclose() {
        return this.disclose;
    }

    public void setDisclose(EPPContactDisclose newDisclose) {
        if (newDisclose != null) {
            this.disclose = newDisclose;
        }
    }

    public void setVoicePhone(String newVoicePhone) {
        this.voicePhone = newVoicePhone;
    }

    public void setVoiceExt(String newVoiceExt) {
        this.voiceExt = newVoiceExt;
    }

    public void setFaxNumber(String newFaxNumber) {
        this.faxNumber = newFaxNumber;
    }

    public void setFaxExt(String newFaxExt) {
        this.faxExt = newFaxExt;
    }

    public void setEmail(String newEmail) {
        this.email = newEmail;
    }

    public String getVoicePhone() {
        return this.voicePhone;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void addStatus(String aStatus) {
        if (this.addStatuses == null) {
            this.addStatuses = new Vector();
        }
        this.addStatuses.addElement(new EPPContactStatus(aStatus));
    }

    public void removeStatus(String aStatus) {
        if (this.removeStatuses == null) {
            this.removeStatuses = new Vector();
        }
        this.removeStatuses.addElement(new EPPContactStatus(aStatus));
    }

    public void addStatus(String aStatus, String aDesc, String aLang) {
        if (this.addStatuses == null) {
            this.addStatuses = new Vector();
        }
        this.addStatuses.addElement(new EPPContactStatus(aStatus, aDesc, aLang));
    }

    public void removeStatus(String aStatus, String aDesc, String aLang) {
        if (this.removeStatuses == null) {
            this.removeStatuses = new Vector();
        }
        this.removeStatuses.addElement(new EPPContactStatus(aStatus, aDesc, aLang));
    }

    public Vector getAddStatus() {
        return this.addStatuses;
    }

    public Vector getRemoveStatus() {
        return this.removeStatuses;
    }

    public void addContactId(String newContactId) {
        this.contactIds.addElement(newContactId);
    }

    public void setAuthorizationId(String newAuthorizationId) {
        this.authString = newAuthorizationId;
    }

    public void setTransId(String newTransId) {
        this.transId = newTransId;
    }

    public String getTransId() {
        return this.transId;
    }

    public String getAuthorizationId() {
        return this.authString;
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }

    public EPPResponse sendCreate() throws EPPCommandException {
        if (this.contactIds.size() != 1) {
            throw new EPPCommandException("One Contact Id is required for sendCreate()");
        }
        if (this.authString == null) {
            throw new EPPCommandException("Authorization String is required.");
        }
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd(this.transId);
        theCommand.setId((String)this.contactIds.firstElement());
        theCommand.setAuthInfo(new EPPAuthInfo(this.authString));
        theCommand.setDisclose(this.disclose);
        theCommand.setEmail(this.email);
        theCommand.setFax(this.faxNumber);
        theCommand.setFaxExt(this.faxExt);
        for (int i = 0; i < this.postalContacts.size(); ++i) {
            theCommand.addPostalInfo((EPPContactPostalDefinition)this.postalContacts.elementAt(i));
        }
        theCommand.setVoice(this.voicePhone);
        theCommand.setVoiceExt(this.voiceExt);
        theCommand.setExtensions(this.extensions);
        this.resetContact();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPContactCheckResp sendCheck() throws EPPCommandException {
        if (this.contactIds.size() == 0) {
            throw new EPPCommandException("At least One Contact Id is required for sendCheck()");
        }
        EPPContactCheckCmd theCommand = new EPPContactCheckCmd(this.transId, this.contactIds);
        theCommand.setExtensions(this.extensions);
        this.resetContact();
        return (EPPContactCheckResp)this.session.processDocument(theCommand, EPPContactCheckResp.class);
    }

    public EPPContactInfoResp sendInfo() throws EPPCommandException {
        if (this.contactIds.size() != 1) {
            throw new EPPCommandException("One Contact Id is required for sendInfo()");
        }
        EPPContactInfoCmd theCommand = new EPPContactInfoCmd(this.transId, (String)this.contactIds.firstElement());
        if (this.authString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.authString);
            theCommand.setAuthInfo(theAuthInfo);
        }
        theCommand.setExtensions(this.extensions);
        this.resetContact();
        return (EPPContactInfoResp)this.session.processDocument(theCommand, EPPContactInfoResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.contactIds.size() != 1) {
            throw new EPPCommandException("One Contact Id is required for sendUpdate()");
        }
        EPPContactAddChange addItems = null;
        if (this.addStatuses != null) {
            addItems = new EPPContactAddChange(this.addStatuses);
        }
        EPPContactAddChange removeItems = null;
        if (this.removeStatuses != null) {
            removeItems = new EPPContactAddChange(this.removeStatuses);
        }
        EPPContactAddChange changeItems = null;
        if (this.postalContacts.size() > 0 || this.voicePhone != null || this.faxNumber != null || this.email != null || this.authString != null) {
            changeItems = new EPPContactAddChange(this.postalContacts, this.voicePhone, this.faxNumber, this.email, this.authString != null ? new EPPAuthInfo(this.authString) : null);
            changeItems.setVoiceExt(this.voiceExt);
            changeItems.setFaxExt(this.faxExt);
            changeItems.setDisclose(this.disclose);
        }
        EPPContactUpdateCmd theCommand = new EPPContactUpdateCmd(this.transId, (String)this.contactIds.firstElement(), addItems, removeItems, changeItems);
        theCommand.setExtensions(this.extensions);
        this.resetContact();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    public EPPContactTransferResp sendTransfer() throws EPPCommandException {
        if (this.contactIds.size() != 1) {
            throw new EPPCommandException("One Contact Id is required for sendTransfer()");
        }
        if (this.transferOpCode == null) {
            throw new EPPCommandException("Transfer Operation Code is required.");
        }
        EPPContactTransferCmd theCommand = new EPPContactTransferCmd(this.transId, this.transferOpCode, (String)this.contactIds.firstElement());
        if (this.authString != null) {
            theCommand.setAuthInfo(new EPPAuthInfo(this.authString));
        }
        theCommand.setExtensions(this.extensions);
        this.resetContact();
        return (EPPContactTransferResp)this.session.processDocument(theCommand, EPPContactTransferResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.contactIds.size() != 1) {
            throw new EPPCommandException("One Contact Id is required for sendDelete()");
        }
        EPPContactDeleteCmd theCommand = new EPPContactDeleteCmd(this.transId, (String)this.contactIds.firstElement());
        theCommand.setExtensions(this.extensions);
        this.resetContact();
        return this.session.processDocument(theCommand, EPPResponse.class);
    }

    protected void resetContact() {
        this.transId = null;
        this.postalContacts = new Vector();
        this.voicePhone = null;
        this.voiceExt = null;
        this.faxNumber = null;
        this.faxExt = null;
        this.email = null;
        this.contactIds = new Vector();
        this.addStatuses = null;
        this.removeStatuses = null;
        this.transferOpCode = null;
        this.extensions = null;
    }
}

