/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPByteArrayAssembler;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPByteArrayDispatcher {
    private static final EPPByteArrayDispatcher _instance = new EPPByteArrayDispatcher();
    private static Logger LOG = LoggerFactory.getLogger(EPPByteArrayDispatcher.class);
    private Map eventHandlers = new HashMap();
    private EPPByteArrayAssembler theAssembler;

    private EPPByteArrayDispatcher() {
    }

    public static EPPByteArrayDispatcher getInstance() {
        return _instance;
    }

    public void setAssembler(EPPByteArrayAssembler aByteArrayAssembler) {
        this.theAssembler = aByteArrayAssembler;
    }

    public byte[] processMessage(byte[] aInputBytes, Object aData) throws EPPEventException, EPPAssemblerException {
        LOG.debug("processMessage(byte[], Object): Enter");
        if (this.theAssembler == null) {
            throw new EPPAssemblerException("No Assembler registered with EPPByteArrayDispatcher", EPPAssemblerException.FATAL);
        }
        EPPEvent event = this.theAssembler.decode(aInputBytes, aData);
        EPPMessage message = event.getMessage();
        if (message instanceof EPPResponse) {
            LOG.info("processMessage(): Invalid message type " + message.getClass().getName() + " for dispatching");
            throw new EPPEventException("Invalid request message type of response");
        }
        if (message instanceof EPPGreeting) {
            LOG.info("processMessage(): Invalid message type " + message.getClass().getName() + " for dispatching");
            throw new EPPEventException("Invalid request message type of greeting");
        }
        String namespace = message.getNamespace();
        LOG.debug("Sending event for Namespace " + namespace);
        EPPEventHandler handler = (EPPEventHandler)this.eventHandlers.get(namespace);
        if (handler == null) {
            LOG.info("processMessage(): Handler not found for Namespace " + namespace);
            throw new EPPEventException("Handler not found for Namespace " + namespace);
        }
        byte[] responseBytes = null;
        EPPEventResponse eventResponse = handler.handleEvent(event, aData);
        if (eventResponse != null && eventResponse.getResponse() != null) {
            LOG.debug("processMessage(): Sending response to Assembler");
            responseBytes = this.theAssembler.encode(eventResponse, aData);
        } else {
            LOG.debug("processMessage(): No response to send to Assembler");
        }
        LOG.debug("processMessage(): Return");
        return responseBytes;
    }

    public void registerHandler(EPPEventHandler aHandler) {
        this.eventHandlers.put(aHandler.getNamespace(), aHandler);
    }

    public byte[] toBytes(EPPMessage aMessage) throws EPPAssemblerException {
        return this.theAssembler.encode(new EPPEventResponse(aMessage), null);
    }

    public byte[] toBytes(EPPMessage aMessage, Object aData) throws EPPAssemblerException {
        return this.theAssembler.encode(new EPPEventResponse(aMessage), aData);
    }
}

