/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.balance.EPPBalanceInfoCmd;
import com.verisign.epp.codec.balance.EPPBalanceMapFactory;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPBalanceHandler
implements EPPEventHandler {
    private static Logger cat = LoggerFactory.getLogger(EPPBalanceHandler.class);

    public EPPBalanceHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPBalanceMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error("Couldn't load the Map Factory for the Balance Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/balance-1.0";
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        if (!(message instanceof EPPBalanceInfoCmd)) {
            throw new EPPEventException("In EPPBalanceHandler an unsupported event was found");
        }
        EPPEventResponse response = this.doBalanceInfo(aEvent, aData);
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected abstract EPPEventResponse doBalanceInfo(EPPEvent var1, Object var2);
}

