/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EPPValidateAuthInfo
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPValidateAuthInfo.class);
    public static final short TYPE_PW = 0;
    public static final short TYPE_EXT = 1;
    public static final String ELM_LOCALNAME = "authInfo";
    public static final String ELM_NAME = "validate:authInfo";
    protected static final String ELM_PW = "pw";
    protected static final String ELM_EXT = "ext";
    protected static final String ATTR_ROID = "roid";
    protected String password = null;
    protected EPPCodecComponent ext = null;
    protected short type = 0;
    protected String roid = null;

    public EPPValidateAuthInfo() {
    }

    public EPPValidateAuthInfo(String aPassword) {
        this.setPassword(aPassword);
    }

    public EPPValidateAuthInfo(String aPassword, String aRoid) {
        this.setPassword(aPassword);
        this.roid = aRoid;
    }

    public EPPValidateAuthInfo(EPPCodecComponent aExt) {
        this.setExt(aExt);
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
        this.type = 0;
    }

    public EPPCodecComponent getExt() {
        return this.ext;
    }

    public void setExt(EPPCodecComponent aExt) {
        this.ext = aExt;
        this.type = 1;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short aType) {
        this.type = aType;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateAuthInfo clone = null;
        clone = (EPPValidateAuthInfo)super.clone();
        if (this.ext != null) {
            clone.ext = (EPPCodecComponent)this.ext.clone();
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        switch (this.type) {
            case 0: {
                if (this.password == null) {
                    throw new EPPEncodeException("EPPValidateAuthInfo: password is null on call to encode");
                }
                Element thePasswordElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", "contact:pw");
                thePasswordElm.appendChild(aDocument.createTextNode(this.password));
                if (this.roid != null) {
                    thePasswordElm.setAttribute(ATTR_ROID, this.roid);
                }
                root.appendChild(thePasswordElm);
                break;
            }
            case 1: {
                if (this.ext == null) {
                    throw new EPPEncodeException("EPPValidateAuthInfo: ext is null on call to encode");
                }
                Element theExtElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", "contact:ext");
                EPPUtil.encodeComp(aDocument, theExtElm, this.ext);
                root.appendChild(theExtElm);
                break;
            }
            default: {
                throw new EPPEncodeException("EPPValidateAuthInfo: invalid type" + this.type);
            }
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theTypeElm = EPPUtil.getFirstElementChild(aElement);
        if (theTypeElm == null) {
            throw new EPPDecodeException("EPPValidateAuthInfo.decode could not find type child element");
        }
        if (theTypeElm.getLocalName().equals(ELM_PW)) {
            this.type = 0;
            Node textNode = theTypeElm.getFirstChild();
            this.password = textNode != null ? textNode.getNodeValue() : "";
            this.roid = theTypeElm.getAttribute(ATTR_ROID).equals("") ? null : theTypeElm.getAttribute(ATTR_ROID);
        } else if (theTypeElm.getLocalName().equals(ELM_EXT)) {
            this.type = 1;
            Element theExtElm = EPPUtil.getFirstElementChild(theTypeElm);
            try {
                this.ext = EPPFactory.getInstance().createExtension(theExtElm);
            }
            catch (EPPCodecException e) {
                throw new EPPDecodeException("EPPValidateAuthInfo.decode unable to create authInfo extension object: " + e);
            }
            this.ext.decode(theExtElm);
        } else {
            throw new EPPDecodeException("EPPValidateAuthInfo.decode invalid type child element tag name of " + theTypeElm.getTagName());
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateAuthInfo)) {
            cat.error("EPPValidateAuthInfo.equals(): " + aObject.getClass().getName() + " not EPPValidateAuthInfo instance");
            return false;
        }
        EPPValidateAuthInfo theComp = (EPPValidateAuthInfo)aObject;
        if (!EqualityUtil.equals(this.password, theComp.password)) {
            cat.error("EPPValidateAuthInfo.equals(): password not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.ext, theComp.ext)) {
            cat.error("EPPValidateAuthInfo.equals(): ext not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.type, theComp.type)) {
            cat.error("EPPValidateAuthInfo.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.roid, theComp.roid)) {
            cat.error("EPPValidateAuthInfo.equals(): roid not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }
}

