/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secureauthinfo.v1_0;

import com.verisign.epp.codec.contact.EPPContactAddChange;
import com.verisign.epp.codec.contact.EPPContactAddress;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.secureauthinfo.EPPAuthInfoFactory;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPSecureAuthInfoTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPSecureAuthInfoTst(String name) {
        super(name);
    }

    public void testDomainCreate() {
        EPPCodecTst.printStart("testDomainCreate");
        EPPDomainCreateCmd theCommand = new EPPDomainCreateCmd("ABC-12345", "example.com", new EPPAuthInfo(""));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainCreate");
    }

    public void testContactCreate() {
        EPPCodecTst.printStart("testContactCreate");
        Vector<String> streets = new Vector<String>();
        streets.addElement("123 Example Dr.");
        streets.addElement("Suite 100");
        EPPContactAddress address = new EPPContactAddress(streets, "Dulles", "VA", "20166-6503", "US");
        EPPContactPostalDefinition name = new EPPContactPostalDefinition("John Doe", "Example Inc.", "int", address);
        EPPContactCreateCmd theCommand = new EPPContactCreateCmd("ABC-12345", "DepDisclose", name, "jdoe@example.com", new EPPAuthInfo(""));
        theCommand.setFax("+1.7035555556");
        theCommand.setVoice("+1.7035555555");
        theCommand.setVoiceExt("1234");
        EPPContactDisclose disclose = new EPPContactDisclose();
        disclose.setFlag(false);
        disclose.setVoice(true);
        disclose.setEmail(true);
        theCommand.setDisclose(disclose);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactCreate");
    }

    public void testDomainUpdateSet() {
        EPPCodecTst.printStart("testDomainUpdateSet");
        Vector<EPPDomainStatus> removeStatuses = new Vector<EPPDomainStatus>();
        removeStatuses.addElement(new EPPDomainStatus("clientTransferProhibited"));
        EPPDomainAddRemove removeItems = new EPPDomainAddRemove();
        removeItems.setStatuses(removeStatuses);
        EPPDomainAddRemove changeItems = new EPPDomainAddRemove();
        changeItems.setAuthInfo(EPPAuthInfoFactory.createAuthInfo(20));
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", null, removeItems, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
    }

    public void testDomainUpdateUnsetNull() {
        EPPCodecTst.printStart("testDomainUpdateUnsetNull");
        Vector<EPPDomainStatus> addStatuses = new Vector<EPPDomainStatus>();
        addStatuses.addElement(new EPPDomainStatus("clientTransferProhibited"));
        EPPDomainAddRemove addItems = new EPPDomainAddRemove();
        addItems.setStatuses(addStatuses);
        EPPDomainAddRemove changeItems = new EPPDomainAddRemove();
        EPPAuthInfo nullAuthInfo = new EPPAuthInfo();
        nullAuthInfo.removePassword();
        changeItems.setAuthInfo(nullAuthInfo);
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", addItems, null, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateUnsetNull");
    }

    public void testDomainUpdateUnsetEmpty() {
        EPPCodecTst.printStart("testDomainUpdateUnsetEmpty");
        Vector<EPPDomainStatus> addStatuses = new Vector<EPPDomainStatus>();
        addStatuses.addElement(new EPPDomainStatus("clientTransferProhibited"));
        EPPDomainAddRemove addItems = new EPPDomainAddRemove();
        addItems.setStatuses(addStatuses);
        EPPDomainAddRemove changeItems = new EPPDomainAddRemove();
        changeItems.setAuthInfo(new EPPAuthInfo(""));
        EPPDomainUpdateCmd theCommand = new EPPDomainUpdateCmd("ABC-12345-XYZ", "example.com", addItems, null, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainUpdateUnsetEmpty");
    }

    public void testContactUpdateUnsetEmpty() {
        EPPContactUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testContactUpdateUnsetEmpty");
        EPPContactAddChange changeItems = new EPPContactAddChange();
        changeItems.setAuthInfo(new EPPAuthInfo(""));
        theCommand = new EPPContactUpdateCmd("ABC-12345-XYZ", "sh8013", null, null, changeItems);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testContactUpdateUnsetEmpty");
    }

    public void testDomainInfo() {
        EPPCodecTst.printStart("testDomainInfo");
        EPPDomainInfoCmd theCommand = new EPPDomainInfoCmd("ABC-12345", "example.com");
        theCommand.setAuthInfo(EPPAuthInfoFactory.createAuthInfo(20));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainInfo");
    }

    public void testDomainTransfer() {
        EPPCodecTst.printStart("testDomainTransfer");
        EPPDomainTransferCmd theCommand = new EPPDomainTransferCmd("ABC-12345", "request", "example.com", EPPAuthInfoFactory.createAuthInfo(20), null);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testDomainTransfer");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPSecureAuthInfoTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.contact.EPPContactMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPDomainMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSecureAuthInfoTst Thread " + i, EPPSecureAuthInfoTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPSecureAuthInfoTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

