/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v11;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSecDNSExtCreate
implements EPPCodecComponent {
    private static final long serialVersionUID = -2754621455867222676L;
    public static final int UNSPEC_MAX_SIG_LIFE = -1;
    public static final int MIN_MAX_SIG_LIFE = 0;
    public static final int MAX_MAX_SIG_LIFE = Integer.MAX_VALUE;
    private static Logger cat = LoggerFactory.getLogger(EPPSecDNSExtCreate.class);
    public static final String ELM_MAX_SIG_LIFE = "secDNS:maxSigLife";
    public static final String ELM_NAME = "secDNS:create";
    private int maxSigLife = -1;
    private List dsData = null;
    private List keyData = null;

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:secDNS-1.1";
    }

    public EPPSecDNSExtCreate() {
    }

    public EPPSecDNSExtCreate(List aDsData, List aKeyData, int aMaxSigLife) {
        this.dsData = aDsData;
        this.keyData = aKeyData;
        this.maxSigLife = aMaxSigLife;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPSecDNSExtCreate.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPSecDNSExtCreate invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPSecDNSExtCreate.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.1", ELM_NAME);
        root.setAttribute("xmlns:secDNS", "urn:ietf:params:xml:ns:secDNS-1.1");
        if (this.maxSigLife != -1) {
            EPPUtil.encodeString(aDocument, root, this.maxSigLife + "", "urn:ietf:params:xml:ns:secDNS-1.1", ELM_MAX_SIG_LIFE);
        }
        EPPUtil.encodeCompList(aDocument, root, this.dsData);
        EPPUtil.encodeCompList(aDocument, root, this.keyData);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Integer maxSigLifeInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.1", ELM_MAX_SIG_LIFE);
        this.maxSigLife = maxSigLifeInt == null ? -1 : maxSigLifeInt;
        this.dsData = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:secDNS-1.1", "secDNS:dsData", EPPSecDNSExtDsData.class);
        if (this.dsData.isEmpty()) {
            this.dsData = null;
        }
        this.keyData = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:secDNS-1.1", "secDNS:keyData", EPPSecDNSExtKeyData.class);
        if (this.keyData.isEmpty()) {
            this.keyData = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSecDNSExtCreate)) {
            return false;
        }
        EPPSecDNSExtCreate theComp = (EPPSecDNSExtCreate)aObject;
        if (this.maxSigLife != theComp.maxSigLife) {
            return false;
        }
        if (!EPPUtil.equalLists(this.dsData, theComp.dsData)) {
            cat.error("EPPSecDNSExtCreate.equals(): dsData not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.keyData, theComp.keyData)) {
            cat.error("EPPSecDNSExtCreate.equals(): keyData not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.maxSigLife != -1 && this.maxSigLife < 0 && this.maxSigLife > Integer.MAX_VALUE) {
            throw new EPPCodecException("EPPSecDNSExtDsData maxSigLife of " + this.maxSigLife + " is out of range, must be between " + 0 + " and " + Integer.MAX_VALUE);
        }
        if (this.hasDsData() && this.hasKeyData()) {
            throw new EPPCodecException("EPPSecDNSExtCreate can not have both dsData and keyData set.");
        }
        if (!this.hasDsData() && !this.hasKeyData()) {
            throw new EPPCodecException("EPPSecDNSExtCreate must set either dsData or keyData.");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSecDNSExtCreate clone = null;
        clone = (EPPSecDNSExtCreate)super.clone();
        clone.maxSigLife = this.maxSigLife;
        if (this.dsData != null) {
            clone.dsData = new ArrayList(this.dsData);
        }
        if (this.keyData != null) {
            clone.keyData = new ArrayList(this.keyData);
        }
        return clone;
    }

    public boolean hasDsData() {
        return this.dsData != null ? !this.dsData.isEmpty() : false;
    }

    public List getDsData() {
        return this.dsData;
    }

    public void setDsData(List aDsData) {
        this.dsData = aDsData;
    }

    public void appendDsData(EPPSecDNSExtDsData aDsData) {
        if (this.dsData == null) {
            this.dsData = new ArrayList();
        }
        this.dsData.add(aDsData);
    }

    public boolean hasKeyData() {
        return this.keyData != null ? !this.keyData.isEmpty() : false;
    }

    public List getKeyData() {
        return this.keyData;
    }

    public void setKeyData(List aKeyData) {
        this.keyData = aKeyData;
    }

    public void appendKeyData(EPPSecDNSExtKeyData aKeyData) {
        if (this.keyData == null) {
            this.keyData = new ArrayList();
        }
        this.keyData.add(aKeyData);
    }

    public int getMaxSigLife() {
        return this.maxSigLife;
    }

    public void setMaxSigLife(int maxSigLife) {
        this.maxSigLife = maxSigLife;
    }

    public boolean hasMaxSigLife() {
        return this.maxSigLife != -1;
    }
}

