/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v10;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.secdnsext.v10.EPPSecDNSExtKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSecDNSExtDsData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPSecDNSExtDsData.class);
    static final String ELM_NAME = "secDNS:dsData";
    static final String ELM_KEY_TAG = "secDNS:keyTag";
    private static final String ELM_ALG = "secDNS:alg";
    private static final String ELM_DIGEST_TYPE = "secDNS:digestType";
    private static final String ELM_DIGEST = "secDNS:digest";
    public static final String ELM_MAX_SIG_LIFE = "secDNS:maxSigLife";
    private static final int UNSPEC_INT = -1;
    public static final int UNSPEC_KEY_TAG = -1;
    public static final int MIN_KEY_TAG = 0;
    public static final int MAX_KEY_TAG = 65535;
    public static final int UNSPEC_ALG = -1;
    public static final int MIN_ALG = 0;
    public static final int MAX_ALG = 255;
    public static final int UNSPEC_DIGEST_TYPE = -1;
    public static final int MIN_DIGEST_TYPE = 0;
    public static final int MAX_DIGEST_TYPE = 65535;
    public static final int SHA1_DIGEST_TYPE = 1;
    public static final int UNSPEC_MAX_SIG_LIFE = -1;
    public static final int MIN_MAX_SIG_LIFE = 0;
    public static final int MAX_MAX_SIG_LIFE = Integer.MAX_VALUE;
    private int keyTag = -1;
    private int alg = -1;
    private int digestType = -1;
    private String digest = null;
    private int maxSigLife = -1;
    private EPPSecDNSExtKeyData keyData = null;

    public EPPSecDNSExtDsData() {
    }

    public EPPSecDNSExtDsData(EPPSecDNSExtDsData dsData) {
        this(dsData.getKeyTag(), dsData.getAlg(), dsData.getDigestType(), dsData.getDigest(), dsData.getMaxSigLife(), dsData.getKeyData());
    }

    public EPPSecDNSExtDsData(int keyTag, int alg, int digestType, String digest, int maxSigLife, EPPSecDNSExtKeyData keyData) {
        this.setKeyTag(keyTag);
        this.setAlg(alg);
        this.setDigestType(digestType);
        this.setDigest(digest);
        this.setMaxSigLife(maxSigLife);
        this.setKeyData(keyData);
    }

    public EPPSecDNSExtDsData(int keyTag, int alg, int digestType, String digest) {
        this.setKeyTag(keyTag);
        this.setAlg(alg);
        this.setDigestType(digestType);
        this.setDigest(digest);
    }

    public EPPSecDNSExtDsData(int keyTag, int alg, int digestType, String digest, int maxSigLife) {
        this.setKeyTag(keyTag);
        this.setAlg(alg);
        this.setDigestType(digestType);
        this.setDigest(digest);
        this.setMaxSigLife(maxSigLife);
    }

    public EPPSecDNSExtDsData(int keyTag, int alg, int digestType, String digest, EPPSecDNSExtKeyData keyData) {
        this.setKeyTag(keyTag);
        this.setAlg(alg);
        this.setDigestType(digestType);
        this.setDigest(digest);
        this.setKeyData(keyData);
    }

    public EPPSecDNSExtDsData(int keyTag) {
        this.setKeyTag(keyTag);
    }

    public EPPSecDNSExtDsData(Integer keyTag) {
        this.setKeyTag(keyTag);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPSecDNSExtDsData.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPSecDNSExtDsData invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.keyTag + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_KEY_TAG);
        EPPUtil.encodeString(aDocument, root, this.alg + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_ALG);
        EPPUtil.encodeString(aDocument, root, this.digestType + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_DIGEST_TYPE);
        EPPUtil.encodeString(aDocument, root, this.digest, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_DIGEST);
        if (this.maxSigLife != -1) {
            EPPUtil.encodeString(aDocument, root, this.maxSigLife + "", "urn:ietf:params:xml:ns:secDNS-1.0", ELM_MAX_SIG_LIFE);
        }
        EPPUtil.encodeComp(aDocument, root, this.keyData);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Integer keyTagInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_KEY_TAG);
        this.keyTag = keyTagInt == null ? -1 : keyTagInt;
        Integer algInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_ALG);
        this.alg = algInt == null ? -1 : algInt;
        Integer digestTypeInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_DIGEST_TYPE);
        this.digestType = digestTypeInt == null ? -1 : digestTypeInt;
        this.setDigest(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_DIGEST));
        Integer maxSigLifeInt = EPPUtil.decodeInteger(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", ELM_MAX_SIG_LIFE);
        this.maxSigLife = maxSigLifeInt == null ? -1 : maxSigLifeInt;
        this.keyData = (EPPSecDNSExtKeyData)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:secDNS-1.0", "secDNS:keyData", EPPSecDNSExtKeyData.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSecDNSExtDsData)) {
            return false;
        }
        EPPSecDNSExtDsData theComp = (EPPSecDNSExtDsData)aObject;
        if (this.keyTag != theComp.keyTag) {
            return false;
        }
        if (this.alg != theComp.alg) {
            return false;
        }
        if (this.digestType != theComp.digestType) {
            return false;
        }
        if (!(this.digest != null ? this.digest.equals(theComp.digest) : theComp.digest == null)) {
            return false;
        }
        if (this.maxSigLife != theComp.maxSigLife) {
            return false;
        }
        return this.keyData != null ? this.keyData.equals(theComp.keyData) : theComp.keyData == null;
    }

    void validateState() throws EPPCodecException {
        if (this.keyTag == -1) {
            throw new EPPCodecException("EPPSecDNSExtDsData required element keyTag is not set");
        }
        if (this.keyTag < 0 && this.keyTag > 65535) {
            throw new EPPCodecException("EPPSecDNSExtDsData keyTag of " + this.keyTag + " is out of range, must be between " + 0 + " and " + 65535);
        }
        if (this.alg == -1) {
            throw new EPPCodecException("EPPSecDNSExtDsData required element alg is not set");
        }
        if (this.alg < 0 && this.alg > 255) {
            throw new EPPCodecException("EPPSecDNSExtDsData alg of " + this.alg + " is out of range, must be between " + 0 + " and " + 255);
        }
        if (this.digestType == -1) {
            throw new EPPCodecException("EPPSecDNSExtDsData required element digestType is not set");
        }
        if (this.digestType < 0 && this.digestType > 65535) {
            throw new EPPCodecException("EPPSecDNSExtDsData digestType of " + this.digestType + " is out of range, must be between " + 0 + " and " + 65535);
        }
        if (this.digest == null) {
            throw new EPPCodecException("EPPSecDNSExtDsData required attribute digest is not set");
        }
        if (this.maxSigLife != -1 && this.maxSigLife < 0 && this.maxSigLife > Integer.MAX_VALUE) {
            throw new EPPCodecException("EPPSecDNSExtDsData maxSigLife of " + this.maxSigLife + " is out of range, must be between " + 0 + " and " + Integer.MAX_VALUE);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPSecDNSExtDsData clone = null;
        clone = (EPPSecDNSExtDsData)super.clone();
        clone.keyTag = this.keyTag;
        clone.alg = this.alg;
        clone.digestType = this.digestType;
        clone.digest = this.digest;
        clone.maxSigLife = this.maxSigLife;
        clone.keyData = this.keyData;
        return clone;
    }

    public int getKeyTag() {
        return this.keyTag;
    }

    public void setKeyTag(int keyTag) {
        this.keyTag = keyTag;
    }

    public void setKeyTag(Integer keyTag) {
        if (keyTag == null) {
            this.setKeyTag(-1);
        } else {
            this.setKeyTag((int)keyTag);
        }
    }

    public int getAlg() {
        return this.alg;
    }

    public void setAlg(int alg) {
        this.alg = alg;
    }

    public int getDigestType() {
        return this.digestType;
    }

    public void setDigestType(int digestType) {
        this.digestType = digestType;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = EPPUtil.removeWhitespace(digest);
        if (this.digest != null) {
            this.digest = this.digest.toUpperCase();
        }
    }

    public int getMaxSigLife() {
        return this.maxSigLife;
    }

    public void setMaxSigLife(int maxSigLife) {
        this.maxSigLife = maxSigLife;
    }

    public boolean hasMaxSigLife() {
        return this.maxSigLife != -1;
    }

    public EPPSecDNSExtKeyData getKeyData() {
        return this.keyData;
    }

    public void setKeyData(EPPSecDNSExtKeyData keyData) {
        this.keyData = keyData;
    }

    public boolean hasKeyData() {
        return this.keyData != null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:secDNS-1.0";
    }
}

