/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.rgpext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRgpExtInfData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRgpExtInfData.class);
    public static final String ELM_NAME = "rgp:infData";
    private Vector statuses = new Vector();

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:rgp-1.0";
    }

    public EPPRgpExtInfData() {
    }

    public EPPRgpExtInfData(EPPRgpExtStatus aStatus) {
        this.statuses.add(aStatus);
    }

    public EPPRgpExtInfData(Vector aStatuses) {
        if (aStatuses != null) {
            this.statuses = aStatuses;
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRgpExtInfData.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRgpExtInfData invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPRgpExtInfData.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:rgp-1.0", ELM_NAME);
        root.setAttribute("xmlns:rgp", "urn:ietf:params:xml:ns:rgp-1.0");
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:rgp-1.0", "rgp:rgpStatus", EPPRgpExtStatus.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRgpExtInfData)) {
            return false;
        }
        EPPRgpExtInfData theComp = (EPPRgpExtInfData)aObject;
        return EPPUtil.equalVectors(this.statuses, theComp.statuses);
    }

    void validateState() throws EPPCodecException {
        if (this.statuses == null || this.statuses.size() == 0) {
            throw new EPPCodecException("At least one EPPRgpExtInfData statuses is required");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRgpExtInfData clone = null;
        clone = (EPPRgpExtInfData)super.clone();
        clone.statuses = (Vector)this.statuses.clone();
        return clone;
    }

    public EPPRgpExtStatus getStatus() {
        if (this.statuses.size() >= 1) {
            return (EPPRgpExtStatus)this.statuses.get(0);
        }
        return null;
    }

    public void setStatus(EPPRgpExtStatus aStatus) {
        this.statuses.add(aStatus);
    }

    public void addStatus(EPPRgpExtStatus aStatus) {
        this.statuses.add(aStatus);
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector aStatuses) {
        if (aStatuses != null) {
            this.statuses = aStatuses;
        }
    }
}

