/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.relateddomainext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAvailable;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFields;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRegistered;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRelatedDomainExtGroup
implements EPPCodecComponent {
    private static final long serialVersionUID = 1L;
    private static Logger cat = LoggerFactory.getLogger(EPPRelatedDomainExtGroup.class);
    public static final String ELM_NAME = "relDom:group";
    public static final String TYPE_TLD = "tld";
    public static final String TYPE_VARIANT = "variant";
    private static final String ELM_TYPE_ATTR = "type";
    private String type;
    private EPPRelatedDomainExtFields fields;
    private EPPRelatedDomainExtAvailable available;
    private EPPRelatedDomainExtRegistered registered;

    public EPPRelatedDomainExtGroup() {
    }

    public EPPRelatedDomainExtGroup(String aType, EPPRelatedDomainExtFields aFields) {
        this.type = aType;
        this.fields = aFields;
    }

    public EPPRelatedDomainExtGroup(String aType, EPPRelatedDomainExtFields aFields, EPPRelatedDomainExtAvailable aAvailable, EPPRelatedDomainExtRegistered aRegistered) {
        this.type = aType;
        this.fields = aFields;
        this.available = aAvailable;
        this.registered = aRegistered;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRelatedDomainExtGroup clone = (EPPRelatedDomainExtGroup)super.clone();
        if (this.fields != null) {
            clone.fields = (EPPRelatedDomainExtFields)this.fields.clone();
        }
        if (this.available != null) {
            clone.available = (EPPRelatedDomainExtAvailable)this.available.clone();
        }
        if (this.registered != null) {
            clone.registered = (EPPRelatedDomainExtRegistered)this.registered.clone();
        }
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.fields = (EPPRelatedDomainExtFields)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", "relDom:fields", EPPRelatedDomainExtFields.class);
        this.registered = (EPPRelatedDomainExtRegistered)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", "relDom:registered", EPPRelatedDomainExtRegistered.class);
        this.available = (EPPRelatedDomainExtAvailable)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/relatedDomain-1.0", "relDom:available", EPPRelatedDomainExtAvailable.class);
        this.type = aElement.getAttribute(ELM_TYPE_ATTR);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPRelatedDomainExtAvailable.encode(Document)");
        }
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPRelatedDomainExtAvailable.encode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPRelatedDomainExtAvailable invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/relatedDomain-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.fields);
        EPPUtil.encodeComp(aDocument, root, this.registered);
        EPPUtil.encodeComp(aDocument, root, this.available);
        root.setAttribute(ELM_TYPE_ATTR, this.type);
        return root;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EPPRelatedDomainExtGroup)) {
            return false;
        }
        EPPRelatedDomainExtGroup other = (EPPRelatedDomainExtGroup)obj;
        if (!EqualityUtil.equals(this.available, other.available)) {
            cat.error("EPPRelatedDomainExtGroup.equals(): available not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fields, other.fields)) {
            cat.error("EPPRelatedDomainExtGroup.equals(): fields not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.registered, other.registered)) {
            cat.error("EPPRelatedDomainExtGroup.equals(): registered not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error("EPPRelatedDomainExtGroup.equals(): type not equal");
            return false;
        }
        return true;
    }

    public EPPRelatedDomainExtAvailable getAvailable() {
        return this.available;
    }

    public EPPRelatedDomainExtFields getFields() {
        return this.fields;
    }

    public EPPRelatedDomainExtRegistered getRegistered() {
        return this.registered;
    }

    public String getType() {
        return this.type;
    }

    public void setAvailable(EPPRelatedDomainExtAvailable aAvailable) {
        this.available = aAvailable;
    }

    public void setFields(EPPRelatedDomainExtFields aFields) {
        this.fields = aFields;
    }

    public void setRegistered(EPPRelatedDomainExtRegistered aRegistered) {
        this.registered = aRegistered;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/relatedDomain-1.0";
    }

    private void validateState() throws EPPCodecException {
        if (this.type == null) {
            throw new EPPCodecException("Required attribute type is null.");
        }
        if (this.fields == null) {
            throw new EPPCodecException("Required attribute fields is null.");
        }
    }
}

