/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistrySupportedStatus
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistrySupportedStatus.class);
    public static final String ELM_LOCALNAME = "supportedStatus";
    public static final String ELM_NAME = "registry:supportedStatus";
    public static final String ELM_NAME_STATUS = "status";
    private List statuses = new ArrayList();

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistrySupportedStatus.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeList(aDocument, root, this.statuses, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:status");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.statuses = EPPUtil.decodeList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME_STATUS);
    }

    void validateState() throws EPPCodecException {
        if (!this.hasStatuses()) {
            throw new EPPCodecException("statuses is required");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistrySupportedStatus clone = (EPPRegistrySupportedStatus)super.clone();
        if (this.statuses != null) {
            clone.statuses = (List)((ArrayList)this.statuses).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistrySupportedStatus)) {
            return false;
        }
        EPPRegistrySupportedStatus theComp = (EPPRegistrySupportedStatus)aObject;
        if (!(this.statuses != null ? EPPUtil.equalLists(this.statuses, theComp.statuses) : theComp.statuses == null)) {
            cat.error("EPPRegistrySupportedStatus.equals(): statuses not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasStatuses() {
        return this.statuses != null && !this.statuses.isEmpty();
    }

    public List getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List statuses) {
        this.statuses = statuses;
    }

    public void addStatus(String status) {
        if (this.statuses == null) {
            this.statuses = new ArrayList();
        }
        this.statuses.add(status);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    public static class Status {
        public static final String DOMAIN_CLIENTDELETEPROHIBITED = "clientDeleteProhibited";
        public static final String DOMAIN_SERVERDELETEPROHIBITED = "serverDeleteProhibited";
        public static final String DOMAIN_CLIENTHOLD = "clientHold";
        public static final String DOMAIN_SERVERHOLD = "serverHold";
        public static final String DOMAIN_CLIENTRENEWPROHIBITED = "clientRenewProhibited";
        public static final String DOMAIN_SERVERRENEWPROHIBITED = "serverRenewProhibited";
        public static final String DOMAIN_CLIENTTRANSFERPROHIBITED = "clientTransferProhibited";
        public static final String DOMAIN_SERVERTRANSFERPROHIBITED = "serverTransferProhibited";
        public static final String DOMAIN_CLIENTUPDATEPROHIBITED = "clientUpdateProhibited";
        public static final String DOMAIN_SERVERUPDATEPROHIBITED = "serverUpdateProhibited";
        public static final String DOMAIN_INACTIVE = "inactive";
        public static final String DOMAIN_OK = "ok";
        public static final String DOMAIN_PENDINGCREATE = "pendingCreate";
        public static final String DOMAIN_PENDINGDELETE = "pendingDelete";
        public static final String DOMAIN_PENDINGRENEW = "pendingRenew";
        public static final String DOMAIN_PENDINGTRANSFER = "pendingTransfer";
        public static final String DOMAIN_PENDINGUPDATE = "pendingUpdate";
        public static final String HOST_CLIENTDELETEPROHIBITED = "clientDeleteProhibited";
        public static final String HOST_SERVERDELETEPROHIBITED = "serverDeleteProhibited";
        public static final String HOST_CLIENTUPDATEPROHIBITED = "clientUpdateProhibited";
        public static final String HOST_SERVERUPDATEPROHIBITED = "serverUpdateProhibited";
        public static final String HOST_LINKED = "linked";
        public static final String HOST_OK = "ok";
        public static final String HOST_PENDINGCREATE = "pendingCreate";
        public static final String HOST_PENDINGDELETE = "pendingDelete";
        public static final String HOST_PENDINGTRANSFER = "pendingTransfer";
        public static final String HOST_PENDINGUPDATE = "pendingUpdate";
        public static final String CONTACT_CLIENTDELETEPROHIBITED = "clientDeleteProhibited";
        public static final String CONTACT_SERVERDELETEPROHIBITED = "serverDeleteProhibited";
        public static final String CONTACT_CLIENTTRANSFERPROHIBITED = "clientTransferProhibited";
        public static final String CONTACT_SERVERTRANSFERPROHIBITED = "serverTransferProhibited";
        public static final String CONTACT_CLIENTUPDATEPROHIBITED = "clientUpdateProhibited";
        public static final String CONTACT_SERVERUPDATEPROHIBITED = "serverUpdateProhibited";
        public static final String CONTACT_LINKED = "linked";
        public static final String CONTACT_OK = "ok";
        public static final String CONTACT_PENDINGCREATE = "pendingCreate";
        public static final String CONTACT_PENDINGDELETE = "pendingDelete";
        public static final String CONTACT_PENDINGTRANSFER = "pendingTransfer";
        public static final String CONTACT_PENDINGUPDATE = "pendingUpdate";
    }
}

