/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCheckCmd
extends EPPCheckCmd {
    private static final long serialVersionUID = -5430412031466266011L;
    public static final int MAX_ZONES = 99;
    static final String ELM_NAME = "registry:check";
    private static final String ELM_ZONE_NAME = "registry:name";
    private List names;

    public EPPRegistryCheckCmd() {
        this.names = new ArrayList();
    }

    public EPPRegistryCheckCmd(String aTransId, String aName) {
        super(aTransId);
        this.names = new ArrayList();
        this.names.add(aName);
    }

    public EPPRegistryCheckCmd(String aTransId, List names) {
        super(aTransId);
        this.names = names;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryCheckCmd theMap = (EPPRegistryCheckCmd)aObject;
        return EPPUtil.equalLists(this.names, theMap.names);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCheckCmd clone = (EPPRegistryCheckCmd)super.clone();
        clone.names = (List)((ArrayList)this.names).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.names == null || this.names.size() == 0) {
            throw new EPPEncodeException("No zone names specified in EPPRegistryCheckCmd");
        }
        if (this.names.size() > 99) {
            throw new EPPEncodeException(this.names.size() + " zone names is greater than the maximum of " + 99 + " in EPPRegistryCheckCmd");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute("xmlns:registry", "http://www.verisign.com/epp/registry-1.0");
        EPPUtil.encodeList(aDocument, root, this.names, "http://www.verisign.com/epp/registry-1.0", ELM_ZONE_NAME);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.names = EPPUtil.decodeList(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_ZONE_NAME);
        if (this.names == null) {
            this.names = new ArrayList();
        }
    }

    public List getNames() {
        return this.names;
    }

    public void setNames(List names) {
        this.names = names;
    }

    public void setName(String name) {
        this.names = new ArrayList();
        this.names.add(name);
    }

    public void addName(String name) {
        if (this.names == null) {
            this.names = new ArrayList();
        }
        this.names.add(name);
    }
}

