/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.orgext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgExtAddRemChg
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgExtAddRemChg.class);
    public static final String ELM_ADD_NAME = "orgext:add";
    public static final String ELM_REM_NAME = "orgext:rem";
    public static final String ELM_CHG_NAME = "orgext:chg";
    private static final String ELM_RESELLER_ID = "id";
    private Action action;
    private List<EPPOrgExtId> orgIds = new ArrayList<EPPOrgExtId>();

    public EPPOrgExtAddRemChg() {
    }

    public EPPOrgExtAddRemChg(Action aAction) {
        this.setAction(aAction);
    }

    public String getElmName() {
        if (this.action != null) {
            return "orgext:" + this.action.toString();
        }
        return "undefined";
    }

    public EPPOrgExtAddRemChg(Action aAction, EPPOrgExtId aOrgId) {
        this.setAction(aAction);
        this.addOrgId(aOrgId);
    }

    public EPPOrgExtAddRemChg(Action aAction, List<EPPOrgExtId> aOrgIds) {
        this.setAction(aAction);
        this.setOrgIds(aOrgIds);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action aAction) {
        this.action = aAction;
    }

    public boolean hasOrgIds() {
        return !this.orgIds.isEmpty();
    }

    public List<EPPOrgExtId> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(List<EPPOrgExtId> aOrgIds) {
        this.orgIds = aOrgIds == null ? new ArrayList<EPPOrgExtId>() : aOrgIds;
    }

    public void addOrgId(EPPOrgExtId aOrgId) {
        this.orgIds.add(aOrgId);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.action == null) {
            throw new EPPEncodeException("Undefined action in EPPOrgExtAddRemChg");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:orgext-1.0", "orgext:" + (Object)((Object)this.action));
        EPPUtil.encodeCompList(aDocument, root, this.orgIds);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.action = Action.getAction(aElement.getLocalName());
        this.orgIds = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:orgext-1.0", "orgext:id", EPPOrgExtId.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgExtAddRemChg clone = (EPPOrgExtAddRemChg)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgExtAddRemChg)) {
            return false;
        }
        EPPOrgExtAddRemChg other = (EPPOrgExtAddRemChg)aObject;
        if (!EqualityUtil.equals((Object)this.action, (Object)other.action)) {
            cat.error("EPPOrgExtAddRemChg.equals(): action not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.orgIds, other.orgIds)) {
            cat.error("EPPOrgExtAddRemChg.equals(): orgIds not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:orgext-1.0";
    }

    public static enum Action {
        ADD("add"),
        REM("rem"),
        CHG("chg");

        private final String localElm;

        private Action(String aLocalElm) {
            this.localElm = aLocalElm;
        }

        public static Action getAction(String aLocalElm) {
            if (aLocalElm == null || aLocalElm.isEmpty()) {
                throw new InvalidParameterException("Action null or empty enum value of is not valid.");
            }
            if (aLocalElm.equals(Action.ADD.localElm)) {
                return ADD;
            }
            if (aLocalElm.equals(Action.REM.localElm)) {
                return REM;
            }
            if (aLocalElm.equals(Action.CHG.localElm)) {
                return CHG;
            }
            throw new InvalidParameterException("Action enum value of " + aLocalElm + " is not valid.");
        }

        public String toString() {
            return this.localElm;
        }
    }
}

