/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgCheckResult;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgCheckResp
extends EPPResponse {
    private static Logger cat = LoggerFactory.getLogger(EPPOrgCheckResp.class);
    public static final String ELM_LOCALNAME = "chkData";
    public static final String ELM_NAME = "org:chkData";
    private List<EPPOrgCheckResult> results = new ArrayList<EPPOrgCheckResult>();

    public EPPOrgCheckResp() {
    }

    public EPPOrgCheckResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPOrgCheckResp(EPPTransId aTransId, EPPOrgCheckResult aResult) {
        super(aTransId);
        this.addCheckResult(aResult);
    }

    public boolean hasCheckResults() {
        return this.results != null && !this.results.isEmpty();
    }

    public List<EPPOrgCheckResult> getCheckResults() {
        return this.results;
    }

    public void setCheckResults(List<EPPOrgCheckResult> aResults) {
        this.results = aResults == null ? new ArrayList<EPPOrgCheckResult>() : aResults;
    }

    public void setCheckResult(EPPOrgCheckResult aResult) {
        this.results = new ArrayList<EPPOrgCheckResult>();
        this.results.add(aResult);
    }

    public void addCheckResult(EPPOrgCheckResult aResult) {
        this.results.add(aResult);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (!this.hasCheckResults()) {
            throw new EPPEncodeException("At least one result is needed with EPPOrgCheckResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.results);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.results = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:cd", EPPOrgCheckResult.class);
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgCheckResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPOrgCheckResp theMap = (EPPOrgCheckResp)aObject;
        if (!EPPUtil.equalLists(this.results, theMap.results)) {
            cat.error("EPPOrgCheckResp.equals(): results not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgCheckResp clone = (EPPOrgCheckResp)super.clone();
        clone.results = (List)((ArrayList)this.results).clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

