/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationDocument
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationDocument.class);
    public static final String ELM_LOCALNAME = "document";
    public static final String ELM_NAME = "nv:document";
    private static final String ELM_FILE_TYPE = "fileType";
    private static final String ELM_FILE_CONTENT = "fileContent";
    private FileType fileType;
    private String fileContent;

    public EPPNameVerificationDocument() {
    }

    public EPPNameVerificationDocument(FileType aFileType, String aFileContent) {
        this.fileType = aFileType;
        this.fileContent = aFileContent;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType aFileType) {
        this.fileType = aFileType;
    }

    public String getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(String aFileContent) {
        this.fileContent = aFileContent;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.fileType == null) {
            throw new EPPEncodeException("fileType required attribute is not set");
        }
        if (this.fileContent == null) {
            throw new EPPEncodeException("fileContent required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.fileType.toString(), "urn:ietf:params:xml:ns:nv-1.0", "nv:fileType");
        EPPUtil.encodeString(aDocument, root, this.fileContent, "urn:ietf:params:xml:ns:nv-1.0", "nv:fileContent");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        String theFileTypeStr = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_FILE_TYPE);
        this.fileType = FileType.getFileType(theFileTypeStr);
        this.fileContent = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_FILE_CONTENT);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationDocument)) {
            return false;
        }
        EPPNameVerificationDocument other = (EPPNameVerificationDocument)aObject;
        if (!EqualityUtil.equals((Object)this.fileType, (Object)other.fileType)) {
            cat.error("EPPNameVerificationDocument.equals(): fileType not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fileContent, other.fileContent)) {
            cat.error("EPPNameVerificationDocument.equals(): fileContent not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationDocument clone = null;
        clone = (EPPNameVerificationDocument)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public static enum FileType {
        PDF("pdf"),
        JPG("jpg");

        private final String fileTypeStr;

        private FileType(String aFileTypeStr) {
            this.fileTypeStr = aFileTypeStr;
        }

        public static FileType getFileType(String aString) {
            if (aString.equals(FileType.PDF.fileTypeStr)) {
                return PDF;
            }
            if (aString.equals(FileType.JPG.fileTypeStr)) {
                return JPG;
            }
            throw new InvalidParameterException("File type enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.fileTypeStr;
        }
    }
}

