/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResult;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameVerificationCheckResp
extends EPPResponse {
    public static final String ELM_LOCALNAME = "chkData";
    static final String ELM_NAME = "nv:chkData";
    private static Logger cat = LoggerFactory.getLogger(EPPNameVerificationCheckResp.class);
    private List<EPPNameVerificationCheckResult> results = new ArrayList<EPPNameVerificationCheckResult>();

    public EPPNameVerificationCheckResp() {
    }

    public EPPNameVerificationCheckResp(EPPTransId aTransId) {
        super(aTransId);
    }

    public EPPNameVerificationCheckResp(EPPTransId aTransId, EPPNameVerificationCheckResult aResult) {
        super(aTransId);
        this.results.add(aResult);
    }

    public EPPNameVerificationCheckResp(EPPTransId aTransId, List<EPPNameVerificationCheckResult> aResults) {
        super(aTransId);
        this.results = aResults;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationCheckResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameVerificationCheckResp other = (EPPNameVerificationCheckResp)aObject;
        if (!EqualityUtil.equals(this.results, other.results)) {
            cat.error("EPPNameVerificationCheckResp.equals(): results not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationCheckResp clone = (EPPNameVerificationCheckResp)super.clone();
        clone.results = new ArrayList<EPPNameVerificationCheckResult>(this.results.size());
        for (EPPNameVerificationCheckResult item : this.results) {
            clone.results.add((EPPNameVerificationCheckResult)item.clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public void addResult(EPPNameVerificationCheckResult aResult) {
        this.results.add(aResult);
    }

    public void setCheckResults(List<EPPNameVerificationCheckResult> aResults) {
        this.results = aResults;
    }

    public List<EPPNameVerificationCheckResult> getCheckResults() {
        return this.results;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.results);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.results = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:nv-1.0", "nv:cd", EPPNameVerificationCheckResult.class);
    }
}

