/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.mark;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPCourt;
import com.verisign.epp.codec.mark.EPPTrademark;
import com.verisign.epp.codec.mark.EPPTreatyOrStatute;
import com.verisign.epp.util.EqualityUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMark
implements EPPCodecComponent {
    public static final String NS = "urn:ietf:params:xml:ns:mark-1.0";
    public static final String NS_PREFIX = "mark";
    public static final String NS_SCHEMA = "urn:ietf:params:xml:ns:mark-1.0 mark-1.0.xsd";
    private static Logger cat = LoggerFactory.getLogger(EPPMark.class);
    public static final String ELM_LOCALNAME = "mark";
    public static final String ELM_NAME = "mark:mark";
    List<EPPTrademark> trademarks;
    List<EPPTreatyOrStatute> treatyOrStatutes;
    List<EPPCourt> courts;

    public EPPMark() {
    }

    public EPPMark(List<EPPTrademark> aTrademarks, List<EPPTreatyOrStatute> aTreatyOrStatutes, List<EPPCourt> aCourts) {
        this.trademarks = aTrademarks;
        this.treatyOrStatutes = aTreatyOrStatutes;
        this.courts = aCourts;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMark clone = (EPPMark)super.clone();
        return clone;
    }

    public byte[] encode() throws EPPEncodeException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            DocumentImpl doc = new DocumentImpl();
            Element root = this.encode((Document)doc);
            doc.appendChild(root);
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.transform(new DOMSource(root), new StreamResult(os));
        }
        catch (EPPEncodeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            cat.error("Error encoding mark to byte[]: " + ex);
            throw new EPPEncodeException("Error encoding mark to byte[]");
        }
        return os.toByteArray();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPMark.encode(Document)");
        }
        Element root = aDocument.createElementNS(NS, ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.trademarks);
        EPPUtil.encodeCompList(aDocument, root, this.treatyOrStatutes);
        EPPUtil.encodeCompList(aDocument, root, this.courts);
        return root;
    }

    public void decode(byte[] aMarkArray) throws EPPDecodeException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(aMarkArray);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            this.decode(doc.getDocumentElement());
        }
        catch (Exception ex) {
            throw new EPPDecodeException("Error decoding mark array: " + ex);
        }
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.trademarks = EPPUtil.decodeCompList(aElement, NS, "mark:trademark", EPPTrademark.class);
        if (this.trademarks != null && this.trademarks.isEmpty()) {
            this.trademarks = null;
        }
        this.treatyOrStatutes = EPPUtil.decodeCompList(aElement, NS, "mark:treatyOrStatute", EPPTreatyOrStatute.class);
        if (this.treatyOrStatutes != null && this.treatyOrStatutes.isEmpty()) {
            this.treatyOrStatutes = null;
        }
        this.courts = EPPUtil.decodeCompList(aElement, NS, "mark:court", EPPCourt.class);
        if (this.courts != null && this.courts.isEmpty()) {
            this.courts = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMark)) {
            cat.error("EPPMark.equals(): aObject is not an EPPMark");
            return false;
        }
        EPPMark other = (EPPMark)aObject;
        if (!EqualityUtil.equals(this.trademarks, other.trademarks)) {
            cat.error("EPPMark.equals(): trademarks not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.treatyOrStatutes, other.treatyOrStatutes)) {
            cat.error("EPPMark.equals(): treatyOrStatutes not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.courts, other.courts)) {
            cat.error("EPPMark.equals(): courts not equal");
            return false;
        }
        return true;
    }

    public boolean hasTrademarks() {
        return this.trademarks != null;
    }

    public List<EPPTrademark> getTrademarks() {
        return this.trademarks;
    }

    public void setTrademarks(List<EPPTrademark> aTrademarks) {
        this.trademarks = aTrademarks;
    }

    public void addTrademark(EPPTrademark aTrademark) {
        if (this.trademarks == null) {
            this.trademarks = new ArrayList<EPPTrademark>();
        }
        this.trademarks.add(aTrademark);
    }

    public boolean hasTreatyOrStatutes() {
        return this.treatyOrStatutes != null;
    }

    public List<EPPTreatyOrStatute> getTreatyOrStatutes() {
        return this.treatyOrStatutes;
    }

    public void setTreatyOrStatutes(List<EPPTreatyOrStatute> aTreatyOrStatutes) {
        this.treatyOrStatutes = aTreatyOrStatutes;
    }

    public void addTreatyOrStatute(EPPTreatyOrStatute aTreatyOrStatute) {
        if (this.treatyOrStatutes == null) {
            this.treatyOrStatutes = new ArrayList<EPPTreatyOrStatute>();
        }
        this.treatyOrStatutes.add(aTreatyOrStatute);
    }

    public boolean hasCourts() {
        return this.courts != null;
    }

    public List<EPPCourt> getCourts() {
        return this.courts;
    }

    public void setCourts(List<EPPCourt> aCourts) {
        this.courts = aCourts;
    }

    public void addCourt(EPPCourt aCourt) {
        if (this.courts == null) {
            this.courts = new ArrayList<EPPCourt>();
        }
        this.courts.add(aCourt);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return NS;
    }
}

