/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.maintenance.v1_0;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPMaintenanceInfoCmd
extends EPPInfoCmd {
    private static Logger cat = LoggerFactory.getLogger(EPPMaintenanceInfoCmd.class);
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "maint:info";
    private static final String ELM_MAINTENANCE_ID = "id";
    private static final String ELM_MAINTENANCE_LIST = "list";
    private InfoType infoType = InfoType.list;
    private String maintenanceId;

    public EPPMaintenanceInfoCmd() {
    }

    public EPPMaintenanceInfoCmd(String aTransId) {
        super(aTransId);
    }

    public EPPMaintenanceInfoCmd(String aTransId, String aMaintenanceId) {
        super(aTransId);
        this.setMaintenanceId(aMaintenanceId);
    }

    public InfoType getInfoType() {
        return this.infoType;
    }

    public void setInfoType(InfoType aInfoType) {
        this.infoType = aInfoType;
    }

    public String getMaintenanceId() {
        return this.maintenanceId;
    }

    public void setMaintenanceId(String aMaintenanceId) {
        this.maintenanceId = aMaintenanceId;
        this.infoType = this.maintenanceId != null ? InfoType.id : InfoType.list;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.infoType == InfoType.id && this.maintenanceId == null) {
            throw new EPPEncodeException("Undefined maintenanceId in EPPMaintenanceInfoCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_NAME);
        switch (this.infoType) {
            case list: {
                root.appendChild(aDocument.createElementNS("urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:list"));
                break;
            }
            case id: {
                EPPUtil.encodeString(aDocument, root, this.maintenanceId, "urn:ietf:params:xml:ns:epp:maintenance-1.0", "maint:id");
            }
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.setMaintenanceId(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:maintenance-1.0", ELM_MAINTENANCE_ID));
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPMaintenanceInfoCmd)) {
            return false;
        }
        EPPMaintenanceInfoCmd other = (EPPMaintenanceInfoCmd)aObject;
        if (!EqualityUtil.equals((Object)this.infoType, (Object)other.infoType)) {
            cat.error("EPPMaintenanceInfoCmd.equals(): infoType not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maintenanceId, other.maintenanceId)) {
            cat.error("EPPMaintenanceInfoCmd.equals(): maintenanceId not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPMaintenanceInfoCmd clone = (EPPMaintenanceInfoCmd)super.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:maintenance-1.0";
    }

    public static enum InfoType {
        list,
        id;

    }
}

