/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchUpdate
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchUpdate.class);
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "launch:update";
    private static final String ELM_APPLICATION_ID = "applicationID";
    EPPLaunchPhase phase;
    String applicationId;

    public EPPLaunchUpdate() {
    }

    public EPPLaunchUpdate(EPPLaunchPhase aPhase, String aApplicationId) {
        this.phase = aPhase;
        this.applicationId = aApplicationId;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String aApplicationId) {
        this.applicationId = aApplicationId;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchUpdate clone = (EPPLaunchUpdate)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchUpdate.encode(Document)");
        }
        if (this.phase == null) {
            throw new EPPEncodeException("EPPLaunchUpdate phase attribute must be set.");
        }
        if (this.applicationId == null) {
            throw new EPPEncodeException("EPPLaunchUpdate applicationId attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.phase);
        EPPUtil.encodeString(aDocument, root, this.applicationId, "urn:ietf:params:xml:ns:launch-1.0", "launch:applicationID");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
        if (this.phase == null) {
            throw new EPPDecodeException("EPPLaunchUpdate phase element not found.");
        }
        this.applicationId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_APPLICATION_ID);
        if (this.applicationId == null) {
            throw new EPPDecodeException("EPPLaunchUpdate applicationId element not found.");
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchUpdate)) {
            cat.error("EPPLaunchUpdate.equals(): " + aObject.getClass().getName() + " not EPPLaunchUpdate instance");
            return false;
        }
        EPPLaunchUpdate other = (EPPLaunchUpdate)aObject;
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error("EPPLaunchUpdate.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.applicationId, other.applicationId)) {
            cat.error("EPPLaunchUpdate.equals(): applicationId not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }
}

