/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchCreData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchCreData.class);
    public static final String ELM_LOCALNAME = "creData";
    public static final String ELM_NAME = "launch:creData";
    private static final String ELM_APPLICATION_ID = "applicationID";
    EPPLaunchPhase phase;
    String applicationId;

    public EPPLaunchCreData() {
    }

    public EPPLaunchCreData(EPPLaunchPhase aPhase, String aApplicationId) {
        this.phase = aPhase;
        this.applicationId = aApplicationId;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String aApplicationId) {
        this.applicationId = aApplicationId;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCreData clone = (EPPLaunchCreData)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCreData.encode(Document)");
        }
        if (this.phase == null) {
            throw new EPPEncodeException("EPPLaunchCreData phase attribute must be set.");
        }
        if (this.applicationId == null) {
            throw new EPPEncodeException("EPPLaunchCreData applicationId attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.phase);
        EPPUtil.encodeString(aDocument, root, this.applicationId, "urn:ietf:params:xml:ns:launch-1.0", "launch:applicationID");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
        if (this.phase == null) {
            throw new EPPDecodeException("EPPLaunchCreData phase element not found.");
        }
        this.applicationId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_APPLICATION_ID);
        if (this.applicationId == null) {
            throw new EPPDecodeException("EPPLaunchCreData applicationId element not found.");
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCreData)) {
            cat.error("EPPLaunchCreData.equals(): " + aObject.getClass().getName() + " not EPPLaunchCreData instance");
            return false;
        }
        EPPLaunchCreData other = (EPPLaunchCreData)aObject;
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error("EPPLaunchCreData.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.applicationId, other.applicationId)) {
            cat.error("EPPLaunchCreData.equals(): applicationId not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }
}

