/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLaunchClaimKey
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPLaunchClaimKey.class);
    public static final String ELM_LOCALNAME = "claimKey";
    public static final String ELM_NAME = "launch:claimKey";
    private static final String ATTR_VALIDATOR_ID = "validatorID";
    private String claimKey;
    private String validatorId = null;

    public EPPLaunchClaimKey() {
    }

    public EPPLaunchClaimKey(String aClaimKey) {
        this.claimKey = aClaimKey;
    }

    public EPPLaunchClaimKey(String aClaimKey, String aValidatorId) {
        this(aClaimKey);
        this.validatorId = aValidatorId;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchClaimKey.encode(Document)");
        }
        if (this.claimKey == null) {
            throw new EPPEncodeException("EPPLaunchClaimKey claimKey attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        Text textNode = aDocument.createTextNode(this.claimKey);
        root.appendChild(textNode);
        if (this.validatorId != null) {
            root.setAttribute(ATTR_VALIDATOR_ID, this.validatorId);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.claimKey = EPPUtil.getTextContent(aElement, true);
        if (aElement.hasAttribute(ATTR_VALIDATOR_ID)) {
            this.validatorId = aElement.getAttribute(ATTR_VALIDATOR_ID);
            if (this.validatorId != null && this.validatorId.length() == 0) {
                this.validatorId = null;
            }
        } else {
            this.validatorId = null;
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchClaimKey)) {
            cat.error("EPPLaunchClaimKey.equals(): aObject is not an EPPLaunchClaimKey");
            return false;
        }
        EPPLaunchClaimKey other = (EPPLaunchClaimKey)aObject;
        if (!EqualityUtil.equals(this.claimKey, other.claimKey)) {
            cat.error("EPPLaunchClaimKey.equals(): claimKey not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.validatorId, other.validatorId)) {
            cat.error("EPPLaunchClaimKey.equals(): validatorId not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchClaimKey clone = null;
        clone = (EPPLaunchClaimKey)super.clone();
        return clone;
    }

    public String getClaimKey() {
        return this.claimKey;
    }

    public void setClaimKey(String aClaimKey) {
        this.claimKey = aClaimKey;
    }

    public String getValidatorId() {
        return this.validatorId;
    }

    public void setValidatorId(String aValidatorId) {
        this.validatorId = aValidatorId;
    }

    public boolean hasValidatorId() {
        return this.validatorId != null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:launch-1.0";
    }
}

