/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPPurpose;
import com.verisign.epp.codec.gen.EPPRecipient;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPStatement
implements EPPCodecComponent {
    public static final short RETENTION_BUSINESS = 0;
    public static final short RETENTION_INDEFINITE = 1;
    public static final short RETENTION_LEGAL = 2;
    public static final short RETENTION_NONE = 3;
    public static final short RETENTION_STATED = 4;
    private static HashMap retentionElmHash;
    static final String ELM_NAME = "statement";
    private static final String ELM_RETENTION = "retention";
    private static final String ELM_RETENTION_BUSINESS = "business";
    private static final String ELM_RETENTION_INDEFINITE = "indefinite";
    private static final String ELM_RETENTION_LEGAL = "legal";
    private static final String ELM_RETENTION_NONE = "none";
    private static final String ELM_RETENTION_STATED = "stated";
    private static final String[] retentionElms;
    private static Logger cat;
    private EPPPurpose purpose = null;
    private EPPRecipient recipient = null;
    private short retention = 0;

    public EPPStatement() {
    }

    public EPPStatement(EPPRecipient aRecipient, EPPPurpose aPurpose, short aRetention) {
        this.recipient = aRecipient;
        this.purpose = aPurpose;
        this.retention = aRetention;
    }

    public EPPRecipient getRecipient() {
        return this.recipient;
    }

    public void setRecipient(EPPRecipient aRecipient) {
        this.recipient = aRecipient;
    }

    public EPPPurpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(EPPPurpose apurpouse) {
        this.purpose = apurpouse;
    }

    public short getRetention() {
        return this.retention;
    }

    public void setRetention(short aRetention) {
        this.retention = aRetention;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        if (this.purpose == null || this.recipient == null) {
            cat.error("EPPStatement.encode(): purpose, recipient, and retention must not be null");
            throw new EPPEncodeException("EPPStatement.encode(): purpose, recipient, and retention must not be null");
        }
        EPPUtil.encodeComp(aDocument, root, this.purpose);
        EPPUtil.encodeComp(aDocument, root, this.recipient);
        if (this.retention < 0 || this.retention >= retentionElms.length) {
            cat.error("EPPStatement.encode(): Unknown retention value of " + this.retention);
            throw new EPPEncodeException("EPPStatement.encode(): Unknown retention value of " + this.retention);
        }
        Element theRetentionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_RETENTION);
        root.appendChild(theRetentionElm);
        theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", retentionElms[this.retention]);
        theRetentionElm.appendChild(theElm);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        this.purpose = (EPPPurpose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", "purpose", EPPPurpose.class);
        this.recipient = (EPPRecipient)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp-1.0", "recipient", EPPRecipient.class);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp-1.0", ELM_RETENTION);
        if (theElm == null) {
            cat.error("EPPStatement.decode(): could not find retention element");
            throw new EPPDecodeException("EPPStatement could not find retention element");
        }
        Element theRetentionValueElm = EPPUtil.getFirstElementChild(theElm);
        if (theRetentionValueElm == null) {
            cat.error("EPPStatement.decode(): could not find retention element value");
            throw new EPPDecodeException("EPPStatement could not find retention element value");
        }
        Short theRetentionValue = (Short)retentionElmHash.get(theRetentionValueElm.getLocalName());
        if (theRetentionValue == null) {
            cat.error("EPPStatement.decode(): could not find valid retention element value");
            throw new EPPDecodeException("EPPStatement could not find valid retention element value");
        }
        this.retention = theRetentionValue;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPStatement)) {
            cat.error("EPPStatement.equals(): " + aObject.getClass().getName() + " not EPPStatement instance");
            return false;
        }
        EPPStatement theStatment = (EPPStatement)aObject;
        if (!(this.purpose != null ? this.purpose.equals(theStatment.purpose) : theStatment.purpose == null)) {
            cat.error("EPPStatement.equals(): purpose not equal");
            return false;
        }
        if (!(this.recipient != null ? this.recipient.equals(theStatment.recipient) : theStatment.recipient == null)) {
            cat.error("EPPStatement.equals(): recipient not equal");
            return false;
        }
        if (this.retention != theStatment.retention) {
            cat.error("EPPStatement.equals(): retention not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPStatement clone = null;
        clone = (EPPStatement)super.clone();
        clone.purpose = (EPPPurpose)this.purpose.clone();
        clone.recipient = (EPPRecipient)this.recipient.clone();
        clone.retention = this.retention;
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    static {
        retentionElms = new String[]{ELM_RETENTION_BUSINESS, ELM_RETENTION_INDEFINITE, ELM_RETENTION_LEGAL, ELM_RETENTION_NONE, ELM_RETENTION_STATED};
        retentionElmHash = new HashMap();
        retentionElmHash.put(EPPUtil.getLocalName(ELM_RETENTION_BUSINESS), (short)0);
        retentionElmHash.put(EPPUtil.getLocalName(ELM_RETENTION_INDEFINITE), (short)1);
        retentionElmHash.put(EPPUtil.getLocalName(ELM_RETENTION_LEGAL), (short)2);
        retentionElmHash.put(EPPUtil.getLocalName(ELM_RETENTION_NONE), (short)3);
        retentionElmHash.put(EPPUtil.getLocalName(ELM_RETENTION_STATED), (short)4);
        cat = LoggerFactory.getLogger(EPPStatement.class);
    }
}

