/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.domain.EPPHostAttr;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainCreateCmd
extends EPPCreateCmd {
    public static final String ELM_LOCALNAME = "create";
    public static final String ELM_NAME = "domain:create";
    static final String ELM_REGISTRANT = "registrant";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ELM_SERVER = "ns";
    private static final String ELM_HOST_OBJ = "hostObj";
    private static final String ELM_HOST_ATTR = "domain:hostAttr";
    private static final String ELM_CONTACT = "contact";
    private static Logger cat = LoggerFactory.getLogger(EPPDomainCreateCmd.class);
    private String name = null;
    private EPPDomainPeriod period = null;
    private Vector<String> servers = null;
    private Vector<EPPHostAttr> serverAttrs = null;
    private Vector<EPPDomainContact> contacts = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;

    public EPPDomainCreateCmd() {
        this.name = null;
        this.period = null;
        this.servers = null;
        this.contacts = null;
    }

    public EPPDomainCreateCmd(String aTransId, String aName, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        this.period = null;
        this.servers = null;
        this.contacts = null;
    }

    public EPPDomainCreateCmd(String aTransId, String aName, Vector<String> aServers, Vector<EPPDomainContact> aContacts, EPPDomainPeriod aPeriod, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.period = aPeriod;
        this.servers = aServers;
        this.contacts = aContacts;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
        if (this.hasServers() && this.hasServerAttrs()) {
            throw new EPPCodecException("both name server objects and attributes are defined");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean hasServers() {
        return this.servers != null ? !this.servers.isEmpty() : false;
    }

    public Vector<String> getServers() {
        return this.servers;
    }

    public void setServers(Vector<String> aServers) {
        this.servers = aServers;
    }

    public void addServer(String aServer) {
        if (this.servers == null) {
            this.servers = new Vector();
        }
        this.servers.add(aServer);
    }

    public boolean hasServerAttrs() {
        return this.serverAttrs != null ? !this.serverAttrs.isEmpty() : false;
    }

    public Vector<EPPHostAttr> getServerAttrs() {
        return this.serverAttrs;
    }

    public void setServerAttrs(Vector<EPPHostAttr> aServerAttrs) {
        this.serverAttrs = aServerAttrs;
    }

    public void addServerAttr(EPPHostAttr aServerAttr) {
        if (this.serverAttrs == null) {
            this.serverAttrs = new Vector();
        }
        this.serverAttrs.add(aServerAttr);
    }

    public boolean hasContacts() {
        return this.contacts != null ? !this.contacts.isEmpty() : false;
    }

    public Vector<EPPDomainContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector<EPPDomainContact> aContacts) {
        this.contacts = aContacts;
    }

    public void addContact(EPPDomainContact aContact) {
        if (this.contacts == null) {
            this.contacts = new Vector();
        }
        this.contacts.add(aContact);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainCreateCmd)) {
            cat.error("EPPDomainCreateCmd.equals(): " + aObject.getClass().getName() + " not EPPDomainCreateCmd instance");
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error("EPPDomainCreateCmd.equals(): super class not equal");
            return false;
        }
        EPPDomainCreateCmd theComp = (EPPDomainCreateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error("EPPDomainCreateCmd.equals(): name not equal");
            return false;
        }
        if (!(this.period != null ? this.period.equals(theComp.period) : theComp.period == null)) {
            cat.error("EPPDomainCreateCmd.equals(): period not equal");
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            cat.error("EPPDomainCreateCmd.equals(): authInfo not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.servers, theComp.servers)) {
            cat.error("EPPDomainCreateCmd.equals(): servers not equal");
            return false;
        }
        if (!EPPUtil.equalVectors(this.serverAttrs, theComp.serverAttrs)) {
            cat.error("EPPDomainCreateCmd.equals(): serverAttrs not equal");
            return false;
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0") && !EPPUtil.equalVectors(this.contacts, theComp.contacts)) {
            cat.error("EPPDomainCreateCmd.equals(): contacts not equal");
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null)) {
            cat.error("EPPDomainCreateCmd.equals(): registrant not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainCreateCmd clone = (EPPDomainCreateCmd)super.clone();
        if (this.servers != null) {
            clone.servers = (Vector)this.servers.clone();
        }
        if (this.serverAttrs != null) {
            clone.serverAttrs = (Vector)this.serverAttrs.clone();
        }
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
            for (int i = 0; i < this.contacts.size(); ++i) {
                clone.contacts.setElementAt((EPPDomainContact)this.contacts.elementAt(i).clone(), i);
            }
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPDomainPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPDomainPeriod getPeriod() {
        return this.period;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public void setPeriod(EPPDomainPeriod aPeriod) {
        this.period = aPeriod;
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error("EPPDomainCreateCmd.doEncode(): Invalid state on encode: " + e);
            throw new EPPEncodeException("EPPDomainCreateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", "domain:name");
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        if (this.hasServers() || this.hasServerAttrs()) {
            Element theServersElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:ns");
            root.appendChild(theServersElm);
            if (this.hasServers()) {
                EPPUtil.encodeVector(aDocument, theServersElm, this.servers, "urn:ietf:params:xml:ns:domain-1.0", "domain:hostObj");
            } else {
                EPPUtil.encodeCompVector(aDocument, theServersElm, this.serverAttrs);
            }
        }
        if (this.registrant != null) {
            EPPUtil.encodeString(aDocument, root, this.registrant, "urn:ietf:params:xml:ns:domain-1.0", "domain:registrant");
        }
        if (this.contacts != null) {
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theServerElm;
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.period = (EPPDomainPeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:period", EPPDomainPeriod.class);
        Element theServersElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_SERVER);
        if (theServersElm != null && (theServerElm = EPPUtil.getFirstElementChild(theServersElm)) != null) {
            if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_OBJ))) {
                this.servers = EPPUtil.decodeVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_OBJ);
                if (this.servers.size() == 0) {
                    this.servers = null;
                }
                this.serverAttrs = null;
            } else if (theServerElm.getLocalName().equals(EPPUtil.getLocalName(ELM_HOST_ATTR))) {
                this.serverAttrs = EPPUtil.decodeCompVector(theServersElm, "urn:ietf:params:xml:ns:domain-1.0", ELM_HOST_ATTR, EPPHostAttr.class);
                if (this.serverAttrs.size() == 0) {
                    this.serverAttrs = null;
                }
                this.servers = null;
            } else {
                throw new EPPDecodeException("EPPDomainCreateCmd.doDecode: Invalid host child element " + theServersElm.getLocalName());
            }
        }
        this.registrant = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_REGISTRANT);
        this.contacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_CONTACT, EPPDomainContact.class);
        if (this.contacts.size() == 0) {
            this.contacts = null;
        }
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
    }
}

