/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPDomainCheckResult
implements EPPCodecComponent {
    static final String ELM_NAME = "domain:cd";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private static final String ELM_DOMAIN_REASON = "domain:reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private String name;
    private boolean available;
    private String reason;

    public EPPDomainCheckResult() {
        this.name = null;
        this.available = true;
    }

    public EPPDomainCheckResult(String aName, boolean aIsAvailable) {
        this.name = aName;
        this.available = aIsAvailable;
    }

    public EPPDomainCheckResult(String aName, boolean aIsAvailable, String aReason) {
        this.name = aName;
        this.available = aIsAvailable;
        this.reason = aReason;
    }

    public EPPDomainCheckResult(String aName, boolean aIsAvailable, String aReason, String aLanguage) {
        this.name = aName;
        this.available = aIsAvailable;
        this.reason = aReason;
        this.language = aLanguage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isKnown() {
        return !this.available;
    }

    public void setIsKnown(boolean aIsKnown) {
        this.available = !aIsKnown;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setIsAvailable(boolean aIsAvailable) {
        this.available = aIsAvailable;
    }

    public void setDomainReason(String aReason) {
        this.reason = aReason;
    }

    public String getDomainReason() {
        return this.reason;
    }

    public void setLanguage(String aLang) {
        this.language = aLang;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        root.appendChild(nameElm);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_REASON);
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theNameElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.name = theNameElm.getFirstChild().getNodeValue();
        this.available = EPPUtil.decodeBooleanAttr(theNameElm, ATTR_AVAIL);
        Element theReasonElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_REASON);
        if (theReasonElm != null) {
            this.reason = theReasonElm.getFirstChild().getNodeValue();
            String theLang = theReasonElm.getAttribute(ATTR_LANG);
            if (theLang.length() > 0 && !theLang.equals(VALUE_LANG)) {
                this.setLanguage(theLang);
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainCheckResult)) {
            return false;
        }
        EPPDomainCheckResult theComp = (EPPDomainCheckResult)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.available == theComp.available;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainCheckResult clone = null;
        clone = (EPPDomainCheckResult)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }
}

