/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPDefRegStatus
implements EPPCodecComponent {
    public static final String ELM_STATUS_OK = "ok";
    public static final String ELM_STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String ELM_STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String ELM_STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String ELM_STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String ELM_STATUS_PENDING_DELETE = "pendingDelete";
    public static final String ELM_STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String ELM_STATUS_PENDING_VERIFICATION = "pendingVerification";
    public static final String ELM_STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String ELM_STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String ELM_STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String ELM_STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String ELM_DEFAULT_LANG = "en";
    static final String ELM_NAME = "defReg:status";
    static final String ELM_STATUS = "s";
    static final String ELM_LANG = "lang";
    private String status = "ok";
    private String lang = "en";
    private String description = null;

    public EPPDefRegStatus() {
    }

    public EPPDefRegStatus(String aStatus) {
        this.status = aStatus;
    }

    public EPPDefRegStatus(String aStatus, String aDesc) {
        this.status = aStatus;
        this.description = aDesc;
    }

    public EPPDefRegStatus(String aStatus, String aDesc, String aLang) {
        this.status = aStatus;
        this.description = aDesc;
        this.lang = aLang;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDefRegStatus clone = null;
        clone = (EPPDefRegStatus)super.clone();
        return clone;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.status = aElement.getAttribute(ELM_STATUS);
        Node descNode = aElement.getFirstChild();
        if (descNode != null) {
            this.description = descNode.getNodeValue();
            this.lang = aElement.getAttribute(ELM_LANG);
        }
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.status == null) {
            throw new EPPEncodeException("required attribute status is not set");
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", ELM_NAME);
        root.setAttribute(ELM_STATUS, this.status);
        if (this.description != null) {
            if (!this.lang.equals(ELM_DEFAULT_LANG)) {
                root.setAttribute(ELM_LANG, this.lang);
            }
            Text descVal = aDocument.createTextNode(this.description);
            root.appendChild(descVal);
        }
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDefRegStatus)) {
            return false;
        }
        EPPDefRegStatus theComp = (EPPDefRegStatus)aObject;
        if (!this.status.equals(theComp.status)) {
            return false;
        }
        if (!(this.description != null ? this.description.equals(theComp.description) : theComp.description == null)) {
            return false;
        }
        return this.lang.equals(theComp.lang);
    }

    public String getLang() {
        return this.lang;
    }

    public String getStatus() {
        return this.status;
    }

    public void setLang(String newLang) {
        this.lang = newLang;
    }

    public void setStatus(String newStatus) {
        this.status = newStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDesc) {
        this.description = aDesc;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/defReg-1.0";
    }
}

