/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactDisclose;
import com.verisign.epp.codec.contact.EPPContactPostalDefinition;
import com.verisign.epp.codec.contact.EPPContactStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPContactInfoResp
extends EPPResponse {
    private static final long serialVersionUID = -1028446700493015708L;
    static final String ELM_NAME = "contact:infData";
    private static final String ELM_CLIENT_ID = "contact:clID";
    private static final String ELM_CREATED_BY = "contact:crID";
    private static final String ELM_CREATED_DATE = "contact:crDate";
    private static final String ELM_LAST_UPDATED_BY = "contact:upID";
    private static final String ELM_LAST_UPDATED_DATE = "contact:upDate";
    private static final String ELM_LAST_TRANSFER_DATE = "contact:trDate";
    private static final String ELM_CONTACT_POSTAL_INFO = "contact:postalInfo";
    private static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private static final String ELM_CONTACT_EMAIL = "contact:email";
    private static final String ELM_CONTACT_FAX = "contact:fax";
    private static final String ELM_CONTACT_ID = "contact:id";
    private static final String ELM_CONTACT_STATUSES = "contact:status";
    private static final String ELM_CONTACT_VOICE = "contact:voice";
    private static final String ELM_ROID = "contact:roid";
    private static final String ELM_CONTACT_DISCLOSE = "contact:disclose";
    private static final String ATTR_EXT = "x";
    private String clientId = null;
    private String createdBy = null;
    private Date createdDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private Date lastTransferDate = null;
    private Vector postalContacts = new Vector();
    private EPPAuthInfo authInfo = null;
    private EPPContactDisclose disclose = null;
    private String email = null;
    private String fax = null;
    private String faxExt = null;
    private String id = null;
    private Vector statuses = null;
    private String voice = null;
    private String voiceExt = null;
    private String roid = null;

    public EPPContactInfoResp() {
    }

    public EPPContactInfoResp(EPPTransId aTransId, String aRoid, String aId, Vector newStatuses, EPPContactPostalDefinition aPostalInfo, String aEmail, String aClientId, String aCreatedBy, Date aCreatedDate, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.id = aId;
        this.roid = aRoid;
        this.statuses = newStatuses;
        this.postalContacts.add(aPostalInfo);
        this.email = aEmail;
        this.clientId = aClientId;
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public boolean hasCreatedBy() {
        return this.createdBy != null;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public boolean hasCreatedDate() {
        return this.createdDate != null;
    }

    public void setCreatedDate(Date aDate) {
        this.createdDate = aDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public boolean hasLastUpdatedBy() {
        return this.lastUpdatedBy != null;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public boolean hasLastUpdatedDate() {
        return this.lastUpdatedDate != null;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public Date getLastTransferDate() {
        return this.lastTransferDate;
    }

    public boolean hasLastTransferDate() {
        return this.lastTransferDate != null;
    }

    public void setLastTransferDate(Date aLastTransferDate) {
        this.lastTransferDate = aLastTransferDate;
    }

    private void validateState() throws EPPCodecException {
        if (!this.hasId()) {
            throw new EPPCodecException("required attribute id is not set");
        }
        if (!this.hasRoid()) {
            throw new EPPCodecException("required attribute roid is not set");
        }
        if (!this.hasStatuses()) {
            throw new EPPCodecException("required attribute contact statuses is not set");
        }
        if (!this.hasPostalContacts()) {
            throw new EPPCodecException("required attribute postalContacts is not set");
        }
        if (!this.hasEmail()) {
            throw new EPPCodecException("required attribute contact email is not set");
        }
        if (!this.hasClientId()) {
            throw new EPPCodecException("clientId required attribute is not set");
        }
        if (!this.hasCreatedBy()) {
            throw new EPPCodecException("createBy required attribute is not set");
        }
        if (!this.hasCreatedDate()) {
            throw new EPPCodecException("createdDate required attribute is not set");
        }
    }

    private void relaxedValidateState() throws EPPCodecException {
        if (!this.hasId()) {
            throw new EPPCodecException("required attribute id is not set");
        }
        if (!this.hasRoid()) {
            throw new EPPCodecException("required attribute roid is not set");
        }
        if (!this.hasStatuses()) {
            throw new EPPCodecException("required attribute contact statuses is not set");
        }
        if (!this.hasPostalContacts()) {
            throw new EPPCodecException("required attribute postalContacts is not set");
        }
        if (!this.hasClientId()) {
            throw new EPPCodecException("clientId required attribute is not set");
        }
        if (!this.hasCreatedBy()) {
            throw new EPPCodecException("createBy required attribute is not set");
        }
        if (!this.hasCreatedDate()) {
            throw new EPPCodecException("createdDate required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element currElm = null;
        Text currVal = null;
        try {
            if (EPPEnv.isContactRelaxedValidation()) {
                this.relaxedValidateState();
            } else {
                this.validateState();
            }
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPContactInfoResp.doEncode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:contact-1.0", ELM_ROID);
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        EPPUtil.encodeCompVector(aDocument, root, this.postalContacts);
        if (this.voice != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            currVal = aDocument.createTextNode(this.voice);
            if (this.voiceExt != null) {
                currElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        if (this.fax != null) {
            currElm = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            currVal = aDocument.createTextNode(this.fax);
            if (this.faxExt != null) {
                currElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            currElm.appendChild(currVal);
            root.appendChild(currElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:contact-1.0", ELM_CLIENT_ID);
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_BY);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_DATE);
        EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_BY);
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_DATE);
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastTransferDate, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_TRANSFER_DATE);
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        EPPUtil.encodeComp(aDocument, root, this.disclose);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element currElm = null;
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_ROID);
        this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_STATUSES, EPPContactStatus.class);
        this.postalContacts = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_POSTAL_INFO, EPPContactPostalDefinition.class);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
        if (this.voice != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
            this.voiceExt = currElm.getAttribute(ATTR_EXT);
            if (this.voiceExt.length() == 0) {
                this.voiceExt = null;
            }
        } else {
            this.voiceExt = null;
        }
        this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
        if (this.fax != null) {
            currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
            this.faxExt = currElm.getAttribute(ATTR_EXT);
            if (this.faxExt.length() == 0) {
                this.faxExt = null;
            }
        } else {
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CLIENT_ID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_BY);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CREATED_DATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_BY);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_UPDATED_DATE);
        this.lastTransferDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_LAST_TRANSFER_DATE);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO, EPPAuthInfo.class);
        this.disclose = (EPPContactDisclose)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_DISCLOSE, EPPContactDisclose.class);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactInfoResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactInfoResp theComp = (EPPContactInfoResp)aObject;
        if (!EqualityUtil.equals(this.id, theComp.id)) {
            return false;
        }
        if (!EqualityUtil.equals(this.roid, theComp.roid)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.postalContacts, theComp.postalContacts)) {
            return false;
        }
        if (!EqualityUtil.equals(this.voice, theComp.voice)) {
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, theComp.voiceExt)) {
            return false;
        }
        if (!EqualityUtil.equals(this.fax, theComp.fax)) {
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, theComp.faxExt)) {
            return false;
        }
        if (!EqualityUtil.equals(this.email, theComp.email)) {
            return false;
        }
        if (!EqualityUtil.equals(this.clientId, theComp.clientId)) {
            return false;
        }
        if (!EqualityUtil.equals(this.createdBy, theComp.createdBy)) {
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, theComp.createdDate)) {
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedBy, theComp.lastUpdatedBy)) {
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, theComp.lastUpdatedDate)) {
            return false;
        }
        if (!EqualityUtil.equals(this.lastTransferDate, theComp.lastTransferDate)) {
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, theComp.authInfo)) {
            return false;
        }
        return EqualityUtil.equals(this.disclose, theComp.disclose);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPContactInfoResp clone = (EPPContactInfoResp)super.clone();
        if (this.hasStatuses()) {
            clone.statuses = (Vector)this.statuses.clone();
            for (i = 0; i < this.statuses.size(); ++i) {
                clone.statuses.setElementAt(((EPPContactStatus)this.statuses.elementAt(i)).clone(), i);
            }
        }
        if (this.hasPostalContacts()) {
            clone.postalContacts = (Vector)this.postalContacts.clone();
            for (i = 0; i < this.postalContacts.size(); ++i) {
                clone.postalContacts.setElementAt(((EPPContactPostalDefinition)this.postalContacts.elementAt(i)).clone(), i);
            }
        }
        if (this.hasAuthInfo()) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.hasDisclose()) {
            clone.disclose = (EPPContactDisclose)this.disclose.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Vector getPostalInfo() {
        return this.postalContacts;
    }

    public boolean hasPostalContacts() {
        return this.postalContacts != null && this.postalContacts.elements().hasMoreElements();
    }

    public EPPContactPostalDefinition getFirstPostalInfo() {
        if (this.hasPostalContacts()) {
            return (EPPContactPostalDefinition)this.postalContacts.get(0);
        }
        return null;
    }

    public void setPostalInfo(Vector aPostalInfo) {
        this.postalContacts = aPostalInfo;
    }

    public void addPostalInfo(EPPContactPostalDefinition aPostalInfo) {
        this.postalContacts.add(aPostalInfo);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_AUTHINFO);
        }
    }

    public EPPContactDisclose getDisclose() {
        return this.disclose;
    }

    public boolean hasDisclose() {
        return this.disclose != null;
    }

    public void setDisclose(EPPContactDisclose aDisclose) {
        if (aDisclose != null) {
            this.disclose = aDisclose;
            this.disclose.setRootName(ELM_CONTACT_DISCLOSE);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getFax() {
        return this.fax;
    }

    public boolean hasFax() {
        return this.fax != null;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public boolean hasFaxExt() {
        return this.faxExt != null;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != null;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public boolean hasStatuses() {
        return this.statuses != null;
    }

    public void setStatuses(Vector aStatuses) {
        this.statuses = aStatuses;
    }

    public String getVoice() {
        return this.voice;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public boolean hasVoiceExt() {
        return this.voiceExt != null;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getRoid() {
        return this.roid;
    }

    public boolean hasRoid() {
        return this.roid != null;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }
}

