/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.verificationcode.china;

import com.verisign.epp.codec.changepoll.EPPChangeData;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.domain.EPPDomainCheckResult;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.lowbalancepoll.EPPLowBalancePollResponse;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResult;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateSuccess;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.codec.rgppoll.EPPRgpPollResponse;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCode;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfData;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfo;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPNameVerification;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.namestore.interfaces.NSDomain;
import com.verisign.epp.pool.EPPSessionPool;
import com.verisign.epp.util.InvalidateSessionException;
import com.verisign.epp.util.TestThread;
import com.verisign.epp.util.TestUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChinaVerificationCodeTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static Logger cat = LoggerFactory.getLogger(ChinaVerificationCodeTst.class);
    private static EPPSessionPool sessionPool = null;
    private static final String POOL_REGISTRY_1 = "registry1";
    private static final String POOL_REGISTRY_2 = "registry2";
    private static final String POOL_VSP = "vsp";
    private static boolean vspPoolExists = true;
    private static EPPEncodedSignedCodeValue dnvc;
    private static EPPEncodedSignedCodeValue rnvc;
    private Random rd = new Random(System.currentTimeMillis());

    public ChinaVerificationCodeTst(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalRegistrationOperations() {
        ChinaVerificationCodeTst.printStart("testNormalRegistrationOperations");
        EPPSession theRegistrySession = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            EPPResponse theResponse;
            EPPEncodedSignedCode theSignedCodeExt;
            EPPNameVerificationCreateSuccess theSuccessResult;
            List<Object> theResults;
            EPPResponse theResponse2;
            theRegistrySession = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain = new NSDomain(theRegistrySession);
            System.out.println("testUpfrontVerification: Got session to the Registry");
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testNormalRegistrationOperations: Got session to the Vsp");
            }
            String theDomainName = this.makeDomainName("cvct-normal-reg-op-", ".com");
            System.out.println("theDomainName = " + theDomainName);
            String[] theLabels = theDomainName.split("\\.");
            String theLabel = theLabels[0];
            String theTld = theLabels[1];
            EPPEncodedSignedCodeValue theDnvc = null;
            EPPEncodedSignedCodeValue theRnvc = null;
            if (!vspPoolExists) {
                theDnvc = dnvc;
                theRnvc = rnvc;
            }
            System.out.println("testNormalRegistrationOperations: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
            try {
                EPPDomainCheckResult theResult;
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theResponse2 = theDomain.sendCheck();
                theResults = ((EPPDomainCheckResp)theResponse2).getCheckResults();
                if (((Vector)theResults).size() != 1) {
                    Assert.fail((String)("Domain availability check result of 1 domain expected, but received " + ((Vector)theResults).size()));
                }
                if (!(theResult = (EPPDomainCheckResult)((Vector)theResults).get(0)).isAvailable()) {
                    Assert.fail((String)("Domain name " + theDomainName + " is not available with reason = " + theResult.getDomainReason()));
                }
                System.out.println("testNormalRegistrationOperations: Step 1 - Domain name " + theDomainName + " is available");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.addLabel(theLabel);
                    theResponse2 = theVsp.sendCheck();
                    theResults = ((EPPNameVerificationCheckResp)theResponse2).getCheckResults();
                    if (theResults.size() != 1) {
                        Assert.fail((String)("Vsp label check result of 1 label expected, but received " + theResults.size()));
                    }
                    if (!((EPPNameVerificationCheckResult)theResults.get(0)).isAvailable()) {
                        Assert.fail((String)("Label " + theLabel + " is not available (not restricted or prohibited) with reason = " + ((EPPNameVerificationCheckResult)theResults.get(0)).getReason()));
                    }
                    System.out.println("testNormalRegistrationOperations: Step 2 - Label " + theLabel + " is available (not restricted or prohibited)");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testNormalRegistrationOperations: Step 2 - Skipped due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                    theVsp.setAuthInfo("normalRegistrationOperations-3");
                    theResponse2 = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse2).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse2).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse2).getCreateResult();
                    theDnvc = theSuccessResult.getSignedCode();
                    System.out.println("testNormalRegistrationOperations: Step 3 - DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testNormalRegistrationOperations: Step 3 - Skipped due to no VSP pool");
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.setAuthString("normalRegistrationOperations-4");
                theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theDnvc);
                theDomain.addExtension(theSignedCodeExt);
                theResponse = theDomain.sendCreate();
                System.out.println("testNormalRegistrationOperations: Step 4 - Domain name " + theDomainName + " successfully created with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                    theVsp.setAuthInfo("normalRegistrationOperations-5");
                    theResponse2 = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse2).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse2).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse2).getCreateResult();
                    theRnvc = theSuccessResult.getSignedCode();
                    System.out.println("testNormalRegistrationOperations: Step 5 - RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testNormalRegistrationOperations: Step 5 - Skipped due to no VSP pool");
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theRnvc);
                theDomain.addExtension(theSignedCodeExt);
                theResponse = theDomain.sendUpdate();
                System.out.println("testNormalRegistrationOperations: Step 6 - Domain name " + theDomainName + " successfully update with RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.addExtension(new EPPVerificationCodeInfo());
                theResponse2 = theDomain.sendInfo();
                Assert.assertTrue((boolean)theResponse2.hasExtension(EPPVerificationCodeInfData.class));
                EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse2.getExtension(EPPVerificationCodeInfData.class);
                Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.COMPLIANT ? 1 : 0) != 0);
                System.out.println("testNormalRegistrationOperations: Domain name " + theDomainName + " verification is compliant");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.sendDelete();
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (theRegistrySession != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistrySession);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            try {
                if (ex.getSession() == theRegistrySession) {
                    this.invalidateSession(POOL_REGISTRY_1, theRegistrySession);
                    theRegistrySession = null;
                } else if (ex.getSession() == theVspSession) {
                    this.invalidateSession(POOL_VSP, theVspSession);
                    theVspSession = null;
                } else {
                    Assert.fail((String)"InvalidateSessionException received with no matching session");
                }
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
            }
            catch (Throwable throwable) {
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
                throw throwable;
            }
        }
        ChinaVerificationCodeTst.printEnd("testNormalRegistrationOperations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpfrontVerification() {
        ChinaVerificationCodeTst.printStart("testUpfrontVerification");
        EPPSession theRegistrySession = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            EPPNameVerificationCreateSuccess theSuccessResult;
            List<Object> theResults;
            EPPResponse theResponse;
            theRegistrySession = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain = new NSDomain(theRegistrySession);
            System.out.println("testUpfrontVerification: Got session to the Registry");
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testUpfrontVerification: Got session to the Vsp");
            }
            String theDomainName = this.makeDomainName("cvct-upfront-ver-", ".com");
            System.out.println("theDomainName = " + theDomainName);
            String[] theLabels = theDomainName.split("\\.");
            String theLabel = theLabels[0];
            String theTld = theLabels[1];
            EPPEncodedSignedCodeValue theDnvc = null;
            EPPEncodedSignedCodeValue theRnvc = null;
            if (!vspPoolExists) {
                theDnvc = dnvc;
                theRnvc = rnvc;
            }
            System.out.println("testUpfrontVerification: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
            try {
                EPPDomainCheckResult theResult;
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theResponse = theDomain.sendCheck();
                theResults = ((EPPDomainCheckResp)theResponse).getCheckResults();
                if (((Vector)theResults).size() != 1) {
                    Assert.fail((String)("Domain availability check result of 1 domain expected, but received " + ((Vector)theResults).size()));
                }
                if (!(theResult = (EPPDomainCheckResult)((Vector)theResults).get(0)).isAvailable()) {
                    Assert.fail((String)("Domain name " + theDomainName + " is not available with reason = " + theResult.getDomainReason()));
                }
                System.out.println("testUpfrontVerification: Step 1 - Domain name " + theDomainName + " is available");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.addLabel(theLabel);
                    theResponse = theVsp.sendCheck();
                    theResults = ((EPPNameVerificationCheckResp)theResponse).getCheckResults();
                    if (theResults.size() != 1) {
                        Assert.fail((String)("Vsp label check result of 1 label expected, but received " + theResults.size()));
                    }
                    if (!((EPPNameVerificationCheckResult)theResults.get(0)).isAvailable()) {
                        Assert.fail((String)("Label " + theLabel + " is not available (not restricted or prohibited) with reason = " + ((EPPNameVerificationCheckResult)theResults.get(0)).getReason()));
                    }
                    System.out.println("testUpfrontVerification: Step 2 - Label " + theLabel + " is available (not restricted or prohibited)");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testUpfrontVerification: Step 2 - Skipped due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                    theVsp.setAuthInfo("upfrontVerification-5");
                    theResponse = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                    theDnvc = theSuccessResult.getSignedCode();
                    System.out.println("testUpfrontVerification: Step 3 - DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testUpfrontVerification: Step 3 - Skipped due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                    theVsp.setAuthInfo("upfrontVerification-6");
                    theResponse = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                    theRnvc = theSuccessResult.getSignedCode();
                    System.out.println("testUpfrontVerification: Step 4 - RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testUpfrontVerification: Step 4 - Skipped due to no VSP pool");
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.setAuthString("testUpfrontVerification-7");
                EPPEncodedSignedCode theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theDnvc);
                theSignedCodeExt.addCode(theRnvc);
                theDomain.addExtension(theSignedCodeExt);
                EPPDomainCreateResp theResponse2 = theDomain.sendCreate();
                System.out.println("testUpfrontVerification: Step 5 - Domain name " + theDomainName + " successfully created with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ") and RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue());
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.addExtension(new EPPVerificationCodeInfo());
                theResponse = theDomain.sendInfo();
                Assert.assertTrue((boolean)theResponse.hasExtension(EPPVerificationCodeInfData.class));
                EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse.getExtension(EPPVerificationCodeInfData.class);
                Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.COMPLIANT ? 1 : 0) != 0);
                System.out.println("testUpfrontVerification: Domain name " + theDomainName + " verification is compliant");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.sendDelete();
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (theRegistrySession != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistrySession);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            try {
                if (ex.getSession() == theRegistrySession) {
                    this.invalidateSession(POOL_REGISTRY_1, theRegistrySession);
                    theRegistrySession = null;
                } else if (ex.getSession() == theVspSession) {
                    this.invalidateSession(POOL_VSP, theVspSession);
                    theVspSession = null;
                } else {
                    Assert.fail((String)"InvalidateSessionException received with no matching session");
                }
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
            }
            catch (Throwable throwable) {
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
                throw throwable;
            }
        }
        ChinaVerificationCodeTst.printEnd("testUpfrontVerification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExpedientRegistration() {
        ChinaVerificationCodeTst.printStart("testExpedientRegistration");
        EPPSession theRegistrySession = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            EPPNameVerificationCreateSuccess theSuccessResult;
            List<Object> theResults;
            EPPResponse theResponse;
            theRegistrySession = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain = new NSDomain(theRegistrySession);
            System.out.println("testExpedientRegistration: Got session to the Registry");
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testExpedientRegistration: Got session to the Vsp");
            }
            String theDomainName = this.makeDomainName("cvct-expedient-reg-", ".com");
            System.out.println("theDomainName = " + theDomainName);
            String[] theLabels = theDomainName.split("\\.");
            String theLabel = theLabels[0];
            String theTld = theLabels[1];
            EPPEncodedSignedCodeValue theDnvc = null;
            EPPEncodedSignedCodeValue theRnvc = null;
            if (!vspPoolExists) {
                theDnvc = dnvc;
                theRnvc = rnvc;
            }
            System.out.println("testExpedientRegistration: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
            try {
                EPPDomainCheckResult theResult;
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theResponse = theDomain.sendCheck();
                theResults = ((EPPDomainCheckResp)theResponse).getCheckResults();
                if (((Vector)theResults).size() != 1) {
                    Assert.fail((String)("Domain availability check result of 1 domain expected, but received " + ((Vector)theResults).size()));
                }
                if (!(theResult = (EPPDomainCheckResult)((Vector)theResults).get(0)).isAvailable()) {
                    Assert.fail((String)("Domain name " + theDomainName + " is not available with reason = " + theResult.getDomainReason()));
                }
                System.out.println("testExpedientRegistration: Step 1 - Domain name " + theDomainName + " is available");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.setAuthString("expedientRegistration-2");
                theResponse = theDomain.sendCreate();
                System.out.println("testExpedientRegistration: Step 2 - Domain name " + theDomainName + " successfully created with no codes");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.addLabel(theLabel);
                    theResponse = theVsp.sendCheck();
                    theResults = ((EPPNameVerificationCheckResp)theResponse).getCheckResults();
                    if (theResults.size() != 1) {
                        Assert.fail((String)("Vsp label check result of 1 label expected, but received " + theResults.size()));
                    }
                    if (!((EPPNameVerificationCheckResult)theResults.get(0)).isAvailable()) {
                        Assert.fail((String)("Label " + theLabel + " is not available (not restricted or prohibited) with reason = " + ((EPPNameVerificationCheckResult)theResults.get(0)).getReason()));
                    }
                    System.out.println("testExpedientRegistration: Step 3 - Label " + theLabel + " is available (not restricted or prohibited)");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testExpedientRegistration: Step 3 - Skipped due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                    theVsp.setAuthInfo("expedientRegistration-4");
                    theResponse = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                    theDnvc = theSuccessResult.getSignedCode();
                    System.out.println("testExpedientRegistration: Step 4 - DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testExpedientRegistration: Step 4 - Skipped due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                    theVsp.setAuthInfo("expedientRegistration-5");
                    theResponse = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                    theRnvc = theSuccessResult.getSignedCode();
                    System.out.println("testExpedientRegistration: Step 5 - RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testExpedientRegistration: Step 5 - Skipped due to no VSP pool");
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                EPPEncodedSignedCode theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theDnvc);
                theSignedCodeExt.addCode(theRnvc);
                theDomain.addExtension(theSignedCodeExt);
                EPPResponse theResponse2 = theDomain.sendUpdate();
                System.out.println("testExpedientRegistration: Step 6 - Domain name " + theDomainName + " successfully update with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ") and with RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.addExtension(new EPPVerificationCodeInfo());
                theResponse = theDomain.sendInfo();
                Assert.assertTrue((boolean)theResponse.hasExtension(EPPVerificationCodeInfData.class));
                EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse.getExtension(EPPVerificationCodeInfData.class);
                Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.COMPLIANT ? 1 : 0) != 0);
                System.out.println("testExpedientRegistration: Domain name " + theDomainName + " verification is compliant");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.sendDelete();
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (theRegistrySession != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistrySession);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            try {
                if (ex.getSession() == theRegistrySession) {
                    this.invalidateSession(POOL_REGISTRY_1, theRegistrySession);
                    theRegistrySession = null;
                } else if (ex.getSession() == theVspSession) {
                    this.invalidateSession(POOL_VSP, theVspSession);
                    theVspSession = null;
                } else {
                    Assert.fail((String)"InvalidateSessionException received with no matching session");
                }
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
            }
            catch (Throwable throwable) {
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
                throw throwable;
            }
        }
        ChinaVerificationCodeTst.printEnd("testExpedientRegistration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelayedRealNameVerification() {
        ChinaVerificationCodeTst.printStart("testDelayedRealNameVerification");
        EPPSession theRegistrySession = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            theRegistrySession = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain = new NSDomain(theRegistrySession);
            System.out.println("testDelayedRealNameVerification: Got session to the Registry");
            EPPDomainInfoResp theChangePollMsg = null;
            try {
                theChangePollMsg = this.findChangePoll(theRegistrySession, "cvct-delayed-real-name");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testDelayedRealNameVerification: Got session to the Vsp");
            }
            if (theChangePollMsg == null) {
                List<Object> theResults;
                EPPResponse theResponse;
                String theDomainName = this.makeDomainName("cvct-delayed-real-name-", ".com");
                System.out.println("theDomainName = " + theDomainName);
                String[] theLabels = theDomainName.split("\\.");
                String theLabel = theLabels[0];
                String theTld = theLabels[1];
                EPPEncodedSignedCodeValue theDnvc = null;
                if (!vspPoolExists) {
                    theDnvc = dnvc;
                }
                System.out.println("testDelayedRealNameVerification: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
                try {
                    EPPDomainCheckResult theResult;
                    theDomain.setTransId(this.makeClientTransId());
                    theDomain.addDomainName(theDomainName);
                    theDomain.setSubProductID(theTld);
                    theResponse = theDomain.sendCheck();
                    theResults = ((EPPDomainCheckResp)theResponse).getCheckResults();
                    if (((Vector)theResults).size() != 1) {
                        Assert.fail((String)("Domain availability check result of 1 domain expected, but received " + ((Vector)theResults).size()));
                    }
                    if (!(theResult = (EPPDomainCheckResult)((Vector)theResults).get(0)).isAvailable()) {
                        Assert.fail((String)("Domain name " + theDomainName + " is not available with reason = " + theResult.getDomainReason()));
                    }
                    System.out.println("testDelayedRealNameVerification: Step 1 - Domain name " + theDomainName + " is available");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theRegistrySession, ex);
                }
                if (vspPoolExists) {
                    try {
                        theVsp.setTransId(this.makeClientTransId());
                        theVsp.addLabel(theLabel);
                        theResponse = theVsp.sendCheck();
                        theResults = ((EPPNameVerificationCheckResp)theResponse).getCheckResults();
                        if (theResults.size() != 1) {
                            Assert.fail((String)("Vsp label check result of 1 label expected, but received " + theResults.size()));
                        }
                        if (!((EPPNameVerificationCheckResult)theResults.get(0)).isAvailable()) {
                            Assert.fail((String)("Label " + theLabel + " is not available (not restricted or prohibited) with reason = " + ((EPPNameVerificationCheckResult)theResults.get(0)).getReason()));
                        }
                        System.out.println("testDelayedRealNameVerification: Step 2 - Label " + theLabel + " is available (not restricted or prohibited)");
                    }
                    catch (Exception ex) {
                        TestUtil.handleException(theVspSession, ex);
                    }
                } else {
                    System.out.println("testDelayedRealNameVerification: Step 2 - Skipped due to no VSP pool");
                }
                if (vspPoolExists) {
                    try {
                        theVsp.setTransId(this.makeClientTransId());
                        theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                        theVsp.setAuthInfo("delayedRealNameVerification-3");
                        theResponse = theVsp.sendCreate();
                        if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                            Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                        }
                        EPPNameVerificationCreateSuccess theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                        theDnvc = theSuccessResult.getSignedCode();
                        System.out.println("testDelayedRealNameVerification: Step 3 - DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                    }
                    catch (Exception ex) {
                        TestUtil.handleException(theVspSession, ex);
                    }
                } else {
                    System.out.println("testDelayedRealNameVerification: Step 3 - Skipped due to no VSP pool");
                }
                try {
                    theDomain.setTransId(this.makeClientTransId());
                    theDomain.addDomainName(theDomainName);
                    theDomain.setSubProductID(theTld);
                    theDomain.setAuthString("delayedRealNameVerification-4");
                    EPPEncodedSignedCode theSignedCodeExt = new EPPEncodedSignedCode();
                    theSignedCodeExt.addCode(theDnvc);
                    theDomain.addExtension(theSignedCodeExt);
                    EPPDomainCreateResp theResponse2 = theDomain.sendCreate();
                    System.out.println("testDelayedRealNameVerification: Step 4 - Domain name " + theDomainName + " successfully created with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ")");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theRegistrySession, ex);
                }
                try {
                    theDomain.setTransId(this.makeClientTransId());
                    theDomain.addDomainName(theDomainName);
                    theDomain.setSubProductID(theTld);
                    theDomain.addExtension(new EPPVerificationCodeInfo());
                    theResponse = theDomain.sendInfo();
                    Assert.assertTrue((boolean)theResponse.hasExtension(EPPVerificationCodeInfData.class));
                    EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse.getExtension(EPPVerificationCodeInfData.class);
                    Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)theVerificationExt.hasProfile());
                    Assert.assertTrue((boolean)theVerificationExt.getProfile().hasMissingCodes());
                    Assert.assertTrue((boolean)theVerificationExt.getProfile().getMissingCodes().get(0).getType().equals("real-name"));
                    System.out.println("testDelayedRealNameVerification: Domain name " + theDomainName + " is pendingCompliance with RNVC due " + theVerificationExt.getProfile().getMissingCodes().get(0).getDueDate());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theRegistrySession, ex);
                }
            } else {
                EPPResponse theResponse;
                String theDomainName = theChangePollMsg.getName();
                String[] theLabels = theDomainName.split("\\.");
                String theTld = theLabels[1];
                EPPEncodedSignedCodeValue theRnvc = null;
                if (!vspPoolExists) {
                    theRnvc = rnvc;
                }
                System.out.println("testDelayedRealNameVerification: Step 5 - Got Change Poll Message for domain " + theDomainName);
                if (vspPoolExists) {
                    try {
                        theVsp.setTransId(this.makeClientTransId());
                        theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                        theVsp.setAuthInfo("delayedRealNameVerification-6");
                        theResponse = theVsp.sendCreate();
                        if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                            Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                        }
                        EPPNameVerificationCreateSuccess theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                        theRnvc = theSuccessResult.getSignedCode();
                        System.out.println("testDelayedRealNameVerification: Step 6 - RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                    }
                    catch (Exception ex) {
                        TestUtil.handleException(theVspSession, ex);
                    }
                } else {
                    System.out.println("testDelayedRealNameVerification: Step 6 - Skipped due to no VSP pool");
                }
                try {
                    theDomain.setTransId(this.makeClientTransId());
                    theDomain.addDomainName(theDomainName);
                    theDomain.setSubProductID(theTld);
                    EPPEncodedSignedCode theSignedCodeExt = new EPPEncodedSignedCode();
                    theSignedCodeExt.addCode(theRnvc);
                    theDomain.addExtension(theSignedCodeExt);
                    EPPResponse theResponse3 = theDomain.sendUpdate();
                    System.out.println("testDelayedRealNameVerification: Step 7 - Domain name " + theDomainName + " successfully update with RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue() + ")");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theRegistrySession, ex);
                }
                try {
                    theDomain.setTransId(this.makeClientTransId());
                    theDomain.addDomainName(theDomainName);
                    theDomain.setSubProductID(theTld);
                    theDomain.addExtension(new EPPVerificationCodeInfo("china"));
                    theResponse = theDomain.sendInfo();
                    Assert.assertTrue((boolean)theResponse.hasExtension(EPPVerificationCodeInfData.class));
                    EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse.getExtension(EPPVerificationCodeInfData.class);
                    Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.COMPLIANT ? 1 : 0) != 0);
                    System.out.println("testDelayedRealNameVerification: Domain name " + theDomainName + " verification is compliant");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theRegistrySession, ex);
                }
                try {
                    theDomain.setTransId(this.makeClientTransId());
                    theDomain.addDomainName(theDomainName);
                    theDomain.setSubProductID(theTld);
                    theDomain.sendDelete();
                }
                catch (Exception ex) {
                    TestUtil.handleException(theRegistrySession, ex);
                }
            }
            if (theRegistrySession != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistrySession);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            if (ex.getSession() == theRegistrySession) {
                this.invalidateSession(POOL_REGISTRY_1, theRegistrySession);
                theRegistrySession = null;
            } else if (ex.getSession() == theVspSession) {
                this.invalidateSession(POOL_VSP, theVspSession);
                theVspSession = null;
            } else {
                Assert.fail((String)"InvalidateSessionException received with no matching session");
            }
        }
        finally {
            if (theRegistrySession != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistrySession);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        ChinaVerificationCodeTst.printEnd("testDelayedRealNameVerification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDelayedDomainVerification() {
        ChinaVerificationCodeTst.printStart("testDelayedDomainVerification");
        EPPSession theRegistrySession = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            EPPResponse theResponse;
            EPPEncodedSignedCode theSignedCodeExt;
            EPPNameVerificationCreateSuccess theSuccessResult;
            List<Object> theResults;
            EPPResponse theResponse2;
            theRegistrySession = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain = new NSDomain(theRegistrySession);
            System.out.println("testDelayedDomainVerification: Got session to the Registry");
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testDelayedDomainVerification: Got session to the Vsp");
            }
            String theDomainName = this.makeDomainName("cvct-delayed-domain-ver-", ".com");
            System.out.println("theDomainName = " + theDomainName);
            String[] theLabels = theDomainName.split("\\.");
            String theLabel = theLabels[0];
            String theTld = theLabels[1];
            EPPEncodedSignedCodeValue theDnvc = null;
            EPPEncodedSignedCodeValue theRnvc = null;
            if (!vspPoolExists) {
                theDnvc = dnvc;
                theRnvc = rnvc;
            }
            System.out.println("testDelayedDomainVerification: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
            try {
                EPPDomainCheckResult theResult;
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theResponse2 = theDomain.sendCheck();
                theResults = ((EPPDomainCheckResp)theResponse2).getCheckResults();
                if (((Vector)theResults).size() != 1) {
                    Assert.fail((String)("Domain availability check result of 1 domain expected, but received " + ((Vector)theResults).size()));
                }
                if (!(theResult = (EPPDomainCheckResult)((Vector)theResults).get(0)).isAvailable()) {
                    Assert.fail((String)("Domain name " + theDomainName + " is not available with reason = " + theResult.getDomainReason()));
                }
                System.out.println("testDelayedDomainVerification: Step 1 - Domain name " + theDomainName + " is available");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                    theVsp.setAuthInfo("delayedDomainVerification-2");
                    theResponse2 = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse2).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse2).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse2).getCreateResult();
                    theRnvc = theSuccessResult.getSignedCode();
                    System.out.println("testDelayedDomainVerification: Step 2 - RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testDelayedDomainVerification: Step 2 - Skipped due to no VSP pool");
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.setAuthString("delayedDomainVerification-3");
                theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theRnvc);
                theDomain.addExtension(theSignedCodeExt);
                theResponse = theDomain.sendCreate();
                System.out.println("testDelayedDomainVerification: Step 3 - Domain name " + theDomainName + " successfully created with RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.addLabel(theLabel);
                    theResponse2 = theVsp.sendCheck();
                    theResults = ((EPPNameVerificationCheckResp)theResponse2).getCheckResults();
                    if (theResults.size() != 1) {
                        Assert.fail((String)("Vsp label check result of 1 label expected, but received " + theResults.size()));
                    }
                    if (!((EPPNameVerificationCheckResult)theResults.get(0)).isAvailable()) {
                        Assert.fail((String)("Label " + theLabel + " is not available (not restricted or prohibited) with reason = " + ((EPPNameVerificationCheckResult)theResults.get(0)).getReason()));
                    }
                    System.out.println("testDelayedDomainVerification: Step 4 - Label " + theLabel + " is available (not restricted or prohibited)");
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testDelayedDomainVerification: Step 4 - Skipped due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                    theVsp.setAuthInfo("delayedDomainVerification-5");
                    theResponse2 = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse2).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse2).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse2).getCreateResult();
                    theDnvc = theSuccessResult.getSignedCode();
                    System.out.println("testDelayedDomainVerification: Step 5 - DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testDelayedDomainVerification: Step 5 - Skipped due to no VSP pool");
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theDnvc);
                theDomain.addExtension(theSignedCodeExt);
                theResponse = theDomain.sendUpdate();
                System.out.println("testDelayedDomainVerification: Step 6 - Domain name " + theDomainName + " successfully update with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.addExtension(new EPPVerificationCodeInfo());
                theResponse2 = theDomain.sendInfo();
                Assert.assertTrue((boolean)theResponse2.hasExtension(EPPVerificationCodeInfData.class));
                EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse2.getExtension(EPPVerificationCodeInfData.class);
                Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.COMPLIANT ? 1 : 0) != 0);
                System.out.println("testDelayedDomainVerification: Domain name " + theDomainName + " verification is compliant");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            try {
                theDomain.setTransId(this.makeClientTransId());
                theDomain.addDomainName(theDomainName);
                theDomain.setSubProductID(theTld);
                theDomain.sendDelete();
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistrySession, ex);
            }
            if (theRegistrySession != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistrySession);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            try {
                if (ex.getSession() == theRegistrySession) {
                    this.invalidateSession(POOL_REGISTRY_1, theRegistrySession);
                    theRegistrySession = null;
                } else if (ex.getSession() == theVspSession) {
                    this.invalidateSession(POOL_VSP, theVspSession);
                    theVspSession = null;
                } else {
                    Assert.fail((String)"InvalidateSessionException received with no matching session");
                }
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
            }
            catch (Throwable throwable) {
                if (theRegistrySession != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistrySession);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
                throw throwable;
            }
        }
        ChinaVerificationCodeTst.printEnd("testDelayedDomainVerification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferOfCompliantDomain() {
        ChinaVerificationCodeTst.printStart("testTransferOfCompliantDomain");
        if (!sessionPool.hasSystemSessionPool(POOL_REGISTRY_2)) {
            System.out.println("testTransferOfCompliantDomain: registry2 session pool not defined for optional test, skipping test");
            ChinaVerificationCodeTst.printEnd("testTransferOfCompliantDomain");
            return;
        }
        EPPSession theRegistry1Session = null;
        EPPSession theRegistry2Session = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            EPPNameVerificationCreateSuccess theSuccessResult;
            EPPResponse theResponse;
            theRegistry1Session = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain1 = new NSDomain(theRegistry1Session);
            theRegistry2Session = this.borrowSession(POOL_REGISTRY_2);
            NSDomain theDomain2 = new NSDomain(theRegistry2Session);
            System.out.println("testTransferOfCompliantDomain: Got sessions (1 and 2) to the Registry");
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testTransferOfCompliantDomain: Got session to the Vsp");
            }
            String theDomainName = this.makeDomainName("cvct-transfer-compliant-", ".com");
            System.out.println("theDomainName = " + theDomainName);
            String[] theLabels = theDomainName.split("\\.");
            String theLabel = theLabels[0];
            String theTld = theLabels[1];
            EPPEncodedSignedCodeValue theDnvc = null;
            EPPEncodedSignedCodeValue theRnvc = null;
            if (!vspPoolExists) {
                theDnvc = dnvc;
                theRnvc = rnvc;
            }
            System.out.println("testTransferOfCompliantDomain: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                    theVsp.setAuthInfo("transferOfCompliantDomain-1");
                    theResponse = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                    theDnvc = theSuccessResult.getSignedCode();
                    System.out.println("testTransferOfCompliantDomain: DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testTransferOfCompliantDomain: Skipped Create Domain Name Verification Code (DNVC) due to no VSP pool");
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                    theVsp.setAuthInfo("transferOfCompliantDomain-2");
                    theResponse = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse).getCreateResult();
                    theRnvc = theSuccessResult.getSignedCode();
                    System.out.println("testTransferOfCompliantDomain: RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testTransferOfCompliantDomain: Skipped Create Real Name Verification Code (RNVC) due to no VSP pool");
            }
            try {
                theDomain1.setTransId(this.makeClientTransId());
                theDomain1.addDomainName(theDomainName);
                theDomain1.setSubProductID(theTld);
                theDomain1.setAuthString("transferOfCompliantDomain-3");
                EPPEncodedSignedCode theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theDnvc);
                theSignedCodeExt.addCode(theRnvc);
                theDomain1.addExtension(theSignedCodeExt);
                EPPDomainCreateResp theResponse2 = theDomain1.sendCreate();
                System.out.println("testTransferOfCompliantDomain: Domain name " + theDomainName + " successfully created with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ") and RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue());
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain2.setTransId(this.makeClientTransId());
                theDomain2.addDomainName(theDomainName);
                theDomain2.setSubProductID(theTld);
                theDomain2.addExtension(new EPPVerificationCodeInfo());
                theDomain2.setHosts("del");
                theResponse = theDomain2.sendInfo();
                Assert.assertTrue((boolean)theResponse.hasExtension(EPPVerificationCodeInfData.class));
                EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse.getExtension(EPPVerificationCodeInfData.class);
                Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.COMPLIANT ? 1 : 0) != 0);
                System.out.println("testTransferOfCompliantDomain: Step 1 - Domain name " + theDomainName + " verification is compliant");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain2.setTransId(this.makeClientTransId());
                theDomain2.addDomainName(theDomainName);
                theDomain2.setSubProductID(theTld);
                theDomain2.setAuthString("transferOfCompliantDomain-3");
                theDomain2.setTransferOpCode("request");
                theResponse = theDomain2.sendTransfer();
                System.out.println("testTransferOfCompliantDomain: Step 2 - Domain name " + theDomainName + " Transfer Request with no codes is successful");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain1.setTransId(this.makeClientTransId());
                theDomain1.addDomainName(theDomainName);
                theDomain1.setSubProductID(theTld);
                theDomain1.setTransferOpCode("approve");
                theResponse = theDomain1.sendTransfer();
                System.out.println("testTransferOfCompliantDomain: Step 3 - Domain name " + theDomainName + " Transfer Approve is successful");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain2.setTransId(this.makeClientTransId());
                theDomain2.addDomainName(theDomainName);
                theDomain2.setSubProductID(theTld);
                theDomain2.sendDelete();
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            if (theRegistry1Session != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistry1Session);
            }
            if (theRegistry2Session != null) {
                this.returnSession(POOL_REGISTRY_2, theRegistry2Session);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            try {
                if (ex.getSession() == theRegistry1Session) {
                    this.invalidateSession(POOL_REGISTRY_1, theRegistry1Session);
                    theRegistry1Session = null;
                } else if (ex.getSession() == theRegistry2Session) {
                    this.invalidateSession(POOL_REGISTRY_2, theRegistry2Session);
                    theRegistry2Session = null;
                } else if (ex.getSession() == theVspSession) {
                    this.invalidateSession(POOL_VSP, theVspSession);
                    theVspSession = null;
                } else {
                    Assert.fail((String)"InvalidateSessionException received with no matching session");
                }
                if (theRegistry1Session != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistry1Session);
                }
                if (theRegistry2Session != null) {
                    this.returnSession(POOL_REGISTRY_2, theRegistry2Session);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
            }
            catch (Throwable throwable) {
                if (theRegistry1Session != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistry1Session);
                }
                if (theRegistry2Session != null) {
                    this.returnSession(POOL_REGISTRY_2, theRegistry2Session);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
                throw throwable;
            }
        }
        ChinaVerificationCodeTst.printEnd("testTransferOfCompliantDomain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransferOfNonCompliantDomain() {
        ChinaVerificationCodeTst.printStart("testTransferOfNonCompliantDomain");
        if (!sessionPool.hasSystemSessionPool(POOL_REGISTRY_2)) {
            System.out.println("testTransferOfNonCompliantDomain: registry2 session pool not defined for optional test, skipping test");
            ChinaVerificationCodeTst.printEnd("testTransferOfNonCompliantDomain");
            return;
        }
        EPPSession theRegistry1Session = null;
        EPPSession theRegistry2Session = null;
        EPPSession theVspSession = null;
        EPPNameVerification theVsp = null;
        try {
            EPPResponse theResponse;
            EPPEncodedSignedCode theSignedCodeExt;
            EPPNameVerificationCreateSuccess theSuccessResult;
            EPPResponse theResponse2;
            theRegistry1Session = this.borrowSession(POOL_REGISTRY_1);
            NSDomain theDomain1 = new NSDomain(theRegistry1Session);
            theRegistry2Session = this.borrowSession(POOL_REGISTRY_2);
            NSDomain theDomain2 = new NSDomain(theRegistry2Session);
            System.out.println("testTransferOfNonCompliantDomain: Got sessions to the Registry (1 and 2)");
            if (vspPoolExists) {
                theVspSession = this.borrowSession(POOL_VSP);
                theVsp = new EPPNameVerification(theVspSession);
                System.out.println("testTransferOfNonCompliantDomain: Got session to the Vsp");
            }
            String theDomainName = this.makeDomainName("cvct-transfer-noncompliant-", ".com");
            System.out.println("theDomainName = " + theDomainName);
            String[] theLabels = theDomainName.split("\\.");
            String theLabel = theLabels[0];
            String theTld = theLabels[1];
            EPPEncodedSignedCodeValue theDnvc = null;
            EPPEncodedSignedCodeValue theRnvc = null;
            if (!vspPoolExists) {
                theDnvc = dnvc;
                theRnvc = rnvc;
            }
            System.out.println("testTransferOfNonCompliantDomain: Generated unique domain label (" + theLabel + ") and domain name (" + theDomainName + ") for flow");
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setDnv(new EPPDomainNameVerification(theLabel));
                    theVsp.setAuthInfo("transferOfNonCompliantDomain-1");
                    theResponse2 = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse2).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("DNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse2).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse2).getCreateResult();
                    theDnvc = theSuccessResult.getSignedCode();
                    System.out.println("testTransferOfNonCompliantDomain: DNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testTransferOfNonCompliantDomain: Skipped Create Domain Name Verification Code (DNVC) due to no VSP pool");
            }
            try {
                theDomain1.setTransId(this.makeClientTransId());
                theDomain1.addDomainName(theDomainName);
                theDomain1.setSubProductID(theTld);
                theDomain1.setAuthString("transferOfCompliantDomain-3");
                theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theDnvc);
                theDomain1.addExtension(theSignedCodeExt);
                theResponse = theDomain1.sendCreate();
                System.out.println("testTransferOfNonCompliantDomain: Domain name " + theDomainName + " successfully created with DNVC (type = " + theDnvc.getCodeType() + ", code = " + theDnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain2.setTransId(this.makeClientTransId());
                theDomain2.addDomainName(theDomainName);
                theDomain2.setSubProductID(theTld);
                theDomain2.addExtension(new EPPVerificationCodeInfo());
                theDomain2.setHosts("del");
                theResponse2 = theDomain2.sendInfo();
                Assert.assertTrue((boolean)theResponse2.hasExtension(EPPVerificationCodeInfData.class));
                EPPVerificationCodeInfData theVerificationExt = (EPPVerificationCodeInfData)theResponse2.getExtension(EPPVerificationCodeInfData.class);
                Assert.assertTrue((theVerificationExt.getStatus() == EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE ? 1 : 0) != 0);
                Assert.assertTrue((boolean)theVerificationExt.hasProfile());
                Assert.assertTrue((boolean)theVerificationExt.getProfile().hasMissingCodes());
                Assert.assertTrue((boolean)theVerificationExt.getProfile().getMissingCodes().get(0).getType().equals("real-name"));
                System.out.println("testTransferOfNonCompliantDomain: Step 1 - Domain name " + theDomainName + " verification is pendingCompliance with missing RNVC");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            if (vspPoolExists) {
                try {
                    theVsp.setTransId(this.makeClientTransId());
                    theVsp.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "\u5f20\u7b56", "110108199002161234", EPPRealNameVerification.ProofType.POC));
                    theVsp.setAuthInfo("transferOfNonCompliantDomain-2");
                    theResponse2 = theVsp.sendCreate();
                    if (!(((EPPNameVerificationCreateResp)theResponse2).getCreateResult() instanceof EPPNameVerificationCreateSuccess)) {
                        Assert.fail((String)("RNVC create was not successful with result = " + ((EPPNameVerificationCreateResp)theResponse2).getCreateResult()));
                    }
                    theSuccessResult = (EPPNameVerificationCreateSuccess)((EPPNameVerificationCreateResp)theResponse2).getCreateResult();
                    theRnvc = theSuccessResult.getSignedCode();
                    System.out.println("testTransferOfNonCompliantDomain: Step 2 - RNVC successfully created, type = " + theSuccessResult.getCodeType() + ", code  = " + theSuccessResult.getCode());
                }
                catch (Exception ex) {
                    TestUtil.handleException(theVspSession, ex);
                }
            } else {
                System.out.println("testTransferOfNonCompliantDomain: Skipped Create Real Name Verification Code (RNVC) due to no VSP pool");
            }
            try {
                theDomain2.setTransId(this.makeClientTransId());
                theDomain2.addDomainName(theDomainName);
                theDomain2.setSubProductID(theTld);
                theDomain2.setAuthString("transferOfCompliantDomain-3");
                theDomain2.setTransferOpCode("request");
                theSignedCodeExt = new EPPEncodedSignedCode();
                theSignedCodeExt.addCode(theRnvc);
                theDomain2.addExtension(theSignedCodeExt);
                theResponse = theDomain2.sendTransfer();
                System.out.println("testTransferOfNonCompliantDomain: Step 3 - Domain name " + theDomainName + " Transfer Request with RNVC (type = " + theRnvc.getCodeType() + ", code = " + theRnvc.getCodeValue() + ")");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain1.setTransId(this.makeClientTransId());
                theDomain1.addDomainName(theDomainName);
                theDomain1.setSubProductID(theTld);
                theDomain1.setTransferOpCode("approve");
                theResponse2 = theDomain1.sendTransfer();
                System.out.println("testTransferOfNonCompliantDomain: Step 3 - Domain name " + theDomainName + " Transfer Approve is successful");
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            try {
                theDomain2.setTransId(this.makeClientTransId());
                theDomain2.addDomainName(theDomainName);
                theDomain2.setSubProductID(theTld);
                theDomain2.sendDelete();
            }
            catch (Exception ex) {
                TestUtil.handleException(theRegistry1Session, ex);
            }
            if (theRegistry1Session != null) {
                this.returnSession(POOL_REGISTRY_1, theRegistry1Session);
            }
            if (theRegistry2Session != null) {
                this.returnSession(POOL_REGISTRY_2, theRegistry2Session);
            }
            if (theVspSession != null) {
                this.returnSession(POOL_VSP, theVspSession);
            }
        }
        catch (InvalidateSessionException ex) {
            try {
                if (ex.getSession() == theRegistry1Session) {
                    this.invalidateSession(POOL_REGISTRY_1, theRegistry1Session);
                    theRegistry1Session = null;
                } else if (ex.getSession() == theRegistry2Session) {
                    this.invalidateSession(POOL_REGISTRY_2, theRegistry2Session);
                    theRegistry2Session = null;
                } else if (ex.getSession() == theVspSession) {
                    this.invalidateSession(POOL_VSP, theVspSession);
                    theVspSession = null;
                } else {
                    Assert.fail((String)"InvalidateSessionException received with no matching session");
                }
                if (theRegistry1Session != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistry1Session);
                }
                if (theRegistry2Session != null) {
                    this.returnSession(POOL_REGISTRY_2, theRegistry2Session);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
            }
            catch (Throwable throwable) {
                if (theRegistry1Session != null) {
                    this.returnSession(POOL_REGISTRY_1, theRegistry1Session);
                }
                if (theRegistry2Session != null) {
                    this.returnSession(POOL_REGISTRY_2, theRegistry2Session);
                }
                if (theVspSession != null) {
                    this.returnSession(POOL_VSP, theVspSession);
                }
                throw throwable;
            }
        }
        ChinaVerificationCodeTst.printEnd("testTransferOfNonCompliantDomain");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new ChinaVerificationCodeTstSetup((Test)new TestSuite(ChinaVerificationCodeTst.class));
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("ChinaVerificationCodeTst Thread " + i, ChinaVerificationCodeTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)ChinaVerificationCodeTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private EPPDomainInfoResp findChangePoll(EPPSession aSession, String aDomainPrefix) throws EPPException {
        EPPDomainInfoResp theChangePollMsg = null;
        EPPResponse theResponse = null;
        aSession.setTransId(this.makeClientTransId());
        aSession.setPollOp("req");
        theResponse = aSession.sendPoll();
        while (theResponse.getResult().getCode() == 1301 && theChangePollMsg == null) {
            System.out.println("findChangePoll: Poll Response = [" + theResponse + "]\n\n");
            if (theResponse instanceof EPPDomainTransferResp) {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", domain transfer poll message");
            } else if (theResponse instanceof EPPContactTransferResp) {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", contact transfer poll message");
            } else if (theResponse instanceof EPPLowBalancePollResponse) {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", low balance poll message");
            } else if (theResponse instanceof EPPRgpPollResponse) {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", RGP poll message");
            } else if (theResponse instanceof EPPDomainPendActionMsg) {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", domain pending action poll message");
            } else if (theResponse instanceof EPPDomainInfoResp && theResponse.hasExtension(EPPChangeData.class)) {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", change poll message");
                theChangePollMsg = (EPPDomainInfoResp)theResponse;
                EPPChangeData theChange = (EPPChangeData)theResponse.getExtension(EPPChangeData.class);
                if (theChange.getReason().equals("Locale Data Policy")) {
                    System.out.println("findChangePoll: Received Locale Data Policy Change Poll Message");
                }
                if (aDomainPrefix == null || theChangePollMsg.getName().startsWith(aDomainPrefix)) {
                    System.out.println("findChangePoll: Found matching change poll message");
                } else {
                    theChangePollMsg = null;
                }
            } else {
                System.out.println("findChangePoll: ID = " + theResponse.getMsgQueue().getId() + ", unknown poll message of type = " + theResponse.getClass().getName());
            }
            aSession.setTransId(this.makeClientTransId());
            aSession.setPollOp("ack");
            aSession.setMsgID(theResponse.getMsgQueue().getId());
            theResponse = aSession.sendPoll();
            aSession.setTransId(this.makeClientTransId());
            aSession.setPollOp("req");
            theResponse = aSession.sendPoll();
        }
        return theChangePollMsg;
    }

    public static void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " Start");
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    public static void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ": ");
            cat.info(Thread.currentThread().getName() + ": " + aTest + " End");
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private EPPSession borrowSession(String aPool) {
        EPPSession theSession = null;
        try {
            theSession = sessionPool.borrowObject(aPool);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("borrowSession(): Exception borrowing session from " + aPool + ": " + ex));
        }
        return theSession;
    }

    private void returnSession(String aPool, EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.returnObject(aPool, aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("returnSession(): Exception returning session to " + aPool + ": " + ex));
        }
    }

    private void invalidateSession(String aPool, EPPSession aSession) {
        try {
            if (aSession != null) {
                sessionPool.invalidateObject(aPool, aSession);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("invalidateSession(): Exception invalidating session in " + aPool + ": " + ex));
        }
    }

    private void handleResponse(EPPResponse aResponse) {
        for (int i = 0; i < aResponse.getResults().size(); ++i) {
            EPPResult theResult = (EPPResult)aResponse.getResults().elementAt(i);
            System.out.println("Result Code    : " + theResult.getCode());
            System.out.println("Result Message : " + theResult.getMessage());
            System.out.println("Result Lang    : " + theResult.getLang());
            if (theResult.isSuccess()) {
                System.out.println("Command Passed ");
            } else {
                System.out.println("Command Failed ");
            }
            if (theResult.getAllValues() == null) continue;
            for (int k = 0; k < theResult.getAllValues().size(); ++k) {
                System.out.println("Result Values  : " + theResult.getAllValues().elementAt(k));
            }
        }
    }

    public String makeDomainName(String aPrefix, String aTld) {
        long tm = System.currentTimeMillis();
        return new String(aPrefix + tm + this.rd.nextInt(12) + aTld);
    }

    public String makeClientTransId() {
        long tm = System.currentTimeMillis();
        return new String("china-ver-tst-" + Thread.currentThread() + String.valueOf(tm + (long)this.rd.nextInt(12)).substring(10));
    }

    private static class ChinaVerificationCodeTstSetup
    extends TestSetup {
        public ChinaVerificationCodeTstSetup(Test aTest) {
            super(aTest);
        }

        protected void setUp() throws Exception {
            super.setUp();
            String theConfigFileName = System.getProperty("EPP.ConfigFile");
            if (theConfigFileName != null) {
                configFileName = theConfigFileName;
            }
            try {
                app.initialize(configFileName);
            }
            catch (EPPCommandException e) {
                e.printStackTrace();
                Assert.fail((String)("Error initializing the EPP Application: " + e));
            }
            try {
                sessionPool = EPPSessionPool.getInstance();
                sessionPool.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail((String)("Error initializing the session pool: " + ex));
            }
            if (!sessionPool.hasSystemSessionPool(ChinaVerificationCodeTst.POOL_VSP)) {
                System.out.println("ChinaVerificationCodeTstSetup: No VSP pool defined, load DNVC and RNVC from files");
                vspPoolExists = false;
                File theDnvcFile = new File("dnvc.b64");
                if (!theDnvcFile.exists() || !theDnvcFile.canRead()) {
                    Assert.fail((String)"dnvc.64 does not exist or is not readable");
                }
                String theDnvc = new String(Files.readAllBytes(Paths.get("dnvc.b64", new String[0])));
                dnvc = new EPPEncodedSignedCodeValue();
                dnvc.decodeValue(theDnvc);
                System.out.println("ChinaVerificationCodeTstSetup: Successfully loaded DNVC from dnvc.b64");
                File theRnvcFile = new File("rnvc.b64");
                if (!theRnvcFile.exists() || !theRnvcFile.canRead()) {
                    Assert.fail((String)"rnvc.64 does not exist or is not readable");
                }
                String theRnvc = new String(Files.readAllBytes(Paths.get("rnvc.b64", new String[0])));
                rnvc = new EPPEncodedSignedCodeValue();
                rnvc.decodeValue(theRnvc);
                System.out.println("ChinaVerificationCodeTstSetup: Successfully loaded RNVC from rnvc.b64");
            }
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            EPPSessionPool.getInstance().close();
        }
    }
}

