/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.server;

import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPServerCon;
import com.verisign.epp.transport.EPPServerThread;
import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import java.io.IOException;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPPlainServer
implements EPPServerCon {
    private static Logger cat = LoggerFactory.getLogger(EPPPlainServer.class);
    private ServerSocket myServerSocket = null;
    private boolean listening = true;
    private ServerEventHandler myHandler = null;
    private int myPortNumber = 0;
    private int myConTimeout = 0;

    public EPPPlainServer() throws EPPConException {
        cat.debug("EPPPlainServer.EPPPlainServer(): entering Constructor");
        try {
            this.myPortNumber = EPPEnv.getServerPort();
            this.myConTimeout = EPPEnv.getConTimeOut();
        }
        catch (EPPEnvException myException) {
            cat.error("Connection Failed Due to : " + myException.getMessage());
            throw new EPPConException("Connection Failed Due to : " + myException.getMessage());
        }
        cat.debug("EPPPlainServer.EPPPlainServer(): ServerPort = " + this.myPortNumber);
        cat.debug("EPPPlainServer.EPPPlainServer(): Exiting Constructor");
    }

    @Override
    public void RunServer(ServerEventHandler newHandler) throws EPPConException {
        cat.debug("EPPPlainServer.RunServer(): Entering Method");
        this.myHandler = newHandler;
        try {
            this.myServerSocket = new ServerSocket(this.myPortNumber);
        }
        catch (IOException myException) {
            cat.error("IO Exception : " + myException.getMessage());
            throw new EPPConException("IO Exception : " + myException.getMessage());
        }
        this.loop();
        this.close();
        cat.debug("EPPPlainServer.RunServer(): Exiting Method");
    }

    public void loop() throws EPPConException {
        cat.debug("EPPPlainServer.loop(): Entering Method");
        try {
            while (this.listening) {
                EPPServerThread p = new EPPServerThread(this.myServerSocket.accept(), this.myHandler);
                p.start();
            }
        }
        catch (IOException myException) {
            cat.error("I/O Error occured when wating for connection");
            throw new EPPConException("I/O Error occured when wating for connection");
        }
        catch (SecurityException myException) {
            cat.error("security Manger exists and its checkListen method doesn't allow accpet operation");
            throw new EPPConException("security Manger exists and its checkListen method doesn't allow accpet operation");
        }
        cat.debug("EPPPlainServer.loop(): Exiting Method");
    }

    public void close() throws EPPConException {
        cat.debug("EPPPlainServer.close(): Entering Method");
        try {
            this.myServerSocket.close();
        }
        catch (Exception myException) {
            cat.error("Close on Server socket Failed");
            throw new EPPConException("Close on Server socket Failed");
        }
        cat.debug("EPPPlainServer.close(): Exiting Method");
    }
}

