/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.exception.EPPException;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPSSLConfig;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.util.EPPEnv;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPSSLImpl {
    private static Logger logger = LoggerFactory.getLogger(EPPSSLImpl.class);
    private static EPPSSLContext context = null;
    private static boolean initialized = false;

    public static SSLContext getSSLContext() {
        if (initialized) {
            return context.getSSLContext();
        }
        return null;
    }

    public static boolean hasSSLEnabledProtocols() {
        return context != null ? context.hasSSLEnabledProtocols() : false;
    }

    public static String[] getSSLEnabledProtocols() {
        return context.getSSLEnabledProtocols();
    }

    public static boolean hasSSLEnabledCipherSuites() {
        return context != null ? context.hasSSLEnabledCipherSuites() : false;
    }

    public static String[] getSSLEnabledCipherSuites() {
        return context.getSSLEnabledCipherSuites();
    }

    public static EPPSSLContext getEPPSSLContext() {
        return context;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        if (initialized) {
            return context.getSSLSocketFactory();
        }
        return null;
    }

    public static EPPSSLContext initialize(EPPSSLConfig aConfig) throws EPPConException {
        logger.debug("initialize(EPPSSLConfig): enter");
        if (aConfig != null) {
            try {
                aConfig.validate();
            }
            catch (EPPException e) {
                logger.error("initialize(EPPSSLConfig): Config is invalid: " + e.getMessage());
                throw new EPPConException(e.getMessage());
            }
        } else {
            logger.error("initialize(EPPSSLConfig): Config is null");
            throw new EPPConException("EPPSSLImpl.initialize(EPPSSLConfig): Config is null");
        }
        logger.info("initialize(EPPSSLConfig): Config = " + aConfig);
        EPPSSLContext theContext = new EPPSSLContext();
        KeyManagerFactory theKeyStoreFactory = null;
        KeyStore theKeyStore = null;
        String theProtocol = aConfig.getSslProtocol();
        String theKeyStoreType = aConfig.getIdentityStoreType();
        String theKeyStoreFileName = aConfig.getIdentityFileName();
        char[] thePassphrase = aConfig.getIdentityPassPhraseCharArray();
        char[] theKeyPassphrase = aConfig.getIdentityKeyPassPhraseCharArray();
        if (aConfig.getSslDebug() != null) {
            System.setProperty("javax.net.debug", aConfig.getSslDebug());
        }
        try {
            theContext.setSSLContext(SSLContext.getInstance(theProtocol));
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("initialize(EPPSSLConfig): Given Protocol is not Available : (" + theProtocol + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): Given Protocol is not Available : (" + theProtocol + ") " + ex.getMessage());
        }
        try {
            theKeyStoreFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("initialize(EPPSSLConfig): The default algorithm is not available in this package : (" + KeyManagerFactory.getDefaultAlgorithm() + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The Given algorithm is not available in this package : (" + KeyManagerFactory.getDefaultAlgorithm() + ") " + ex.getMessage());
        }
        try {
            theKeyStore = KeyStore.getInstance(theKeyStoreType);
        }
        catch (KeyStoreException ex) {
            logger.error("initialize(EPPSSLConfig): The Given keystore type is not Available(" + theKeyStoreType + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The Given keystore type is not Available(" + theKeyStoreType + ") " + ex.getMessage());
        }
        try {
            theKeyStore.load(new FileInputStream(theKeyStoreFileName), thePassphrase);
        }
        catch (CertificateException ex) {
            logger.error("initialize(EPPSSLConfig): The given certificates in the keystore could not be loaded (" + theKeyStoreFileName + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The given certificates in the keystore could not be loaded (" + theKeyStoreFileName + ") " + ex.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("initialize(EPPSSLConfig): The given algorithm used to check the integrity is not Available (" + theKeyStoreFileName + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The given algorithm used to check the integrity is not Available (" + theKeyStoreFileName + ") " + ex.getMessage());
        }
        catch (FileNotFoundException ex) {
            logger.error("initialize(EPPSSLConfig): The given keystore file is not found (" + theKeyStoreFileName + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The given keystore file is not found (" + theKeyStoreFileName + ") " + ex.getMessage());
        }
        catch (IOException ex) {
            logger.error("initialize(EPPSSLConfig): I/O or format probkem with keystore date (" + theKeyStoreFileName + ") " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): I/O or format probkem with keystore date (" + theKeyStoreFileName + ") " + ex.getMessage());
        }
        try {
            theKeyStoreFactory.init(theKeyStore, theKeyPassphrase);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("initialize(EPPSSLConfig): The Given algorithm is not valid, " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The Given algorithm is not valid, " + ex.getMessage());
        }
        catch (UnrecoverableKeyException ex) {
            logger.error("initialize(EPPSSLConfig): The Given key can not be recovered, " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The Given key can not be recovered, " + ex.getMessage());
        }
        catch (KeyStoreException ex) {
            logger.error("initialize(EPPSSLConfig): The Given keystore is not valid, " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The Given keystore is not valid, " + ex.getMessage());
        }
        TrustManager[] theTrustManagers = null;
        String theTrustStoreFileName = aConfig.getTrustStoreFileName();
        char[] theTrustStorePassphrase = aConfig.getTrustStorePassPhraseCharArray();
        String theTrustStoreType = aConfig.getTrustStoreType();
        if (theTrustStoreType == null) {
            theTrustStoreType = theKeyStoreType;
        }
        if (theTrustStorePassphrase == null) {
            logger.info("initialize(EPPSSLConfig): Trust Store Pass Phrase property not defined, will use Identity Pass Phrase");
            theTrustStorePassphrase = thePassphrase;
        }
        if (theTrustStoreFileName != null) {
            try {
                TrustManagerFactory theTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore theTrustStore = KeyStore.getInstance(theTrustStoreType);
                theTrustStore.load(new FileInputStream(theTrustStoreFileName), theTrustStorePassphrase);
                theTrustManagerFactory.init(theTrustStore);
                theTrustManagers = theTrustManagerFactory.getTrustManagers();
            }
            catch (Exception ex) {
                logger.error("Error initializing trust manager: " + ex);
                throw new EPPConException("Error initializing trust manager: " + ex);
            }
        } else {
            logger.info("initialize(EPPSSLConfig): Trust Store File Name property not defined, will use default trust store");
        }
        try {
            theContext.getSSLContext().init(theKeyStoreFactory.getKeyManagers(), theTrustManagers, null);
        }
        catch (KeyManagementException ex) {
            logger.error("initialize(EPPSSLConfig): The Given key Manager is not valid, " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("initialize(EPPSSLConfig): The Given key Manager is not valid, " + ex.getMessage());
        }
        if (logger.isDebugEnabled()) {
            String[] supportedCiphers = theContext.getSSLContext().getSocketFactory().getSupportedCipherSuites();
            String supportedCiphersString = "";
            for (String cipher : supportedCiphers) {
                supportedCiphersString = supportedCiphersString.length() == 0 ? cipher : supportedCiphersString + " " + cipher;
            }
            logger.debug("Supported ciphers = [" + supportedCiphersString + "]");
            String[] defaultCiphers = theContext.getSSLContext().getSocketFactory().getSupportedCipherSuites();
            String defaultCiphersString = "";
            for (String cipher : defaultCiphers) {
                defaultCiphersString = defaultCiphersString.length() == 0 ? cipher : defaultCiphersString + " " + cipher;
            }
            logger.debug("Default ciphers =   [" + defaultCiphersString + "]");
        }
        theContext.setSSLSocketFactory(theContext.getSSLContext().getSocketFactory());
        theContext.setSSLEnabledProtocols(aConfig.getSSLEnabledProtocols());
        theContext.setSSLEnabledCipherSuites(aConfig.getSSLEnabledCipherSuites());
        logger.debug("initialize(EPPSSLConfig): exit");
        return theContext;
    }

    public static synchronized void initialize() throws EPPConException {
        logger.debug("initialize(): enter");
        if (initialized) {
            logger.debug("EPPSSLImpl has already been initialized");
            return;
        }
        logger.info("EPPSSLImpl starting initialization");
        EPPSSLConfig theConfig = new EPPSSLConfig(EPPEnv.getSSLProtocol(), EPPEnv.getKeyStore(), EPPEnv.getSSLKeyFileName(), EPPEnv.getSSLPassPhrase());
        theConfig.setIdentityKeyPassPhrase(EPPEnv.getSSLKeyPassPhrase());
        theConfig.setSslDebug(EPPEnv.getSSLDebug());
        theConfig.setTrustStore(EPPEnv.getKeyStore(), EPPEnv.getSSLTrustStoreFileName(), EPPEnv.getSSLTrustStorePassPhrase());
        theConfig.setSSLEnabledProtocols(EPPEnv.getSSLEnabledProtocols());
        theConfig.setSSLEnabledCipherSuites(EPPEnv.getSSLEnabledCipherSuites());
        context = EPPSSLImpl.initialize(theConfig);
        logger.info("EPPSSLImpl successfully initialized");
        initialized = true;
        logger.debug("initialize(): exit");
    }
}

