/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.client;

import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPPlainClientSocket
implements EPPClientCon {
    private static Logger cat = LoggerFactory.getLogger(EPPPlainClientSocket.class);
    private Socket socket = null;
    private OutputStream outputStream = null;
    private InputStream inputStream = null;
    private String hostName = null;
    private int portNumber = 0;
    private String clientHostName = null;
    private boolean isConnected = true;
    private int conTimeOut = 5000;
    private int readTimeOut = 5000;

    public EPPPlainClientSocket() throws EPPConException {
        try {
            this.hostName = EPPEnv.getServerName();
            this.portNumber = EPPEnv.getServerPort();
            this.conTimeOut = EPPEnv.getConTimeOut();
            this.readTimeOut = EPPEnv.getReadTimeOut();
            this.clientHostName = EPPEnv.getClientHost();
        }
        catch (EPPEnvException myException) {
            cat.error("Connection Failed Due to : " + myException.getMessage(), (Throwable)myException);
            throw new EPPConException("Connection Failed Due to : " + myException.getMessage());
        }
    }

    @Override
    public void initialize() throws EPPConException {
        try {
            if (this.clientHostName == null) {
                cat.debug("EPPPlainClientSocket.initialize(): Connecting to server host = " + this.hostName + ", server port = " + this.portNumber + ", conTimeOut = " + this.conTimeOut);
                this.socket = new Socket(this.hostName, this.portNumber);
            } else {
                cat.debug("EPPPlainClientSocket.initialize(): Connecting to server host = " + this.hostName + ", server port = " + this.portNumber + ", conTimeOut = " + this.conTimeOut + " from client host = " + this.clientHostName);
                this.socket = new Socket();
                InetSocketAddress theClientAddress = new InetSocketAddress(this.clientHostName, 0);
                InetSocketAddress theServerAddress = new InetSocketAddress(this.hostName, this.portNumber);
                this.socket.bind(theClientAddress);
                this.socket.connect(theServerAddress, this.conTimeOut);
            }
            cat.debug("EPPPlainClientSocket.initialize(): Using readTimeOut = " + this.readTimeOut);
            this.socket.setSoTimeout(this.readTimeOut);
        }
        catch (UnknownHostException myException) {
            cat.error("IP address of the host could not be determined. ", (Throwable)myException);
            throw new EPPConException("IP address of the host could not be determined. " + myException.getMessage());
        }
        catch (IOException ex) {
            cat.error("an I/O error occurs when creating the socket. ", (Throwable)ex);
            throw new EPPConException("an I/O error occurs when creating the socket. " + ex.getMessage());
        }
        catch (SecurityException myException) {
            cat.error("a security manager exists and its checkConnect method doesn't allow the operation. ", (Throwable)myException);
            throw new EPPConException("a security manager exists and its checkConnect method doesn't allow the operation. " + myException.getMessage());
        }
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException ex) {
            cat.error("An I/O Error Occured when creating Input Output Stream", (Throwable)ex);
            throw new EPPConException("An I/O Error Occured when creating Input Output Stream" + ex.getMessage());
        }
    }

    @Override
    public void initialize(String aHostName, int aPortNumber, EPPSSLContext aSSLContext) throws EPPConException {
        this.hostName = aHostName;
        this.portNumber = aPortNumber;
        this.initialize();
    }

    @Override
    public void initialize(String aHostName, int aPortNumber, String aClientHostName, EPPSSLContext aSSLContext) throws EPPConException {
        this.hostName = aHostName;
        this.portNumber = aPortNumber;
        this.clientHostName = aClientHostName;
        this.initialize();
    }

    @Override
    public InputStream getInputStream() throws EPPConException {
        if (this.inputStream == null) {
            cat.error("getInputStream(): No InputStream set");
            throw new EPPConException("No InputStream set");
        }
        return this.inputStream;
    }

    protected void setInputStream(InputStream aInputStream) {
        this.inputStream = aInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws EPPConException {
        if (this.outputStream == null) {
            cat.error("getInputStream(): No OutputStream set");
            throw new EPPConException("No OutputStream set");
        }
        return this.outputStream;
    }

    protected void setOutputStream(OutputStream aOutputStream) {
        this.outputStream = aOutputStream;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    protected void setSocket(Socket aSocket) {
        this.socket = aSocket;
    }

    protected String getClientHostName() {
        return this.clientHostName;
    }

    protected void setClientHostName(String aClientHostName) {
        this.clientHostName = aClientHostName;
    }

    protected String getHostName() {
        return this.hostName;
    }

    protected void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    protected int getPortNumber() {
        return this.portNumber;
    }

    protected void setPortNumber(int aPortNumber) {
        this.portNumber = aPortNumber;
    }

    protected int getConTimeout() {
        return this.conTimeOut;
    }

    protected void setConTimeout(int aConTimeout) {
        this.conTimeOut = aConTimeout;
    }

    protected boolean isConnected() {
        return this.isConnected;
    }

    protected void setConnected(boolean aIsConnected) {
        this.isConnected = aIsConnected;
    }

    @Override
    public void close() throws EPPConException {
        cat.debug("EPPPlainClientSocket.close(): Starting the Method");
        if (!this.isConnected) {
            return;
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException ex) {
            cat.error("close(): Failure in closing streams", (Throwable)ex);
            throw new EPPConException("Failure closing streams : " + ex.getMessage());
        }
        catch (SecurityException ex) {
            cat.error("close() : Failure in closing streams", (Throwable)ex);
        }
        finally {
            this.isConnected = false;
        }
        cat.debug("EPPPlainClientSocket.close(): Ending the Method");
    }
}

