/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport;

import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPConFactory {
    private static Logger cat = LoggerFactory.getLogger(EPPConFactory.class);

    public EPPClientCon getEPPConnection(String mySocket) throws EPPConException {
        EPPClientCon me = null;
        cat.debug("EPPConFactory.getEPPConnection(String): Starting the Method");
        try {
            me = (EPPClientCon)Class.forName(mySocket).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception myException) {
            cat.error("EPPConFactory.getEPPConnection(String): " + myException.getMessage(), (Throwable)myException);
            throw new EPPConException("Exception : Class Name " + mySocket + " " + myException.getMessage());
        }
        cat.debug("EPPConFactory.getEPPConnection(): Ending the Method");
        return me;
    }

    public EPPClientCon getEPPConnection() throws EPPConException {
        EPPClientCon me = null;
        String myClassName = null;
        cat.debug("EPPConFactory.getEPPConnection(): Starting the Method");
        try {
            myClassName = EPPEnv.getClientSocketName();
        }
        catch (EPPEnvException myException) {
            cat.error("EnvException : " + myException.getMessage(), (Throwable)myException);
            throw new EPPConException("EnvException : " + myException.getMessage());
        }
        try {
            me = (EPPClientCon)Class.forName(myClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception myException) {
            cat.error("Exception : " + myException.getMessage(), (Throwable)myException);
            throw new EPPConException("Class Not Found Exception : Class Name " + myClassName + " " + myException.getMessage());
        }
        cat.debug("EPPConFactory.getEPPConnection(): Ending the Method");
        return me;
    }
}

