/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtCreate;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtInfData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtUpdate;
import com.verisign.epp.serverstub.SecDNSSubDomainHandler;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecDNSV11SubDomainHandler
implements SecDNSSubDomainHandler {
    private static Logger cat = LoggerFactory.getLogger(SecDNSV11SubDomainHandler.class);

    @Override
    public EPPResponse doDomainCreate(EPPDomainCreateCmd aCreateCommand, Object aData) {
        EPPSecDNSExtCreate secDNScreate = (EPPSecDNSExtCreate)aCreateCommand.getExtension(EPPSecDNSExtCreate.class);
        if (secDNScreate.hasMaxSigLife()) {
            if (aCreateCommand.getName().equalsIgnoreCase("maxsiglife-not-supported.com")) {
                cat.error("SecDNSDomainHandler.doDomainCreate: secDNS:create maxSigLife specified for unsupporting server");
                EPPResult theResult = new EPPResult(2102);
                theResult.addExtValueReason("maxSigLife not supported");
                return new EPPResponse(null, theResult);
            }
            cat.info("SecDNSV11SubDomainHandler.doDomainCreate: secDNS:create maxSigLife = \n" + secDNScreate.getMaxSigLife());
        }
        if (secDNScreate.hasDsData()) {
            if (aCreateCommand.getName().equalsIgnoreCase("key-data-interface.com")) {
                cat.error("SecDNSDomainHandler.doDomainCreate: secDNS:create for server only supporting Key Data Interface");
                EPPResult theResult = new EPPResult(2306);
                theResult.addExtValueReason("Only Key Data Interface supported");
                return new EPPResponse(null, theResult);
            }
            cat.info("SecDNSV11SubDomainHandler.doDomainCreate: secDNS:create dsData = \n" + secDNScreate.getDsData());
        } else if (secDNScreate.hasKeyData()) {
            if (aCreateCommand.getName().equalsIgnoreCase("ds-data-interface.com")) {
                cat.error("SecDNSDomainHandler.doDomainCreate: secDNS:create for server only supporting DS Data Interface");
                EPPResult theResult = new EPPResult(2306);
                theResult.addExtValueReason("Only DS Data Interface supported");
                return new EPPResponse(null, theResult);
            }
            cat.info("SecDNSV11SubDomainHandler.doDomainCreate: secDNS:create dsData = \n" + secDNScreate.getKeyData());
        }
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(null, aCreateCommand.getName(), new Date());
        return theResponse;
    }

    @Override
    public EPPResponse doDomainUpdate(EPPDomainUpdateCmd aUpdateCommand, Object aData) {
        EPPSecDNSExtUpdate secDNSupdate = (EPPSecDNSExtUpdate)aUpdateCommand.getExtension(EPPSecDNSExtUpdate.class);
        boolean dsDataInterface = false;
        boolean keyDataInterface = false;
        boolean dsDataFound = false;
        boolean keyDataFound = false;
        if (aUpdateCommand.getName().equalsIgnoreCase("key-data-interface.com")) {
            keyDataInterface = true;
        } else if (aUpdateCommand.getName().equalsIgnoreCase("ds-data-interface.com")) {
            dsDataInterface = true;
        }
        if (secDNSupdate != null) {
            if (secDNSupdate.isUrgent()) {
                if (aUpdateCommand.getName().equalsIgnoreCase("urgent-not-supported.com")) {
                    EPPResult theResult = new EPPResult(2102);
                    theResult.addExtValueReason("attribute \"urgent\" NOT supported");
                    return new EPPResponse(null, theResult);
                }
                if (aUpdateCommand.getName().equalsIgnoreCase("urgent-supported-cannot-be-urgent.com")) {
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("attribute \"urgent\" supported, but cannot be completed with high priority");
                    return new EPPResponse(null, theResult);
                }
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update urgent true");
            }
            if (secDNSupdate.isRemAllData()) {
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:rem ALL");
            } else if (secDNSupdate.hasRemDsData()) {
                if (keyDataInterface) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:rem dsData for server only supporting Key Data Interface");
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("Only Key Data Interface supported");
                    return new EPPResponse(null, theResult);
                }
                dsDataFound = true;
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:rem dsData = " + secDNSupdate.getRemDsData());
            } else if (secDNSupdate.hasRemKeyData()) {
                if (dsDataInterface) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:rem keyData for server only supporting DS Data Interface");
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("Only DS Data Interface supported");
                    return new EPPResponse(null, theResult);
                }
                keyDataFound = true;
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:rem keyData = " + secDNSupdate.getRemKeyData());
            }
            if (secDNSupdate.hasAddDsData()) {
                if (keyDataFound) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:add dsData when keyData was used on secDNS:rem");
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("DS Data Interface and Key Data Interface cannot be mixed");
                    return new EPPResponse(null, theResult);
                }
                if (keyDataInterface) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:add dsData for server only supporting Key Data Interface");
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("Only Key Data Interface supported");
                    return new EPPResponse(null, theResult);
                }
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:add dsData = " + secDNSupdate.getAddDsData());
            }
            if (secDNSupdate.hasAddKeyData()) {
                if (dsDataFound) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:add keyData when dsData was used on secDNS:rem");
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("DS Data Interface and Key Data Interface cannot be mixed");
                    return new EPPResponse(null, theResult);
                }
                if (dsDataInterface) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:add keyData for server only supporting DS Data Interface");
                    EPPResult theResult = new EPPResult(2306);
                    theResult.addExtValueReason("Only DS Data Interface supported");
                    return new EPPResponse(null, theResult);
                }
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:add keyData = " + secDNSupdate.getAddKeyData());
            }
            if (secDNSupdate.hasChg()) {
                if (aUpdateCommand.getName().equalsIgnoreCase("maxsiglife-not-supported.com")) {
                    cat.error("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:chg maxSigLife specified for unsupporting server");
                    EPPResult theResult = new EPPResult(2102);
                    theResult.addExtValueReason("maxSigLife not supported");
                    return new EPPResponse(null, theResult);
                }
                cat.info("SecDNSDomainHandler.doDomainUpdate: secDNS:update/secDNS:chg maxSigLife = " + secDNSupdate.getMaxSigLife());
            }
        } else {
            cat.info("SecDNSDomainHandler.doDomainUpdate: no EPPSecDNSExtUpdate extension\n");
        }
        return new EPPResponse();
    }

    @Override
    public EPPDomainInfoResp doDomainInfo(EPPDomainInfoCmd aInfoCommand, EPPDomainInfoResp aInfoResponse, Object aData) {
        EPPSecDNSExtInfData infData = new EPPSecDNSExtInfData();
        EPPSecDNSExtKeyData keyData = new EPPSecDNSExtKeyData();
        keyData.setFlags(257);
        keyData.setProtocol(3);
        keyData.setAlg(5);
        keyData.setPubKey("AQPmsXk3Q1ngNSzsH1lrX63mRIhtwkkK+5ZjvxykBCV1NYne83+8RXkBElGb/YJ1n4TacMUspoZap7caJj7MdOaADKmzB2ci0vwpubNyW0t2AnaQqpy1ce+07Y8RkbTC6xCeEw1UQZ73PzIOOvJDdjwPxWaO9F7zSxnGpGt0WtuItQ==");
        EPPSecDNSExtKeyData keyData2 = new EPPSecDNSExtKeyData(257, 3, 5, "AQOxXpFbRp7+zPBoTt6zL7Af0aEKzpS4JbVB5ofk5E5HpXuUmU+Hnt9hm2kMph6LZdEEL142nq0HrgiETFCsN/YM4Zn+meRkELLpCG93Cu/HhwvxfaZenUAAA6Vb9FwXQ1EMYRW05K/gh2Gew5Sk/0o6Ev7DKG2YiDJYA17QsaZtFw==");
        if (aInfoCommand.getName().equalsIgnoreCase("key-data-interface.com")) {
            infData.appendKeyData(keyData);
            infData.appendKeyData(keyData2);
        } else {
            EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData();
            dsData.setKeyTag(34095);
            dsData.setAlg(5);
            dsData.setDigestType(1);
            dsData.setDigest("6BD4FFFF11566D6E6A5BA44ED0018797564AA289");
            EPPSecDNSExtDsData dsData2 = new EPPSecDNSExtDsData(10563, 5, 1, "9C20674BFF957211D129B0DFE9410AF753559D4B");
            if (aInfoCommand.getName().equalsIgnoreCase("ds-data-interface-with-key.com")) {
                dsData.setKeyData(keyData);
                dsData2.setKeyData(keyData2);
            }
            infData.appendDsData(dsData);
            infData.appendDsData(dsData2);
            if (aInfoCommand.getName().equalsIgnoreCase("ds-data-interface-with-maxsiglife.com")) {
                infData.setMaxSigLife(604800);
            }
        }
        aInfoResponse.addExtension(infData);
        return aInfoResponse;
    }
}

