/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.pool.transformer;

import com.verisign.epp.util.EPPEnv;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.pool2.BaseObjectPool;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.SoftReferenceObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPTransformerPool {
    private static Logger cat = LoggerFactory.getLogger(EPPTransformerPool.class);
    private static EPPTransformerPool instance = new EPPTransformerPool();
    private SoftReferenceObjectPool<Transformer> pool = null;

    public static EPPTransformerPool getInstance() {
        return instance;
    }

    private EPPTransformerPool() {
        cat.info("EPPTransformerPool: initializing pool with " + EPPEnv.getTransformerPoolSize() + " transformers");
        this.pool = new SoftReferenceObjectPool((PooledObjectFactory)new EPPTransformerPoolFactory());
        try {
            this.pool.addObjects(EPPEnv.getTransformerPoolSize());
        }
        catch (Exception ex) {
            cat.error("EPPTransformerPool: Exception initializing the EPPTransformerPool: " + ex);
        }
        cat.info("EPPTransformerPool: pool initialized");
    }

    public BaseObjectPool<Transformer> getPool() {
        return this.pool;
    }

    private static class EPPTransformerPoolFactory
    extends BasePooledObjectFactory<Transformer> {
        private static Logger cat = LoggerFactory.getLogger(EPPTransformerPoolFactory.class);

        private EPPTransformerPoolFactory() {
        }

        public void activateObject(PooledObject<Transformer> aTransformer) throws Exception {
            cat.debug("Transformer activating from the pool: " + aTransformer);
            super.activateObject(aTransformer);
        }

        public void destroyObject(PooledObject<Transformer> aTransformer) throws Exception {
            cat.debug("Transformer being deleted from the pool: " + aTransformer);
            super.destroyObject(aTransformer);
        }

        public void passivateObject(PooledObject<Transformer> aTransformer) throws Exception {
            cat.debug("Transformer being passivated in the pool: " + aTransformer);
            super.passivateObject(aTransformer);
        }

        public Transformer create() throws Exception {
            TransformerFactory theTransformerFactory = TransformerFactory.newInstance();
            Transformer theTransformer = null;
            try {
                theTransformer = theTransformerFactory.newTransformer();
            }
            catch (TransformerConfigurationException e) {
                cat.error("EPPTransformerPoolFactory.create(): Couldn't instantiate transformer instance", (Throwable)e);
            }
            cat.debug("Transformer created for the pool: " + theTransformer);
            return theTransformer;
        }

        public PooledObject<Transformer> wrap(Transformer aTransformer) {
            return new DefaultPooledObject((Object)aTransformer);
        }
    }
}

