/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.util;

import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCreateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoResp;
import com.verisign.epp.codec.defReg.EPPDefRegTransferCmd;
import com.verisign.epp.codec.defReg.EPPDefRegUpdateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.loginsec.v1_0.EPPLoginSec;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoInputResult;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAuthInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.pool.parser.EPPSchemaCachingParserPool;
import com.verisign.epp.pool.transformer.EPPTransformerPool;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLByteArray;
import com.verisign.epp.util.EPPXMLStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EPPSecureSendReceiveLogger
implements EPPSendReceiveLogger {
    private static final String ATTR_MASKED = "MASKED";
    private static Logger cat = LoggerFactory.getLogger(EPPSecureSendReceiveLogger.class);
    private static Logger packetCat = LoggerFactory.getLogger((String)(EPPXMLStream.class.getName() + ".packet"));
    static Pattern xmlTypeErrorPattern = Pattern.compile("^(.*Value ').+(' with .*type ')(pwType|pwAuthInfoType)('.*)$");

    @Override
    public void logSend(byte[] aPacket, EPPMessage aMessage) {
        cat.debug("logSend(byte[], EPPMessage): enter");
        EPPMessage theMessage = (EPPMessage)this.maskMessage(aMessage);
        if (theMessage == aMessage) {
            this.log("writePacket() : Sending [", aPacket, theMessage);
        } else {
            this.log("writePacket() : Sending [", null, theMessage);
        }
        cat.debug("logSend(byte[], EPPMessage): exit");
    }

    @Override
    public void logReceive(byte[] aPacket, EPPMessage aMessage) {
        cat.debug("logReceive(byte[], EPPMessage): enter");
        EPPMessage theMessage = (EPPMessage)this.maskMessage(aMessage);
        if (theMessage == aMessage) {
            this.log("decodePacket() : Received [", aPacket, theMessage);
        } else {
            this.log("decodePacket() : Received [", null, theMessage);
        }
        cat.debug("logReceive(byte[], EPPMessage): exit");
    }

    @Override
    public String maskString(String aString) {
        cat.debug("maskString(String): enter");
        if (aString == null) {
            return aString;
        }
        String maskedString = aString;
        Matcher theMatcher = xmlTypeErrorPattern.matcher(aString);
        if (theMatcher.matches()) {
            maskedString = theMatcher.group(1) + ATTR_MASKED + theMatcher.group(2) + theMatcher.group(3) + theMatcher.group(4);
        }
        cat.debug("maskString(String): exit");
        return maskedString;
    }

    @Override
    public EPPCodecComponent maskMessage(EPPCodecComponent aMessage) {
        EPPCodecComponent theExt;
        cat.debug("maskMessage(EPPCodecComponent): enter");
        if (aMessage == null) {
            return aMessage;
        }
        EPPMessage theMessage = null;
        if (aMessage instanceof EPPLoginCmd || aMessage instanceof EPPDomainCreateCmd || aMessage instanceof EPPDomainUpdateCmd || aMessage instanceof EPPDomainTransferCmd || aMessage instanceof EPPDomainInfoCmd || aMessage instanceof EPPDomainInfoResp || aMessage instanceof EPPContactCreateCmd || aMessage instanceof EPPContactUpdateCmd || aMessage instanceof EPPContactTransferCmd || aMessage instanceof EPPContactInfoCmd || aMessage instanceof EPPContactInfoResp || aMessage instanceof EPPEmailFwdCreateCmd || aMessage instanceof EPPEmailFwdUpdateCmd || aMessage instanceof EPPEmailFwdTransferCmd || aMessage instanceof EPPEmailFwdInfoCmd || aMessage instanceof EPPEmailFwdInfoResp || aMessage instanceof EPPDefRegCreateCmd || aMessage instanceof EPPDefRegUpdateCmd || aMessage instanceof EPPDefRegTransferCmd || aMessage instanceof EPPDefRegInfoCmd || aMessage instanceof EPPDefRegInfoResp || aMessage instanceof EPPNameWatchCreateCmd || aMessage instanceof EPPNameWatchUpdateCmd || aMessage instanceof EPPNameWatchTransferCmd || aMessage instanceof EPPNameWatchInfoCmd || aMessage instanceof EPPNameWatchInfoResp || aMessage instanceof EPPNameVerificationCreateCmd || aMessage instanceof EPPNameVerificationUpdateCmd || aMessage instanceof EPPNameVerificationInfoCmd || aMessage instanceof EPPNameVerificationInfoResp) {
            try {
                theMessage = (EPPMessage)aMessage.clone();
            }
            catch (CloneNotSupportedException ex) {
                cat.error("Exception cloning " + aMessage.getClass().getName() + ": " + ex);
                return aMessage;
            }
        } else {
            cat.debug("maskMessage(EPPCodecComponent): exit - no masking needed");
            return aMessage;
        }
        if (theMessage instanceof EPPLoginCmd) {
            cat.debug(EPPLoginCmd.class.getName() + " attributes masked");
            EPPLoginCmd theLoginCmd = (EPPLoginCmd)theMessage;
            theLoginCmd.setPassword(ATTR_MASKED);
            if (theLoginCmd.hasNewPassword()) {
                theLoginCmd.setNewPassword(ATTR_MASKED);
            }
            if (theLoginCmd.hasExtension(EPPLoginSec.class)) {
                cat.debug("com.verisign.epp.codec.loginsec.v1_0.EPPLoginSec attributes masked");
                theExt = (EPPLoginSec)theLoginCmd.getExtension(EPPLoginSec.class);
                if (((EPPLoginSec)theExt).hasPassword()) {
                    ((EPPLoginSec)theExt).setPassword(ATTR_MASKED);
                }
                if (((EPPLoginSec)theExt).hasNewPassword()) {
                    ((EPPLoginSec)theExt).setNewPassword(ATTR_MASKED);
                }
            }
        }
        if (theMessage instanceof EPPDomainCreateCmd) {
            cat.debug(EPPDomainCreateCmd.class.getName() + " attributes masked");
            EPPDomainCreateCmd theDomainCreateCmd = (EPPDomainCreateCmd)theMessage;
            theDomainCreateCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            if (theDomainCreateCmd.hasExtension(EPPRelatedDomainExtCreate.class)) {
                cat.debug(EPPRelatedDomainExtCreate.class.getName() + " attributes masked");
                theExt = (EPPRelatedDomainExtCreate)theDomainCreateCmd.getExtension(EPPRelatedDomainExtCreate.class);
                if (((EPPRelatedDomainExtCreate)theExt).hasDomains()) {
                    for (EPPRelatedDomainExtDomain domain : ((EPPRelatedDomainExtCreate)theExt).getDomains()) {
                        if (!domain.hasAuthInfo()) continue;
                        domain.setAuthInfo(new EPPRelatedDomainExtAuthInfo(ATTR_MASKED));
                    }
                }
            }
        }
        if (theMessage instanceof EPPDomainUpdateCmd) {
            cat.debug(EPPDomainUpdateCmd.class.getName() + " attributes masked");
            EPPDomainUpdateCmd theDomainUpdateCmd = (EPPDomainUpdateCmd)theMessage;
            if (theDomainUpdateCmd.getChange() != null && theDomainUpdateCmd.getChange().getAuthInfo() != null) {
                theDomainUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPDomainTransferCmd) {
            cat.debug(EPPDomainTransferCmd.class.getName() + " attributes masked");
            EPPDomainTransferCmd theDomainTransferCmd = (EPPDomainTransferCmd)theMessage;
            if (theDomainTransferCmd.getAuthInfo() != null) {
                theDomainTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
            if (theDomainTransferCmd.hasExtension(EPPRelatedDomainExtTransfer.class)) {
                cat.debug(EPPRelatedDomainExtTransfer.class.getName() + " attributes masked");
                theExt = (EPPRelatedDomainExtTransfer)theDomainTransferCmd.getExtension(EPPRelatedDomainExtTransfer.class);
                if (((EPPRelatedDomainExtTransfer)theExt).hasDomains()) {
                    for (EPPRelatedDomainExtDomain domain : ((EPPRelatedDomainExtTransfer)theExt).getDomains()) {
                        if (!domain.hasAuthInfo()) continue;
                        domain.setAuthInfo(new EPPRelatedDomainExtAuthInfo(ATTR_MASKED));
                    }
                }
            }
        }
        if (theMessage instanceof EPPDomainInfoCmd) {
            cat.debug(EPPDomainInfoCmd.class.getName() + " attributes masked");
            ((EPPDomainInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDomainInfoResp) {
            cat.debug(EPPDomainInfoResp.class.getName() + " attributes masked");
            ((EPPDomainInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPContactCreateCmd) {
            cat.debug(EPPContactCreateCmd.class.getName() + " attributes masked");
            ((EPPContactCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPContactUpdateCmd) {
            cat.debug(EPPContactUpdateCmd.class.getName() + " attributes masked");
            EPPContactUpdateCmd theContactUpdateCmd = (EPPContactUpdateCmd)theMessage;
            if (theContactUpdateCmd.getChange() != null && theContactUpdateCmd.getChange().getAuthInfo() != null) {
                theContactUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPContactTransferCmd) {
            cat.debug(EPPContactTransferCmd.class.getName() + " attributes masked");
            EPPContactTransferCmd theContactTransferCmd = (EPPContactTransferCmd)theMessage;
            if (theContactTransferCmd.getAuthInfo() != null) {
                theContactTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPContactInfoCmd) {
            cat.debug(EPPContactInfoCmd.class.getName() + " attributes masked");
            ((EPPContactInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPContactInfoResp) {
            cat.debug(EPPContactInfoResp.class.getName() + " attributes masked");
            ((EPPContactInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPEmailFwdCreateCmd) {
            cat.debug(EPPEmailFwdCreateCmd.class.getName() + " attributes masked");
            ((EPPEmailFwdCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPEmailFwdUpdateCmd) {
            cat.debug(EPPEmailFwdUpdateCmd.class.getName() + " attributes masked");
            EPPEmailFwdUpdateCmd theEmailFwdUpdateCmd = (EPPEmailFwdUpdateCmd)theMessage;
            if (theEmailFwdUpdateCmd.getChange() != null && theEmailFwdUpdateCmd.getChange().getAuthInfo() != null) {
                theEmailFwdUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPEmailFwdTransferCmd) {
            cat.debug(EPPEmailFwdTransferCmd.class.getName() + " attributes masked");
            EPPEmailFwdTransferCmd theEmailFwdTransferCmd = (EPPEmailFwdTransferCmd)theMessage;
            if (theEmailFwdTransferCmd.getAuthInfo() != null) {
                theEmailFwdTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPEmailFwdInfoCmd) {
            cat.debug(EPPEmailFwdInfoCmd.class.getName() + " attributes masked");
            ((EPPEmailFwdInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPEmailFwdInfoResp) {
            cat.debug(EPPEmailFwdInfoResp.class.getName() + " attributes masked");
            ((EPPEmailFwdInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDefRegCreateCmd) {
            cat.debug(EPPDefRegCreateCmd.class.getName() + " attributes masked");
            ((EPPDefRegCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDefRegUpdateCmd) {
            cat.debug(EPPDefRegUpdateCmd.class.getName() + " attributes masked");
            EPPDefRegUpdateCmd theDefRegUpdateCmd = (EPPDefRegUpdateCmd)theMessage;
            if (theDefRegUpdateCmd.getChange() != null && theDefRegUpdateCmd.getChange().getAuthInfo() != null) {
                theDefRegUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPDefRegTransferCmd) {
            cat.debug(EPPDefRegTransferCmd.class.getName() + " attributes masked");
            EPPDefRegTransferCmd theDefRegTransferCmd = (EPPDefRegTransferCmd)theMessage;
            if (theDefRegTransferCmd.getAuthInfo() != null) {
                theDefRegTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPDefRegInfoCmd) {
            cat.debug(EPPDefRegInfoCmd.class.getName() + " attributes masked");
            ((EPPDefRegInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDefRegInfoResp) {
            cat.debug(EPPDefRegInfoResp.class.getName() + " attributes masked");
            ((EPPDefRegInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameWatchCreateCmd) {
            cat.debug(EPPNameWatchCreateCmd.class.getName() + " attributes masked");
            ((EPPNameWatchCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameWatchUpdateCmd) {
            cat.debug(EPPNameWatchUpdateCmd.class.getName() + " attributes masked");
            EPPNameWatchUpdateCmd theNameWatchUpdateCmd = (EPPNameWatchUpdateCmd)theMessage;
            if (theNameWatchUpdateCmd.getChange() != null && theNameWatchUpdateCmd.getChange().getAuthInfo() != null) {
                theNameWatchUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPNameWatchTransferCmd) {
            cat.debug(EPPNameWatchTransferCmd.class.getName() + " attributes masked");
            EPPNameWatchTransferCmd theNameWatchTransferCmd = (EPPNameWatchTransferCmd)theMessage;
            if (theNameWatchTransferCmd.getAuthInfo() != null) {
                theNameWatchTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPNameWatchInfoCmd) {
            cat.debug(EPPNameWatchInfoCmd.class.getName() + " attributes masked");
            ((EPPNameWatchInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameWatchInfoResp) {
            cat.debug(EPPNameWatchInfoResp.class.getName() + " attributes masked");
            ((EPPNameWatchInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameVerificationCreateCmd) {
            cat.debug(EPPNameVerificationCreateCmd.class.getName() + " attributes masked");
            ((EPPNameVerificationCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameVerificationUpdateCmd) {
            cat.debug(EPPNameVerificationUpdateCmd.class.getName() + " attributes masked");
            EPPNameVerificationUpdateCmd theNameVerificationUpdateCmd = (EPPNameVerificationUpdateCmd)theMessage;
            if (theNameVerificationUpdateCmd.getAuthInfo() != null) {
                theNameVerificationUpdateCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPNameVerificationInfoCmd) {
            cat.debug(EPPNameVerificationInfoCmd.class.getName() + " attributes masked");
            ((EPPNameVerificationInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameVerificationInfoResp) {
            cat.debug(EPPNameVerificationInfoResp.class.getName() + " attributes masked");
            EPPNameVerificationInfoResp theNameVerificationInfoResp = (EPPNameVerificationInfoResp)theMessage;
            if (theNameVerificationInfoResp.getCreateResult() instanceof EPPNameVerificationInfoInputResult) {
                EPPNameVerificationInfoInputResult result = (EPPNameVerificationInfoInputResult)theNameVerificationInfoResp.getCreateResult();
                result.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        cat.debug("maskMessage(EPPCodecComponent): exit - message masked");
        return theMessage;
    }

    private void log(String logPrefix, byte[] aPacket, EPPMessage aMessage) {
        cat.debug("log(byte[], EPPMessage): enter");
        if (!packetCat.isDebugEnabled()) {
            return;
        }
        if (aPacket != null) {
            packetCat.debug(logPrefix + new String(aPacket) + "]");
        } else if (aMessage != null) {
            try {
                Document theDoc = EPPCodec.getInstance().encode(aMessage);
                EPPXMLByteArray theByteArray = new EPPXMLByteArray(EPPSchemaCachingParserPool.getInstance().getPool(), EPPTransformerPool.getInstance().getPool());
                byte[] thePacket = theByteArray.encode(theDoc);
                packetCat.debug(logPrefix + new String(thePacket) + "]");
            }
            catch (EPPException ex) {
                cat.error("log(byte[], EPPMessage); Error encoding message: " + ex);
                return;
            }
        } else {
            cat.error("log(byte[], EPPMessage); Both aPacket and aMessage are null");
        }
        cat.debug("log(byte[], EPPMessage): exit");
    }
}

