/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckCmd;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckResp;
import com.verisign.epp.codec.validate.v02.EPPValidateContact;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class EPPValidate {
    private EPPSession session = null;
    private String transId = null;
    private Vector extensions = null;
    private List<EPPValidateContact> contacts = new ArrayList<EPPValidateContact>();

    public EPPValidate(EPPSession aSession) {
        this.session = aSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void setTransId(String aTransId) {
        this.transId = aTransId;
    }

    public void addContact(EPPValidateContact aContact) {
        this.contacts.add(aContact);
    }

    public EPPValidateCheckResp sendCheck() throws EPPCommandException {
        if (this.contacts == null || this.contacts.isEmpty()) {
            throw new EPPCommandException("At least one contact must be set for sendCheck()");
        }
        EPPValidateCheckCmd theCommand = new EPPValidateCheckCmd(this.transId, this.contacts);
        theCommand.setExtensions(this.extensions);
        this.resetValidate();
        return (EPPValidateCheckResp)this.session.processDocument(theCommand, EPPValidateCheckResp.class);
    }

    protected void resetValidate() {
        this.contacts = new ArrayList<EPPValidateContact>();
    }

    public EPPResponse getResponse() {
        return this.session.getResponse();
    }
}

