/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.framework.EPPPollDataRecord;
import com.verisign.epp.framework.EPPPollDataSource;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueException;
import java.util.Hashtable;

public class EPPPollQueueMgr {
    private static EPPPollQueueMgr theQueueMgr = new EPPPollQueueMgr();
    private EPPPollDataSource dataSource = null;
    private Hashtable handlers = new Hashtable();

    private EPPPollQueueMgr() {
    }

    public static EPPPollQueueMgr getInstance() {
        return theQueueMgr;
    }

    public EPPPollDataSource getDataSource() {
        return this.dataSource;
    }

    public void register(EPPPollHandler aHandler) {
        this.handlers.put(aHandler.getKind(), aHandler);
    }

    public void setDataSource(EPPPollDataSource aSource) {
        this.dataSource = aSource;
    }

    public EPPResponse get(Object aRecp, Object aContextData) throws EPPPollQueueException {
        EPPPollDataRecord theRecord = null;
        try {
            theRecord = this.dataSource.get(aRecp, aContextData);
        }
        catch (EPPPollQueueException ex) {
            if (ex.getType() == 1) {
                EPPResponse theResponse = new EPPResponse();
                theResponse.setResult(1300, "Command completed successfully; no messages");
                return theResponse;
            }
            throw ex;
        }
        EPPPollHandler theHandler = (EPPPollHandler)this.handlers.get(theRecord.getKind());
        if (theHandler == null) {
            throw new EPPPollQueueException("Handler for kind " + theRecord.getKind() + " does not exist");
        }
        return theHandler.toResponse(theRecord);
    }

    public void put(Object aRecp, String aKind, Object aData, Object aContextData) throws EPPPollQueueException {
        this.dataSource.put(aRecp, aKind, aData, aContextData);
    }

    public EPPResponse delete(Object aRecp, String aMsgId, Object aContextData) throws EPPPollQueueException {
        int queueSize = 0;
        try {
            queueSize = this.dataSource.delete(aRecp, aMsgId, aContextData);
        }
        catch (EPPPollQueueException ex) {
            if (ex.getType() == 2) {
                EPPResult theResult = new EPPResult(2303);
                theResult.addValue("<poll msgID=\"" + aMsgId + "\" op=\"ack\"/>");
                EPPResponse theResponse = new EPPResponse();
                theResponse.setResult(theResult);
                return theResponse;
            }
            throw ex;
        }
        EPPResult theResult = new EPPResult(1000);
        EPPResponse theResponse = new EPPResponse();
        theResponse.setResult(theResult);
        theResponse.setMsgQueue(new EPPMsgQueue(Long.valueOf(queueSize), aMsgId));
        return theResponse;
    }
}

