/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.whois;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPWhoisInfData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPWhoisInfData.class);
    public static final String ELM_NAME = "whoisInf:whoisInfData";
    private static final String ELM_REGISTRAR = "whoisInf:registrar";
    private static final String ELM_WHOIS_SERVER = "whoisInf:whoisServer";
    private static final String ELM_URL = "whoisInf:url";
    private static final String ELM_IRIS_SERVER = "whoisInf:irisServer";
    private String registrar = null;
    private String whoisServer = null;
    private String url = null;
    private String irisServer = null;

    public EPPWhoisInfData() {
    }

    public EPPWhoisInfData(String aRegistrar) {
        this.registrar = aRegistrar;
    }

    public EPPWhoisInfData(String aRegistrar, String aWhoisServer, String aURL) {
        this.registrar = aRegistrar;
        this.whoisServer = aWhoisServer;
        this.url = aURL;
    }

    public EPPWhoisInfData(String aRegistrar, String aWhoisServer, String aURL, String aIrisServer) {
        this(aRegistrar, aWhoisServer, aURL);
        this.irisServer = aIrisServer;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPWhoisInfData clone = null;
        clone = (EPPWhoisInfData)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.registrar == null) {
            throw new EPPEncodeException("EPPWhoisInfData.encode(): Required registrar attribute is null");
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPWhoisInfData.encode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/whoisInf-1.0", ELM_NAME);
        root.setAttribute("xmlns:whoisInf", "http://www.verisign.com/epp/whoisInf-1.0");
        EPPUtil.encodeString(aDocument, root, this.registrar, "http://www.verisign.com/epp/whoisInf-1.0", ELM_REGISTRAR);
        EPPUtil.encodeString(aDocument, root, this.whoisServer, "http://www.verisign.com/epp/whoisInf-1.0", ELM_WHOIS_SERVER);
        EPPUtil.encodeString(aDocument, root, this.url, "http://www.verisign.com/epp/whoisInf-1.0", ELM_URL);
        EPPUtil.encodeString(aDocument, root, this.irisServer, "http://www.verisign.com/epp/whoisInf-1.0", ELM_IRIS_SERVER);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.registrar = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whoisInf-1.0", ELM_REGISTRAR);
        this.whoisServer = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whoisInf-1.0", ELM_WHOIS_SERVER);
        this.url = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whoisInf-1.0", ELM_URL);
        this.irisServer = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/whoisInf-1.0", ELM_IRIS_SERVER);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPWhoisInfData)) {
            return false;
        }
        EPPWhoisInfData theComp = (EPPWhoisInfData)aObject;
        if (!(this.registrar != null ? this.registrar.equals(theComp.registrar) : theComp.registrar == null)) {
            cat.error("EPPWhoisInfData.equals(): registrar not equal");
            return false;
        }
        if (!(this.whoisServer != null ? this.whoisServer.equals(theComp.whoisServer) : theComp.whoisServer == null)) {
            cat.error("EPPWhoisInfData.equals(): whoisServer not equal");
            return false;
        }
        if (!(this.url != null ? this.url.equals(theComp.url) : theComp.url == null)) {
            cat.error("EPPWhoisInfData.equals(): url not equal");
            return false;
        }
        if (!(this.irisServer != null ? this.irisServer.equals(theComp.irisServer) : theComp.irisServer == null)) {
            cat.error("EPPWhoisInfData.equals(): irisServer not equal");
            return false;
        }
        return true;
    }

    public String getRegistrar() {
        return this.registrar;
    }

    public void setFlag(String aRegistrar) {
        this.registrar = aRegistrar;
    }

    public String getWhoisServer() {
        return this.whoisServer;
    }

    public void setWhoisServer(String aWhoisServer) {
        this.whoisServer = aWhoisServer;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String aURL) {
        this.url = aURL;
    }

    public String getIrisServer() {
        return this.irisServer;
    }

    public void setIrisServer(String aIrisServer) {
        this.irisServer = aIrisServer;
    }

    @Override
    public String getNamespace() {
        return "http://www.verisign.com/epp/whoisInf-1.0";
    }
}

