/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeProfile;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPVerificationCodeInfData
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPVerificationCodeInfData.class);
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "verificationCode:infData";
    private static final String ELM_STATUS = "status";
    Status status = Status.NON_COMPLIANT;
    private List<EPPVerificationCodeProfile> profiles = new ArrayList<EPPVerificationCodeProfile>();

    public EPPVerificationCodeInfData() {
    }

    public EPPVerificationCodeInfData(Status aStatus) {
        this.status = aStatus;
    }

    public EPPVerificationCodeInfData(Status aStatus, EPPVerificationCodeProfile aProfile) {
        this.status = aStatus;
        this.addProfile(aProfile);
    }

    public EPPVerificationCodeInfData(Status aStatus, List<EPPVerificationCodeProfile> aProfiles) {
        this.status = aStatus;
        this.profiles = aProfiles;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPVerificationCodeInfData clone = (EPPVerificationCodeInfData)super.clone();
        clone.status = this.status;
        clone.profiles = new ArrayList<EPPVerificationCodeProfile>(this.profiles.size());
        for (EPPVerificationCodeProfile profile : this.profiles) {
            clone.profiles.add((EPPVerificationCodeProfile)profile.clone());
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPVerificationCodeInfData.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:verificationCode-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.status.toString(), "urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:status");
        if (this.hasProfiles()) {
            EPPUtil.encodeCompList(aDocument, root, this.profiles);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.status = Status.getStatus(EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", ELM_STATUS));
        this.profiles = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:verificationCode-1.0", "verificationCode:profile", EPPVerificationCodeProfile.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPVerificationCodeInfData)) {
            cat.error("EPPVerificationCodeInfData.equals(): " + aObject.getClass().getName() + " not EPPVerificationCodeInfData instance");
            return false;
        }
        EPPVerificationCodeInfData other = (EPPVerificationCodeInfData)aObject;
        if (!EqualityUtil.equals((Object)this.status, (Object)other.status)) {
            cat.error("EPPVerificationCodeInfData.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.profiles, other.profiles)) {
            cat.error("EPPVerificationCodeInfData.equals(): profiles not equal");
            return false;
        }
        return true;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status aStatus) {
        this.status = aStatus;
    }

    public boolean hasProfiles() {
        return !this.profiles.isEmpty();
    }

    public List<EPPVerificationCodeProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<EPPVerificationCodeProfile> aProfiles) {
        this.profiles = aProfiles == null ? new ArrayList<EPPVerificationCodeProfile>() : aProfiles;
    }

    public void addProfile(EPPVerificationCodeProfile aProfile) {
        this.profiles.add(aProfile);
    }

    public boolean hasProfile() {
        return !this.profiles.isEmpty() && this.profiles.size() == 1;
    }

    public EPPVerificationCodeProfile getProfile() {
        if (this.hasProfiles()) {
            return this.profiles.get(0);
        }
        return null;
    }

    public void setProfile(EPPVerificationCodeProfile aProfile) {
        this.profiles = new ArrayList<EPPVerificationCodeProfile>();
        this.profiles.add(aProfile);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:verificationCode-1.0";
    }

    public static enum Status {
        NOT_APPLICABLE("notApplicable"),
        NON_COMPLIANT("nonCompliant"),
        PENDING_COMPLIANCE("pendingCompliance"),
        COMPLIANT("compliant");

        private final String statusStr;

        private Status(String aStatusStr) {
            this.statusStr = aStatusStr;
        }

        public static Status getStatus(String aString) {
            if (aString.equals(Status.NOT_APPLICABLE.statusStr)) {
                return NOT_APPLICABLE;
            }
            if (aString.equals(Status.NON_COMPLIANT.statusStr)) {
                return NON_COMPLIANT;
            }
            if (aString.equals(Status.PENDING_COMPLIANCE.statusStr)) {
                return PENDING_COMPLIANCE;
            }
            if (aString.equals(Status.COMPLIANT.statusStr)) {
                return COMPLIANT;
            }
            throw new InvalidParameterException("Status enum value of " + aString + " is not valid.");
        }

        public String toString() {
            return this.statusStr;
        }
    }
}

