/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.v02.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.util.EqualityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryRGP
implements EPPCodecComponent {
    private static Logger cat = LoggerFactory.getLogger(EPPRegistryRGP.class);
    public static final String ELM_LOCALNAME = "rgp";
    public static final String ELM_NAME = "registry:rgp";
    private EPPRegistryRedemptionPeriodType redemptionPeriod = null;
    private EPPRegistryPendingRestorePeriodType pendingRestorePeriod = null;
    private EPPRegistryPendingDeletePeriodType pendingDeletePeriod = null;

    public EPPRegistryRGP() {
    }

    public EPPRegistryRGP(EPPRegistryRedemptionPeriodType aRedemptionPeriod, EPPRegistryPendingRestorePeriodType aPendingRestorePeriod, EPPRegistryPendingDeletePeriodType aPendingDeletePeriod) {
        this.redemptionPeriod = aRedemptionPeriod;
        this.pendingRestorePeriod = aPendingRestorePeriod;
        this.pendingDeletePeriod = aPendingDeletePeriod;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryRGP.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.redemptionPeriod);
        EPPUtil.encodeComp(aDocument, root, this.pendingRestorePeriod);
        EPPUtil.encodeComp(aDocument, root, this.pendingDeletePeriod);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.redemptionPeriod = (EPPRegistryRedemptionPeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "redemptionPeriod", EPPRegistryRedemptionPeriodType.class);
        this.pendingRestorePeriod = (EPPRegistryPendingRestorePeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "pendingRestore", EPPRegistryPendingRestorePeriodType.class);
        this.pendingDeletePeriod = (EPPRegistryPendingDeletePeriodType)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "pendingDelete", EPPRegistryPendingDeletePeriodType.class);
    }

    void validateState() throws EPPCodecException {
        if (this.redemptionPeriod == null) {
            throw new EPPCodecException("redemptionPeriod element is not set");
        }
        if (this.pendingRestorePeriod == null) {
            throw new EPPCodecException("pendingRestorePeriod element is not set");
        }
        if (this.pendingDeletePeriod == null) {
            throw new EPPCodecException("pendingDeletePeriod element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryRGP clone = (EPPRegistryRGP)super.clone();
        if (this.redemptionPeriod != null) {
            clone.redemptionPeriod = (EPPRegistryRedemptionPeriodType)this.redemptionPeriod.clone();
        }
        if (this.pendingRestorePeriod != null) {
            clone.pendingRestorePeriod = (EPPRegistryPendingRestorePeriodType)this.pendingRestorePeriod.clone();
        }
        if (this.pendingDeletePeriod != null) {
            clone.pendingDeletePeriod = (EPPRegistryPendingDeletePeriodType)this.pendingDeletePeriod.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryRGP)) {
            return false;
        }
        EPPRegistryRGP theComp = (EPPRegistryRGP)aObject;
        if (!EqualityUtil.equals(this.redemptionPeriod, theComp.redemptionPeriod)) {
            cat.error("EPPRegistryRGP.equals(): redemptionPeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pendingRestorePeriod, theComp.pendingRestorePeriod)) {
            cat.error("EPPRegistryRGP.equals(): pendingRestorePeriod not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.pendingDeletePeriod, theComp.pendingDeletePeriod)) {
            cat.error("EPPRegistryRGP.equals(): pendingDeletePeriod not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryRedemptionPeriodType getRedemptionPeriod() {
        return this.redemptionPeriod;
    }

    public void setRedemptionPeriod(EPPRegistryRedemptionPeriodType aRedemptionPeriod) {
        this.redemptionPeriod = aRedemptionPeriod;
    }

    public EPPRegistryPendingDeletePeriodType getPendingDeletePeriod() {
        return this.pendingDeletePeriod;
    }

    public void setPendingDeletePeriod(EPPRegistryPendingDeletePeriodType aPendingDeletePeriod) {
        this.pendingDeletePeriod = aPendingDeletePeriod;
    }

    public EPPRegistryPendingRestorePeriodType getPendingRestorePeriod() {
        return this.pendingRestorePeriod;
    }

    public void setPendingRestorePeriod(EPPRegistryPendingRestorePeriodType aPendingRestorePeriod) {
        this.pendingRestorePeriod = aPendingRestorePeriod;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }
}

